/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CBRegisto_Promotor;
import fme.CFLib;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_IdProm_3;
import fme._lib;
import fme.fmeApp;

class CBRegisto_AutoFin
extends CBRegisto {
    Frame_IdProm_3 P02 = null;
    int tab_index = 0;

    public String getPagina() {
        return "IdProm_3";
    }

    CBRegisto_AutoFin() {
        this.P02 = (Frame_IdProm_3)fmeApp.Paginas.getPage("IdProm_3");
        if (this.P02 == null) {
            return;
        }
        this.initialize();
    }

    CBRegisto_AutoFin(Frame_IdProm_3 p, int idx) {
        this.P02 = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "AutonomiaFinanc";
        this.started = true;
        CHCampo_Opt opt_BI_ = new CHCampo_Opt("bal_intercalar");
        opt_BI_.setOptions("1", "0");
        opt_BI_.addComponent(this.P02.getJCheckBox_BISim());
        opt_BI_.addComponent(this.P02.getJCheckBox_BINao());
        opt_BI_.dummy = this.P02.jCheckBox_BIClear;
        this.Campos.add(opt_BI_);
        this.Campos.add(new CHCampo_Text("data", this.P02.getJTextField_DataBI(), CFLib.VLD_DATA));
        this.Campos.add(new CHCampo_Text("act_liq", this.P02.getJTextField_Activo(), CFLib.VLD_VALOR));
        this.Campos.add(new CHCampo_Text("cap_prop", this.P02.getJTextField_CapProp(), CFLib.VLD_VALOR_S));
        this.Campos.add(new CHCampo_Text("suprim", this.P02.getJTextField_Sup(), CFLib.VLD_VALOR));
        this.Campos.add(new CHCampo_Text("suprim_cons", this.P02.getJTextField_SupCons(), CFLib.VLD_VALOR));
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        String titulo = "Dados para o C\u00e1lculo da Autonomia Financeira";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        String msg = "";
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        this.extract();
        CBData.Promotor.extract();
        CBRegisto_Promotor promotor = CBData.Promotor;
        String tipo_benef = promotor.getByName((String)"tipo_benef").v;
        if (this.tab_index > 0) {
            promotor = (CBRegisto_Promotor)CBData.ListaCoop.Lista_Promotor.elementAt(this.tab_index - 1);
            tipo_benef = promotor.getByName((String)"tipo_benef").v;
        }
        if (this.getByName("bal_intercalar").isEmpty() && !tipo_benef.equals("310")) {
            err_list.add_msg(new CHValid_Msg("bal_intercalar", "Possui Balan\u00e7o Intercalar certificado por um ROC - %o"));
        }
        if (this.getByName((String)"bal_intercalar").v.equals("1")) {
            msg = "Se h\u00e1 Balan\u00e7o Intercalar: ";
            if (this.getByName("data").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("data", String.valueOf(msg) + "Data - %o"));
            } else {
                int ano = Integer.parseInt(CBData.Params.getByName((String)"ano_cand").v.toString());
                int ano_bal = Integer.parseInt(this.getByName((String)"data").v.substring(0, 4));
                if (ano_bal != ano && ano_bal != ano - 1) {
                    err_list.add_msg(new CHValid_Msg("ano", 'W', "Ano do Balan\u00e7o Intercalar deve ser o mesmo ou o anterior ao de Refer\u00eancia (" + ano + ")"));
                }
            }
            if (this.getByName("act_liq").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("act_liq", String.valueOf(msg) + "Ativo - %o"));
            }
            if (this.getByName("cap_prop").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("cap_prop", String.valueOf(msg) + "Capital Pr\u00f3prio - %o"));
            }
            double suprim = this.getByName("suprim").valueAsDouble();
            double suprim_c = this.getByName("suprim_cons").valueAsDouble();
            if (_lib.round(suprim_c) > _lib.round(suprim)) {
                err_list.add_msg(new CHValid_Msg("suprim_cons", "Suprimentos a consolidar n\u00e3o podem ser superiores a Suprimentos"));
            }
        }
        if (this.getByName((String)"bal_intercalar").v.equals("0")) {
            msg = "Se n\u00e3o h\u00e1 Balan\u00e7o Intercalar: ";
            if (!this.getByName("data").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("data", String.valueOf(msg) + "Data - Neste Caso N\u00e3o Preenche"));
            }
            if (!this.getByName("act_liq").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("act_liq", String.valueOf(msg) + "Ativo - Neste Caso N\u00e3o Preenche"));
            }
            if (!this.getByName("cap_prop").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("cap_prop", String.valueOf(msg) + "Capital Pr\u00f3prio - Neste Caso N\u00e3o Preenche"));
            }
            if (!this.getByName("suprim").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("suprim", String.valueOf(msg) + "Suprimentos - Neste Caso N\u00e3o Preenche"));
            }
            if (!this.getByName("suprim_cons").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("suprim_cons", String.valueOf(msg) + "Suprimentos a Consolidar - Neste Caso N\u00e3o Preenche"));
            }
        }
        return err_list;
    }
}

