/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHCampo;
import fme.CHCampo_Combo;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_IdProm_1;
import fme._lib;
import fme.fmeApp;
import java.util.Date;

class CBRegisto_Promotor
extends CBRegisto {
    Frame_IdProm_1 P01;
    int tab_index = 0;

    public String getPagina() {
        return "IdProm_01";
    }

    CBRegisto_Promotor() {
        this.P01 = (Frame_IdProm_1)fmeApp.Paginas.getPage("IdProm_1");
        if (this.P01 == null) {
            return;
        }
        this.initialize();
    }

    CBRegisto_Promotor(Frame_IdProm_1 p, int idx) {
        this.P01 = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "Promotor";
        this.started = true;
        this.P01.cbd_promotor = this;
        this.Campos.add(new CHCampo_Text("nif", this.P01.getJTextField_NIF(), CFLib.VLD_NIF));
        this.Campos.add(new CHCampo_Text("nome", this.P01.getJTextField_Nome(), null, this));
        this.Campos.add(new CHCampo_Text("morada", this.P01.getJTextField_Morada(), null));
        this.Campos.add(new CHCampo_Text("localidade", this.P01.getJTextField_Localidade(), null));
        this.Campos.add(new CHCampo_Text("cod_postal", this.P01.getJTextField_CodPostal(), CFLib.VLD_COD_POSTAL));
        this.Campos.add(new CHCampo_Text("cod_postal_loc", this.P01.getJTextField_CodPostalLocal(), null));
        this.Campos.add(new CHCampo_Combo("distrito", "Distritos", this.P01.getJComboBox_Distrito(), (CBRegisto)this));
        this.Campos.add(new CHCampo_Combo("concelho", "ConcelhosF1", this.P01.getJComboBox_Concelho(), (CBRegisto)this));
        this.Campos.add(new CHCampo_Text("telefone", this.P01.getJTextField_Telefone(), null));
        this.Campos.add(new CHCampo_Text("telefax", this.P01.getJTextField_Telefax(), null));
        this.Campos.add(new CHCampo_Text("email", this.P01.getJTextField_Email(), CFLib.VLD_EMAIL));
        this.Campos.add(new CHCampo_Text("url", this.P01.getJTextField_Url(), null));
        this.Campos.add(new CHCampo_Combo("tipo_benef", "TipoBenef", this.P01.getJComboBox_TipoBenef(), (CBRegisto)this));
        CHCampo_Opt opt_fins = new CHCampo_Opt("fins_lucro");
        opt_fins.setOptions("1", "0");
        opt_fins.addComponent(this.P01.getJCheckBox_FinsLucro_Sim());
        opt_fins.addComponent(this.P01.getJCheckBox_FinsLucro_Nao());
        opt_fins.dummy = this.P01.jCheckBox_FinsLucro_Clear;
        this.Campos.add(opt_fins);
        this.Campos.add(new CHCampo_Text("dt_const", this.P01.getJTextField_DtConst(), CFLib.VLD_DATA));
        this.Campos.add(new CHCampo_Text("dt_inicio_act", this.P01.getJTextField_DtInicioAct(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("cap_social", this.P01.getJTextField_CapSocial(), CFLib.VLD_VALOR));
        this.Campos.add(new CHCampo_Text("rgc_num", this.P01.getJTextField_Matricula(), null));
        this.Campos.add(new CHCampo_Text("rgc_cons", this.P01.getJTextField_Conservatoria(), null));
        CHCampo_Opt opt_cp = new CHCampo_Opt("cont_publica");
        opt_cp.setOptions("1", "0");
        opt_cp.addComponent(this.P01.getJCheckBox_ContPubl_Sim());
        opt_cp.addComponent(this.P01.getJCheckBox_ContPubl_Nao());
        opt_cp.dummy = this.P01.jCheckBox_ContPubl_Clear;
        this.Campos.add(opt_cp);
        CBData.Params.bind_ano_cand_update(this);
    }

    public void xmlValue(String path, String tag, String v) {
        super.xmlValue(path, tag, v);
        if (CBData.reading_xml && this.tab_index > 0 && CBData.vs_old.startsWith("1.00") && tag.matches("nif|nome")) {
            CBData.ListaCoop.setColValue(tag, this.tab_index - 1, v);
            CBData.ListaCoop.on_update(tag, this.tab_index - 1, v);
        }
    }

    void on_update(String tag) {
        String concelho;
        if (tag.equals("nome")) {
            String empresa_d;
            String empresa;
            CTabelas.Empresas.refresh();
            int j = 0;
            while (j < CBData.QInv.dados.size()) {
                empresa = CBData.QInv.getColValue("coprom", j);
                if (!empresa.equals("")) {
                    empresa_d = CTabelas.Empresas.lookup(0, empresa, 1);
                    CBData.QInv.setColValue("coprom_d", j, empresa_d);
                }
                ++j;
            }
            j = 0;
            while (j < CBData.QuadrosTecn_Conj.dados.size()) {
                empresa = CBData.QuadrosTecn_Conj.getColValue("coprom", j);
                if (!empresa.equals("")) {
                    empresa_d = CTabelas.Empresas.lookup(0, empresa, 1);
                    CBData.QuadrosTecn_Conj.setColValue("coprom_d", j, empresa_d);
                }
                ++j;
            }
        }
        if (tag.equals("concelho") && (concelho = this.getByName("concelho").getStringValue()).length() > 0) {
            this.getByName("distrito").setStringValue(concelho.substring(0, 2));
        }
        if (tag.equals("distrito")) {
            String distrito = this.getByName("distrito").getStringValue();
            String concelho2 = this.getByName("concelho").getStringValue();
            if (concelho2.length() > 0 && !concelho2.substring(0, 2).equals(distrito)) {
                this.getByName("concelho").setStringValue("");
            }
        }
    }

    String on_xml(String tag) {
        String c;
        String s = "";
        if (tag.equals("concelho")) {
            c = this.getByName(tag).getStringValue();
            s = c.length() == 0 ? String.valueOf(s) + "<concelho_d/>\n" : String.valueOf(s) + _lib.xml_encode("concelho_d", CTabelas.Concelhos.getDesign(c));
        }
        if (tag.equals("distrito")) {
            String d = this.getByName(tag).getStringValue();
            s = d.length() == 0 ? String.valueOf(s) + "<distrito_d/>\n" : String.valueOf(s) + _lib.xml_encode("distrito_d", CTabelas.Distritos.getDesign(d));
        }
        if (tag.equals("tipo_benef")) {
            c = this.getByName(tag).getStringValue();
            s = c.length() == 0 ? String.valueOf(s) + "<tipo_benef_d/>\n" : String.valueOf(s) + _lib.xml_encode("tipo_benef_d", CTabelas.TipoBenef.getDesign(c));
        }
        return s;
    }

    boolean isEmpty() {
        int i = 0;
        while (i < this.Campos.size()) {
            block5: {
                CHCampo c;
                block4: {
                    c = (CHCampo)this.Campos.elementAt(i);
                    try {
                        CHCampo_Text c1 = (CHCampo_Text)this.Campos.elementAt(i);
                        if (c1.jcomp.isEditable()) break block4;
                        break block5;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!c.isEmpty()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        String titulo = "Identifica\u00e7\u00e3o do Promotor";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        this.extract();
        if (this.getByName("nif").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nif", "N\u00ba de Identifica\u00e7\u00e3o Fiscal - %o"));
        }
        if (this.getByName("nome").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nome", "Nome ou Designa\u00e7\u00e3o Social - %o"));
        }
        if (this.getByName("morada").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("morada", "Morada (Sede Social) - %o"));
        }
        if (this.getByName("localidade").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("localidade", "Localidade - %o"));
        }
        if (this.getByName("cod_postal").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("cod_postal", "C\u00f3digo Postal - %o"));
        }
        if (this.getByName("cod_postal_loc").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("cod_postal_loc", "C\u00f3digo Postal (localidade) - %o"));
        }
        if (this.getByName("distrito").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("distrito", "Distrito - %o"));
        } else if (this.getByName((String)"distrito").v.equals("99")) {
            err_list.add_msg(new CHValid_Msg("distrito", "Distrito inv\u00e1lido"));
        }
        if (this.getByName("concelho").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("concelho", "Concelho - %o"));
        }
        if (this.getByName("telefone").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("telefone", "Telefone - %o"));
        }
        if (this.getByName("email").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("email", "E-mail - %o"));
        }
        if (!this.getByName("tipo_benef").isEmpty() && this.getByName((String)"tipo_benef").v.matches("220|230|240") && this.getByName("dt_const").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_const", "Data de Constitui\u00e7\u00e3o - %o"));
        }
        if (this.getByName("dt_inicio_act").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_inicio_act", "Data de In\u00edcio de Atividade - %o"));
        } else {
            int ano_c = _lib.to_int(CBData.Params.getByName((String)"ano_cand").v);
            int ano_i = _lib.to_int(this.getByName((String)"dt_inicio_act").v.substring(0, 4));
            if (ano_i > ano_c + 1) {
                err_list.add_msg(new CHValid_Msg("dt_inicio_act", "Data de In\u00edcio de Atividade - fora do intervalo de refer\u00eancia aceit\u00e1vel"));
            }
        }
        Date today = new Date();
        Date dt_const = CFType_Data.parse_date(this.getByName((String)"dt_const").v);
        Date dt_act = CFType_Data.parse_date(this.getByName((String)"dt_inicio_act").v);
        if (dt_const != null && dt_const.after(today)) {
            err_list.add_msg(new CHValid_Msg("dt_const", 'W', "Data de Constitui\u00e7\u00e3o ?"));
        }
        if (dt_const != null && dt_act != null && dt_act.before(dt_const)) {
            err_list.add_msg(new CHValid_Msg("dt_const", "Data de In\u00edcio de Atividade anterior \u00e0 Data de Constitui\u00e7\u00e3o"));
        }
        if (this.getByName("fins_lucro").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("fins_lucro", "Fins Lucrativos - %o"));
        }
        if (!this.getByName("tipo_benef").isEmpty() && this.getByName("cap_social").isEmpty() && this.getByName((String)"tipo_benef").v.matches("220|230|240")) {
            err_list.add_msg(new CHValid_Msg("cap_social", String.valueOf(this.P01.jLabel_CapSocial.getText()) + " - %o"));
        }
        if (this.getByName("tipo_benef").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("tipo_benef", "Tipologia de Benefici\u00e1rio - %o"));
        }
        if (this.getByName("cont_publica").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("cont_publica", "A entidade promotora encontra-se obrigada ao cumprimento do regime legal de contrata\u00e7\u00e3o p\u00fablica...? - %o"));
        }
        return err_list;
    }
}

