/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto_Promotor;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CParseConfig;
import fme.CTabelas;
import fme.Frame_Mercados;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_Mercados
extends CBTabela {
    Frame_Mercados P12;
    int tab_index = 0;
    int n_anos = CParseConfig.hconfig.get("extensao").equals("i20") ? 3 : 1;

    public String getPagina() {
        return "Mercados";
    }

    CBTabela_Mercados() {
        this.tag = "Mercados";
        this.P12 = (Frame_Mercados)fmeApp.Paginas.getPage("Mercados");
        if (this.P12 == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_Mercados(Frame_Mercados p, int idx) {
        this.tag = "Mercados";
        this.tab_index = idx;
        this.P12 = p;
        this.initialize();
    }

    void bind_updates() {
        CBData.Params.bind_ano_cand_update(this);
        CBData.DadosProjecto.bind_dt_fim_update(this);
    }

    void initialize() {
        this.P12.cbd_mercados = this;
        this.started = true;
        this.cols = new CHTabColModel[10];
        this.cols[0] = new CHTabColModel("tipo", "Tipo (id)", true, true, false, null);
        this.cols[1] = new CHTabColModel("tipo_d", "Tipo", false, true, true, null);
        this.cols[2] = new CHTabColModel("bem_serv", "Bem / Servi\u00e7o (id)", true, true, false, null);
        this.cols[3] = new CHTabColModel("bem_serv_d", "Bem / Servi\u00e7o", false, true, true, null);
        this.cols[4] = new CHTabColModel("pais", "Mercado (Pa\u00eds) (id)", true, true, false, null);
        this.cols[5] = new CHTabColModel("pais_d", "Mercado (Pa\u00eds)", false, true, true, null);
        this.cols[6] = new CHTabColModel("quant_pre", "Ano Pr\u00e9-Proj. (Quant.)", true, true, true, CFLib.VLD_NUM_0);
        this.cols[7] = new CHTabColModel("val_pre", "Ano Pr\u00e9-Proj. (Valor)", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[8] = new CHTabColModel("quant_pos", "Ano Fim Proj. +" + this.n_anos + " (Quant.)", true, true, true, CFLib.VLD_NUM_0);
        this.cols[9] = new CHTabColModel("val_pos", "Ano Fim Proj. +" + this.n_anos + " (Valor)", true, true, true, CFLib.VLD_VALOR_0);
        this.init_dados(13);
        this.init_handler(this.P12.getJTable_Mercados());
        this.P12.getJTable_Mercados().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P12.getJScrollPane_Mercados().getWidth();
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.P12.getJTable_Mercados());
        this.ui.add_col(0, 0, 1, 2, "Tipo");
        this.ui.add_col(1, 0, 1, 2, "Bem / Servi\u00e7o");
        this.ui.add_col(2, 0, 1, 2, "<html><div align='center'>Mercado<br>(Pa\u00eds)</div></html>");
        this.ui.add_col(3, 0, 2, 1, "Ano Pr\u00e9-Proj.");
        this.ui.add_col(3, 1, 1, 1, "Quant.");
        this.ui.add_col(4, 1, 1, 1, "Valor");
        this.ui.add_col(5, 0, 2, 1, "Ano Fim Proj.+" + this.n_anos);
        this.ui.add_col(5, 1, 1, 1, "Quant.");
        this.ui.add_col(6, 1, 1, 1, "Valor");
        this.P12.getJTable_Mercados().getTableHeader().setUI(this.ui);
        this.handler.set_col_comboS(1, 0.06, null, CTabelas.TipoMercado, 1, 60);
        this.handler.set_col_comboS(3, 0.18, null, CTabelas.BensServicos, 1, 500);
        this.handler.set_col_comboS(5, 0.098, null, CTabelas.Pais, 1, 200);
        this.handler.set_col_text(6, 0.06, "R");
        this.handler.set_col_text(7, 0.1, "R");
        this.handler.set_col_text(8, 0.06, "R");
        this.handler.set_col_text(9, 0.1, "R");
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("tipo_d")) {
            String tipo = "";
            if (v.length() > 0) {
                tipo = CTabelas.TipoMercado.lookup(1, v, 0);
            }
            this.setColValue("tipo", nRow, tipo);
        }
        if (colname.equals("tipo")) {
            if (v.equals("04")) {
                v = "";
                this.setColValue("tipo", nRow, "");
            }
            String tipo_d = "";
            if (v.length() > 0) {
                tipo_d = CTabelas.TipoMercado.lookup(0, v, 1);
            }
            this.setColValue("tipo_d", nRow, tipo_d);
        }
        if (colname.equals("bem_serv_d")) {
            String bem_serv = "";
            if (v.length() > 0) {
                bem_serv = CTabelas.BensServicos.lookup(1, v, 0);
            }
            this.setColValue("bem_serv", nRow, bem_serv);
        }
        if (colname.equals("bem_serv")) {
            String bem_serv_d = "";
            if (v.length() > 0) {
                bem_serv_d = CTabelas.BensServicos.lookup(0, v, 1);
            }
            this.setColValue("bem_serv_d", nRow, bem_serv_d);
        }
        if (colname.equals("pais_d")) {
            String pais = "";
            if (v.length() > 0) {
                pais = CTabelas.Pais.lookup(1, v, 0);
            }
            this.setColValue("pais", nRow, pais);
        }
        if (colname.equals("pais")) {
            String pais_d = "";
            if (v.length() > 0) {
                pais_d = CTabelas.Pais.lookup(0, v, 1);
            }
            this.setColValue("pais_d", nRow, pais_d);
        }
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("tipo")) {
            s = String.valueOf(s) + _lib.xml_encode("tipo_d", this.getColValue("tipo_d", row));
        }
        if (tag.equals("bem_serv")) {
            s = String.valueOf(s) + _lib.xml_encode("bem_serv_d", this.getColValue("bem_serv_d", row));
        }
        if (tag.equals("pais")) {
            s = String.valueOf(s) + _lib.xml_encode("pais_d", this.getColValue("pais_d", row));
        }
        return s;
    }

    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.P12.getJTable_Mercados());
        this.ui.add_col(0, 0, 1, 2, "Tipo");
        this.ui.add_col(1, 0, 1, 2, "Bem / Servi\u00e7o");
        this.ui.add_col(2, 0, 1, 2, "<html><div align='center'>Mercado<br>(Pa\u00eds)</div></html>");
        this.ui.add_col(3, 1, 1, 1, "Quant.");
        this.ui.add_col(4, 1, 1, 1, "Valor");
        this.ui.add_col(5, 1, 1, 1, "Quant.");
        this.ui.add_col(6, 1, 1, 1, "Valor");
        if (!CBData.Params.getByName((String)"ano_cand").v.equals("")) {
            int ano = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
            this.ui.add_col(3, 0, 2, 1, String.valueOf(ano - 1));
            this.cols[6].col_name = String.valueOf(ano - 1) + " (Quant.)";
            this.cols[7].col_name = String.valueOf(ano - 1) + " (Valor)";
        } else {
            this.ui.add_col(3, 0, 2, 1, "Ano Pr\u00e9-Proj.");
        }
        String dt_fim = CBData.DadosProjecto.getByName((String)"dt_fim").v;
        if (!dt_fim.equals("")) {
            if (dt_fim.length() == 10) {
                int ano_fim = Integer.parseInt(dt_fim.substring(0, 4));
                this.ui.add_col(5, 0, 2, 1, String.valueOf(ano_fim + this.n_anos));
                this.cols[8].col_name = String.valueOf(ano_fim + this.n_anos) + " (Quant.)";
                this.cols[9].col_name = String.valueOf(ano_fim + this.n_anos) + " (Valor)";
            }
        } else {
            this.ui.add_col(5, 0, 2, 1, "Ano Fim Proj.+" + this.n_anos);
        }
        this.P12.getJTable_Mercados().getTableHeader().setUI(this.ui);
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        int idx_i;
        int ano_cand;
        String titulo = "Atividade econ\u00f3mica por mercado";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (!this.started) {
            return err_list;
        }
        if (this.isEmpty() && this.tab_index == 0) {
            err_list.add_msg(new CHValid_Msg("mercados", "Lista vazia"));
        }
        int ano_inicial = ano_cand = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
        String v = CBData.Promotor.getByName((String)"dt_inicio_act").v;
        if (this.tab_index > 0) {
            CBRegisto_Promotor prom = (CBRegisto_Promotor)CBData.ListaCoop.Lista_Promotor.elementAt(this.tab_index - 1);
            v = prom.getByName((String)"dt_inicio_act").v;
        }
        if (v.length() == 10) {
            ano_inicial = Integer.parseInt(v.substring(0, 4));
        }
        if ((idx_i = 6 - (ano_cand - ano_inicial - 1) * 2) < 0) {
            idx_i = 0;
        }
        int j = 0;
        while (j < this.dados.size()) {
            String mask = "-R-R-R----";
            TabError[] e = this.isIncompletAll(j, mask.toString());
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                ++ii;
            }
            if (!this.isRowEmpty(j)) {
                String _msg;
                String s;
                String ano_s;
                int i = 6;
                while (i <= 7) {
                    ano_s = this.cols[i].col_name;
                    s = ((String[])this.dados.elementAt(j))[i];
                    if (i >= idx_i && s.length() == 0) {
                        _msg = "Linha " + (j + 1) + " incompleta: " + ano_s + " - %o";
                        _msg = _msg.replaceAll("\n", " ");
                        _msg = _msg.replaceAll("<br>", " ");
                        _msg = _msg.replaceAll("<html>", "");
                        _msg = _msg.replaceAll("</html>", "");
                        _msg = _msg.replaceAll("<div align='center'>", "");
                        _msg = _msg.replaceAll("</div>", "");
                        err_list.add_msg(new CHValid_Msg("mercados", _msg));
                    }
                    ++i;
                }
                i = 8;
                while (i <= 9) {
                    ano_s = this.cols[i].col_name;
                    s = ((String[])this.dados.elementAt(j))[i];
                    if (s.length() == 0) {
                        _msg = "Linha " + (j + 1) + " incompleta: " + ano_s + " - %o";
                        _msg = _msg.replaceAll("\n", " ");
                        _msg = _msg.replaceAll("<br>", " ");
                        _msg = _msg.replaceAll("<html>", "");
                        _msg = _msg.replaceAll("</html>", "");
                        _msg = _msg.replaceAll("<div align='center'>", "");
                        _msg = _msg.replaceAll("</div>", "");
                        err_list.add_msg(new CHValid_Msg("mercados", _msg));
                    }
                    ++i;
                }
            }
            ++j;
        }
        return err_list;
    }
}

