/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CParseConfig;
import fme.CTabelas;
import fme.Frame_PME;
import fme.GroupableTableHeaderUI;
import fme.Http;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;
import fme.fmeComum;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

class CBTabela_PME
extends CBTabela {
    Frame_PME P01 = null;
    JComboBox cboEstabs;
    boolean col_inov = false;

    public String getPagina() {
        return "PME";
    }

    CBTabela_PME() {
        this.tag = "PME";
        this.P01 = (Frame_PME)fmeApp.Paginas.getPage("PME");
        if (this.P01 == null) {
            return;
        }
        this.col_inov = this.P01.coluna_inov.equals("S");
        this.started = true;
        this.cols = new CHTabColModel[32];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, null);
        this.cols[1] = new CHTabColModel("nif", "NIF", true, true, true, CFLib.VLD_NIF);
        this.cols[2] = new CHTabColModel("design", "Designa\u00e7\u00e3o", true, false, true, null);
        this.cols[3] = new CHTabColModel("dt_contrato", "Data do<br>Acordo<br>de pr\u00e9-ades\u00e3o", true, true, true, CFLib.VLD_DATA);
        this.cols[4] = new CHTabColModel("dimensao", "Dimens\u00e3o (id)", true, true, false, null);
        this.cols[5] = new CHTabColModel("dimensao_d", "Dimens\u00e3o", false, false, true, null);
        this.cols[6] = new CHTabColModel("cae", "CAE", true, false, true, null);
        this.cols[7] = new CHTabColModel("n_pt", "PT", true, true, true, CFLib.VLD_INT);
        this.cols[8] = new CHTabColModel("concelho", "Concelho (id)", true, true, false, null);
        this.cols[9] = new CHTabColModel("concelho_d", "Concelho", false, false, true, null);
        this.cols[10] = new CHTabColModel("excepcao", "Exce\u00e7\u00e3o", true, true, true, null);
        this.cols[10].is_check = true;
        this.cols[11] = new CHTabColModel("concelho_act", "Localiza\u00e7\u00e3o do Investimento (id)", true, true, false, null);
        this.cols[12] = new CHTabColModel("concelho_act_d", "Localiza\u00e7\u00e3o do Investimento", false, true, true, null);
        this.cols[13] = new CHTabColModel("pergunta_1", "", true, true, false, null);
        this.cols[14] = new CHTabColModel("pergunta_2", "", true, true, false, null);
        this.cols[15] = new CHTabColModel("txt_outra", "", true, true, false, null);
        this.cols[16] = new CHTabColModel("nuts_ii", "NUTS II (id)", true, true, false, null);
        this.cols[17] = new CHTabColModel("vol_neg_tt_pre", "Volume de Neg\u00f3cios Total (Pr\u00e9-Projeto)", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[18] = new CHTabColModel("vol_neg_tt_pos", "Volume de Neg\u00f3cios Total (P\u00f3s-Projeto)", true, true, true, CFLib.VLD_VALOR);
        this.cols[19] = new CHTabColModel("vol_neg_ext_pre", "Volume de Neg\u00f3cios no Exterior (Pr\u00e9-Projeto)", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[20] = new CHTabColModel("vol_neg_ext_pos", "Volume de Neg\u00f3cios no Exterior (P\u00f3s-Projeto)", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[21] = new CHTabColModel("int_exp_pre", "Intensidade de Exporta\u00e7\u00e3o (Pr\u00e9-Projeto) (%)", true, false, true, CFLib.VLD_PERC_0);
        this.cols[22] = new CHTabColModel("int_exp_pos", "Intensidade de Exporta\u00e7\u00e3o (P\u00f3s-Projeto) (%)", true, false, true, CFLib.VLD_PERC_0);
        this.cols[23] = new CHTabColModel("marca", "Marca", true, true, true, null);
        this.cols[24] = new CHTabColModel("inov_prod", "Inova\u00e7\u00e3o de Produto ou Servi\u00e7o (id)", true, true, false, null);
        this.cols[25] = new CHTabColModel("inov_prod_d", "Inova\u00e7\u00e3o de Produto ou Servi\u00e7o", false, true, this.col_inov, null);
        this.cols[26] = new CHTabColModel("inov_proc", "Inova\u00e7\u00e3o de Processo (id)", true, true, false, null);
        this.cols[27] = new CHTabColModel("inov_proc_d", "Inova\u00e7\u00e3o de Processo", false, true, this.col_inov, null);
        this.cols[28] = new CHTabColModel("inov_org", "Inova\u00e7\u00e3o Organizacional (id)", true, true, false, null);
        this.cols[29] = new CHTabColModel("inov_org_d", "Inova\u00e7\u00e3o Organizacional", false, true, this.col_inov, null);
        this.cols[30] = new CHTabColModel("inov_mktg", "Inova\u00e7\u00e3o de Marketing (id)", true, true, false, null);
        this.cols[31] = new CHTabColModel("inov_mktg_d", "Inova\u00e7\u00e3o de Marketing", false, true, this.col_inov, null);
        this.init_dados(5);
        this.init_handler(this.P01.getJTable_PME());
        this.P01.getJTable_PME().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P01.getJScrollPane_PME().getWidth() - 2;
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(3, this.P01.getJTable_PME());
        this.ui.add_col(0, 0, 1, 3, "N\u00ba");
        this.ui.add_col(1, 0, 1, 3, "NIF");
        this.ui.add_col(2, 0, 1, 3, "Designa\u00e7\u00e3o");
        this.ui.add_col(3, 0, 1, 3, "<html><div style='text-align:center'>Data do<br>Acordo de<br>pr\u00e9-ades\u00e3o</div></html>");
        this.ui.add_col(4, 0, 1, 3, "Dimens\u00e3o");
        this.ui.add_col(5, 0, 1, 3, "CAE");
        this.ui.add_col(6, 0, 1, 3, "PT");
        this.ui.add_col(7, 0, 1, 3, "Concelho");
        this.ui.add_col(8, 0, 1, 3, "Exce\u00e7\u00e3o");
        this.ui.add_col(9, 0, 1, 3, "<html><div style='text-align:center'>Localiza\u00e7\u00e3o<br>do Investimento</div></html>");
        this.ui.add_col(10, 0, 6, 1, "Volume de Neg\u00f3cios");
        this.ui.add_col(10, 1, 2, 1, "Total");
        this.ui.add_col(12, 1, 2, 1, "no Exterior");
        this.ui.add_col(10, 2, 1, 1, "Pr\u00e9-Projeto");
        this.ui.add_col(11, 2, 1, 1, "P\u00f3s-Projeto");
        this.ui.add_col(12, 2, 1, 1, "Pr\u00e9-Projeto");
        this.ui.add_col(13, 2, 1, 1, "P\u00f3s-Projeto");
        this.ui.add_col(14, 1, 1, 2, "<html><div style='text-align:center'>Intensidade<br>de Exporta\u00e7\u00e3o<br>Pr\u00e9-Projeto (%)</div></html>");
        this.ui.add_col(15, 1, 1, 2, "<html><div style='text-align:center'>Intensidade<br>de Exporta\u00e7\u00e3o<br>P\u00f3s-Projeto (%)</div></html>");
        this.ui.add_col(16, 0, 1, 3, "Marca");
        if (this.col_inov) {
            this.ui.add_col(17, 0, 4, 1, "Tipo de atividade de inova\u00e7\u00e3o introduzida nos \u00faltimos 2 anos");
            this.ui.add_col(17, 1, 1, 2, "<html><div style='text-align:center'>Inova\u00e7\u00e3o<br>de Produto<br>ou Servi\u00e7o</div></html>");
            this.ui.add_col(18, 1, 1, 2, "<html><div style='text-align:center'>Inova\u00e7\u00e3o<br>de Processo</div></html>");
            this.ui.add_col(19, 1, 1, 2, "<html><div style='text-align:center'>Inova\u00e7\u00e3o<br>Organizacional</div></html>");
            this.ui.add_col(20, 1, 1, 2, "<html><div style='text-align:center'>Inova\u00e7\u00e3o<br>de Marketing</div></html>");
        }
        this.P01.getJTable_PME().getTableHeader().setUI(this.ui);
        this.handler.set_col_text(0, 0.03, "C");
        this.handler.set_col_text(1, 0.062, null);
        this.handler.set_col_text(2, 0.186, null);
        this.handler.set_col_text(3, 0.064, null);
        this.handler.set_col_comboS(5, 0.058, null, CTabelas.Dimensao, 1, 60);
        this.handler.set_col_comboD(6, 0.047, null, CTabelas.Cae, 0, 450);
        this.handler.set_col_text(7, 0.047, "R");
        this.handler.set_col_comboS(9, 0.12, null, CTabelas.Concelhos, 1, 200);
        this.handler.set_col_check(10, 0.06);
        this.handler.set_col_textX(12, 0.125, null);
        this.handler.set_col_text(17, 0.081, "R");
        this.handler.set_col_text(18, 0.081, "R");
        this.handler.set_col_text(19, 0.081, "R");
        this.handler.set_col_text(20, 0.081, "R");
        this.handler.set_col_text(21, 0.09, "C");
        this.handler.set_col_text(22, 0.09, "C");
        this.handler.set_col_text(23, 0.15, null);
        if (this.col_inov) {
            this.handler.set_col_comboS(25, 0.08, null, CTabelas.SimNao, 1, 0);
            this.handler.set_col_comboS(27, 0.08, null, CTabelas.SimNao, 1, 0);
            this.handler.set_col_comboS(29, 0.08, null, CTabelas.SimNao, 1, 0);
            this.handler.set_col_comboS(31, 0.08, null, CTabelas.SimNao, 1, 0);
        }
    }

    public void Clear() {
        super.Clear();
        this.init_dados(5);
        this.numerar(0);
        this.handler.j.revalidate();
        this.handler.j.repaint();
    }

    int count_pme() {
        int n = 0;
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.isRowEmpty(i)) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    void numerar(int nCol) {
        String[] velho = new String[this.dados.size()];
        String[] novo = new String[this.dados.size()];
        int n = 1;
        int i = 0;
        while (i < this.dados.size()) {
            velho[i] = ((String[])this.dados.elementAt(i))[nCol];
            novo[i] = Integer.toString(n++);
            ((String[])this.dados.elementAt((int)i))[nCol] = novo[i];
            ++i;
        }
    }

    void update_dados_adc() {
        if (!CBData.T.equals("") || !fmeComum.ON) {
            return;
        }
        int i = 0;
        while (i < this.dados.size()) {
            String nif = this.getColValue("nif", i);
            if (nif.length() == 9) {
                this.get_dados_adc(nif, i);
            }
            ++i;
        }
    }

    void get_dados_adc(String nif, int nRow) {
        if (!CBData.T.equals("") || !fmeComum.ON) {
            return;
        }
        String url = String.valueOf(fmeComum.atend_pas) + "acesso/formulario/atend-import-adc.php?NIF=" + nif + "&QDR=" + this.tag;
        System.out.println("pme " + nif);
        Http http = new Http(url);
        Document doc = http.doPostRequestDoc("");
        try {
            XPath xp = XPathFactory.newInstance().newXPath();
            String design = xp.evaluate("//fme/" + this.tag + "/nome", doc);
            String dimensao = xp.evaluate("//fme/" + this.tag + "/dimensao", doc);
            String cae = xp.evaluate("//fme/" + this.tag + "/cae", doc);
            String concelho = xp.evaluate("//fme/" + this.tag + "/concelho", doc);
            this.setColValue("design", nRow, design);
            this.on_update("design", nRow, design);
            this.setColValue("dimensao", nRow, dimensao);
            this.on_update("dimensao", nRow, dimensao);
            this.setColValue("cae", nRow, cae);
            this.on_update("cae", nRow, cae);
            this.setColValue("concelho", nRow, concelho);
            this.on_update("concelho", nRow, concelho);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void on_update(String colname, int nRow, String v) {
        String concelho_d;
        String concelho;
        this.numerar(0);
        if (!CBData.clear_pg) {
            CTabelas.PME.refresh();
        }
        if (colname.equals("nif") && !CBData.reading_xml) {
            this.setColValue("design", nRow, "");
            this.on_update("design", nRow, "");
            this.setColValue("dimensao", nRow, "");
            this.on_update("dimensao", nRow, "");
            this.setColValue("cae", nRow, "");
            this.on_update("cae", nRow, "");
            this.setColValue("concelho", nRow, "");
            this.on_update("concelho", nRow, "");
            if (v.length() == 9) {
                this.get_dados_adc(v, nRow);
            }
        }
        if (colname.equals("design")) {
            String n_ordem = this.getColValue("n_ordem", nRow);
            int i = 0;
            while (i < CBData.QInv.dados.size()) {
                String empresa = CBData.QInv.getColValue("pme", i);
                if (!empresa.equals("") && n_ordem.equals(empresa)) {
                    String v_qi = CTabelas.PME.lookup(0, empresa, 1);
                    CBData.QInv.setColValue("pme_d", i, v_qi);
                }
                ++i;
            }
        }
        if (colname.startsWith("vol_neg_")) {
            String suffix = colname.substring(colname.lastIndexOf("_") + 1);
            double tt = _lib.to_double(this.getColValue("vol_neg_tt_" + suffix, nRow));
            double ext = _lib.to_double(this.getColValue("vol_neg_ext_" + suffix, nRow));
            this.setColValue("int_exp_" + suffix, nRow, tt == 0.0 ? "" : Double.toString(_lib.round(ext / tt * 100.0)));
        }
        if (colname.equals("dimensao_d")) {
            String dimensao = "";
            if (v.length() > 0) {
                dimensao = CTabelas.Dimensao.lookup(1, v, 0);
            }
            this.setColValue("dimensao", nRow, dimensao);
        }
        if (colname.equals("dimensao")) {
            String dimensao_d = "";
            if (v.length() > 0) {
                dimensao_d = CTabelas.Dimensao.lookup(0, v, 1);
            }
            this.setColValue("dimensao_d", nRow, dimensao_d);
        }
        if (colname.equals("inov_prod_d")) {
            String inov_prod = "";
            if (v.length() > 0) {
                inov_prod = CTabelas.SimNao.lookup(1, v, 0);
            }
            this.setColValue("inov_prod", nRow, inov_prod);
        }
        if (colname.equals("inov_prod")) {
            String inov_prod_d = "";
            if (v.length() > 0) {
                inov_prod_d = CTabelas.SimNao.lookup(0, v, 1);
            }
            this.setColValue("inov_prod_d", nRow, inov_prod_d);
        }
        if (colname.equals("inov_proc_d")) {
            String inov_proc = "";
            if (v.length() > 0) {
                inov_proc = CTabelas.SimNao.lookup(1, v, 0);
            }
            this.setColValue("inov_proc", nRow, inov_proc);
        }
        if (colname.equals("inov_proc")) {
            String inov_proc_d = "";
            if (v.length() > 0) {
                inov_proc_d = CTabelas.SimNao.lookup(0, v, 1);
            }
            this.setColValue("inov_proc_d", nRow, inov_proc_d);
        }
        if (colname.equals("inov_org_d")) {
            String inov_org = "";
            if (v.length() > 0) {
                inov_org = CTabelas.SimNao.lookup(1, v, 0);
            }
            this.setColValue("inov_org", nRow, inov_org);
        }
        if (colname.equals("inov_org")) {
            String inov_org_d = "";
            if (v.length() > 0) {
                inov_org_d = CTabelas.SimNao.lookup(0, v, 1);
            }
            this.setColValue("inov_org_d", nRow, inov_org_d);
        }
        if (colname.equals("inov_mktg_d")) {
            String inov_mktg = "";
            if (v.length() > 0) {
                inov_mktg = CTabelas.SimNao.lookup(1, v, 0);
            }
            this.setColValue("inov_mktg", nRow, inov_mktg);
        }
        if (colname.equals("inov_mktg")) {
            String inov_mktg_d = "";
            if (v.length() > 0) {
                inov_mktg_d = CTabelas.SimNao.lookup(0, v, 1);
            }
            this.setColValue("inov_mktg_d", nRow, inov_mktg_d);
        }
        if (colname.equals("cae")) {
            this.upd_caes();
        }
        if (colname.equals("concelho_d")) {
            int idx;
            concelho = "";
            String nuts = "";
            if (v.length() > 0 && (nuts = CTabelas.Concelhos.getColFromIndex(idx = CTabelas.Concelhos.getIndexFromCode(concelho = CTabelas.Concelhos.lookup(1, v, 0)) + 1, 2).substring(0, 2)).equals("99")) {
                nuts = "";
            }
            if (this.getColValue("concelho_act", nRow).equals("")) {
                this.setColValue("nuts_ii", nRow, nuts);
                this.upd_nuts();
            }
            this.setColValue("concelho", nRow, concelho);
        }
        if (colname.equals("concelho")) {
            concelho_d = "";
            if (v.length() > 0) {
                concelho_d = CTabelas.Concelhos.lookup(0, v, 1);
            }
            this.setColValue("concelho_d", nRow, concelho_d);
            this.on_update("concelho_d", nRow, concelho_d);
        }
        if (colname.equals("concelho_act_d")) {
            concelho = "";
            String nuts = "";
            if (v.length() > 0) {
                concelho = CTabelas.Concelhos.lookup(1, v, 0);
                int idx = CTabelas.Concelhos.getIndexFromCode(concelho) + 1;
                nuts = CTabelas.Concelhos.getColFromIndex(idx, 2).substring(0, 2);
                if (nuts.equals("99")) {
                    nuts = "";
                }
                this.setColValue("nuts_ii", nRow, nuts);
                this.upd_nuts();
                this.setColValue("concelho_act", nRow, concelho);
            } else {
                this.setColValue("concelho_act", nRow, concelho);
                this.on_update("concelho_d", nRow, this.getColValue("concelho_d", nRow));
            }
        }
        if (colname.equals("concelho_act")) {
            concelho_d = "";
            if (v.length() > 0) {
                concelho_d = CTabelas.Concelhos.lookup(0, v, 1);
            }
            this.setColValue("concelho_act_d", nRow, concelho_d);
            this.on_update("concelho_act_d", nRow, concelho_d);
        }
        int n = 0;
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.isRowEmpty(i)) {
                ++n;
            }
            ++i;
        }
        if (n == 0) {
            CBData.CaracConjuntos.getByName("n_pme_apres").setStringValue("");
        } else {
            CBData.CaracConjuntos.getByName("n_pme_apres").setStringValue(String.valueOf(n));
        }
    }

    boolean del_ins_ok(String option) {
        String emp;
        this.handler.__garbage_stop_editing();
        int n = this.handler.j.getSelectedRow();
        int m = this.handler.j.getRowCount();
        boolean emp_ok = false;
        String msg = "";
        if (n < m && n != -1 && (emp = this.getColValue("n_ordem", n)).length() > 0) {
            int emp_ = Integer.parseInt(emp);
            int i = 0;
            while (i < CBData.QInv.dados.size()) {
                String emp_qinv;
                int emp_qi;
                if (CBData.QInv.getColValue("pme", i).length() > 0 && emp_ <= (emp_qi = Integer.parseInt(emp_qinv = CBData.QInv.getColValue("pme", i)))) {
                    emp_ok = true;
                    msg = "J\u00e1 existem linhas no Quadro de Investimentos definidas para a PME com o N\u00ba " + emp + " e/ou superior.\n" + "Imposs\u00edvel " + option + " Linha!";
                    break;
                }
                ++i;
            }
            if (emp_ok) {
                JOptionPane.showMessageDialog(null, msg, String.valueOf(option) + " Linha", 0, null);
                return false;
            }
        }
        return true;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Identifica\u00e7\u00e3o das Empresas envolvidas");
        }
        int i = 0;
        while (i < this.dados.size()) {
            double vendas_ext_pre;
            double vendas_tt_pre;
            StringBuffer mask = new StringBuffer("-RRR-RRR-R-------RRRR---" + (this.col_inov ? "-R-R-R-R" : "--------"));
            if (this.getColValue("excepcao", i).equals("1")) {
                mask.setCharAt(this.getColIndex("concelho_act_d"), 'R');
            } else if (!this.getColValue("concelho_act_d", i).equals("")) {
                mask.setCharAt(this.getColIndex("excepcao"), 'R');
            }
            TabError[] e = this.isIncompletAll(i, mask.toString());
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o", "Linha %L: %T - Neste Caso N\u00e3o Preenche")));
                ++ii;
            }
            if ((String)CParseConfig.hconfig.get("nuts_invest") != null && ((String)CParseConfig.hconfig.get("nuts_invest")).equals("n_pode_lx_alg") && !this.getColValue("nuts_ii", i).equals("") && !this.getColValue("nuts_ii", i).matches("11|16|18")) {
                err_list.add_msg(new CHValid_Msg("incomplet", "Linha " + (i + 1) + ": As empresas que n\u00e3o perten\u00e7am \u00e0s NUTS II eleg\u00edveis referidas no aviso (sem que seja indicada a situa\u00e7\u00e3o de exce\u00e7\u00e3o) devem ser retiradas"));
            }
            if ((vendas_tt_pre = _lib.to_double(this.getColValue("vol_neg_tt_pre", i))) < (vendas_ext_pre = _lib.to_double(this.getColValue("vol_neg_ext_pre", i)))) {
                err_list.add_msg(new CHValid_Msg("incomplet", "Linha " + (i + 1) + ": o Volume de Neg\u00f3cios Total n\u00e3o pode ser inferior ao Volume de Neg\u00f3cios no Exterior (Pr\u00e9-Projeto)"));
            }
            double vendas_ext_pos = _lib.to_double(this.getColValue("vol_neg_ext_pos", i));
            double vendas_tt_pos = _lib.to_double(this.getColValue("vol_neg_tt_pos", i));
            if (vendas_tt_pos < vendas_ext_pos) {
                err_list.add_msg(new CHValid_Msg("incomplet", "Linha " + (i + 1) + ": o Volume de Neg\u00f3cios Total n\u00e3o pode ser inferior ao Volume de Neg\u00f3cios no Exterior (P\u00f3s-Projeto)"));
            }
            ++i;
        }
        if (!this.isUnique("nif")) {
            err_list.add_msg(new CHValid_Msg("unique", "N\u00e3o podem existir NIF's repetidos"));
        }
        return err_list;
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("dimensao")) {
            s = String.valueOf(s) + _lib.xml_encode("dimensao_d", this.getColValue("dimensao_d", row));
        }
        if (tag.equals("cae") && v.length() > 0) {
            s = String.valueOf(s) + _lib.xml_encode("cae_d", CTabelas.Cae.getDesign(v));
        }
        if (tag.equals("concelho")) {
            s = String.valueOf(s) + _lib.xml_encode("concelho_d", this.getColValue("concelho_d", row));
        }
        if (tag.equals("concelho_act")) {
            s = String.valueOf(s) + _lib.xml_encode("concelho_act_d", this.getColValue("concelho_act_d", row));
        }
        if (tag.equals("nuts_ii") && v.length() > 0) {
            s = String.valueOf(s) + _lib.xml_encode("nuts_ii_d", CTabelas.NUTS_II.getDesign(v));
        }
        if (tag.equals("inov_prod")) {
            s = String.valueOf(s) + _lib.xml_encode("inov_prod_d", this.getColValue("inov_prod_d", row));
        }
        if (tag.equals("inov_proc")) {
            s = String.valueOf(s) + _lib.xml_encode("inov_proc_d", this.getColValue("inov_proc_d", row));
        }
        if (tag.equals("inov_org")) {
            s = String.valueOf(s) + _lib.xml_encode("inov_org_d", this.getColValue("inov_org_d", row));
        }
        if (tag.equals("inov_mktg")) {
            s = String.valueOf(s) + _lib.xml_encode("inov_mktg_d", this.getColValue("inov_mktg_d", row));
        }
        return s;
    }

    void upd_caes() {
        double cae_turismo = 0.0;
        double total = 0.0;
        String lista_turismo = "55.*|561.*|563.*|771.*|79.*|77210|90.*|91.*|93110|93192|93210|93292|93293|93294|96040";
        int i = 0;
        while (i < this.dados.size()) {
            String cae = this.getColValue("cae", i);
            if (!cae.equals("")) {
                total += 1.0;
                if (cae.matches(lista_turismo)) {
                    cae_turismo += 1.0;
                }
            }
            ++i;
        }
        CBData.turismo = "";
        if (cae_turismo > 0.0) {
            double turismo = cae_turismo / total * 100.0;
            CBData.turismo = turismo != 0.0 ? _lib.to_string(turismo) : "";
        }
    }

    void upd_nuts() {
        double nute_norte = 0.0;
        double nute_centro = 0.0;
        double nute_lisboa = 0.0;
        double nute_alentejo = 0.0;
        double nute_algarve = 0.0;
        int i = 0;
        while (i < this.dados.size()) {
            if (this.getColValue("nuts_ii", i).equals("11")) {
                nute_norte += 1.0;
            }
            if (this.getColValue("nuts_ii", i).equals("16")) {
                nute_centro += 1.0;
            }
            if (this.getColValue("nuts_ii", i).equals("17")) {
                nute_lisboa += 1.0;
            }
            if (this.getColValue("nuts_ii", i).equals("18")) {
                nute_alentejo += 1.0;
            }
            if (this.getColValue("nuts_ii", i).equals("15")) {
                nute_algarve += 1.0;
            }
            ++i;
        }
        if ((String)CParseConfig.hconfig.get("nuts_invest") != null && ((String)CParseConfig.hconfig.get("nuts_invest")).equals("n_pode_lx_alg")) {
            nute_lisboa = 0.0;
            nute_algarve = 0.0;
        }
        double soma_nute = nute_norte + nute_centro + nute_lisboa + nute_alentejo + nute_algarve;
        CBData.nuts_ii_norte = "";
        CBData.nuts_ii_centro = "";
        CBData.nuts_ii_lisboa = "";
        CBData.nuts_ii_alentejo = "";
        CBData.nuts_ii_algarve = "";
        if (soma_nute > 0.0) {
            double norte = nute_norte / soma_nute * 100.0;
            CBData.nuts_ii_norte = norte != 0.0 ? _lib.to_string(norte) : "";
            double centro = nute_centro / soma_nute * 100.0;
            CBData.nuts_ii_centro = centro != 0.0 ? _lib.to_string(centro) : "";
            double lisboa = nute_lisboa / soma_nute * 100.0;
            CBData.nuts_ii_lisboa = lisboa != 0.0 ? _lib.to_string(lisboa) : "";
            double alentejo = nute_alentejo / soma_nute * 100.0;
            CBData.nuts_ii_alentejo = alentejo != 0.0 ? _lib.to_string(alentejo) : "";
            double algarve = nute_algarve / soma_nute * 100.0;
            CBData.nuts_ii_algarve = algarve != 0.0 ? _lib.to_string(algarve) : "";
        }
        CBData.Params.getByName("norte").setStringValue(CBData.nuts_ii_norte);
        CBData.Params.getByName("centro").setStringValue(CBData.nuts_ii_centro);
        CBData.Params.getByName("lisboa").setStringValue(CBData.nuts_ii_lisboa);
        CBData.Params.getByName("alentejo").setStringValue(CBData.nuts_ii_alentejo);
        CBData.Params.getByName("algarve").setStringValue(CBData.nuts_ii_algarve);
    }
}

