/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CParseConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;

public class FileSender {
    private static final String LINE_FEED = "\r\n";
    private String urlToConnect;
    private File fileToUpload;
    private String filename;
    private String mimeType;
    public boolean sent = false;

    public FileSender(String uri, String candRef, String docRef, String file_location) {
        this.initialize(uri, candRef, docRef, file_location);
    }

    public void initialize(String uri, String candRef, String docRef, String file_location) {
        this.urlToConnect = String.valueOf(uri) + "?OP=UPLOAD";
        this.urlToConnect = String.valueOf(this.urlToConnect) + "&AVISO=" + CParseConfig.hconfig.get("aviso");
        this.urlToConnect = String.valueOf(this.urlToConnect) + "&CLASSE=" + CParseConfig.hconfig.get("extensao");
        this.urlToConnect = String.valueOf(this.urlToConnect) + "&VS=" + URLEncoder.encode(CBData.vs);
        this.urlToConnect = String.valueOf(this.urlToConnect) + "&REFC=" + candRef;
        this.urlToConnect = String.valueOf(this.urlToConnect) + "&DOC=" + docRef;
        this.fileToUpload = new File(file_location);
        String[] fnp = file_location.split("\\\\");
        this.filename = fnp[fnp.length - 1];
        this.mimeType = URLConnection.guessContentTypeFromName(this.filename);
    }

    public ArrayList<String> SendFile() {
        ArrayList<String> buffer_out = null;
        try {
            String boundary = Long.toHexString(System.currentTimeMillis());
            HttpURLConnection conn = (HttpURLConnection)new URL(this.urlToConnect).openConnection();
            conn.setRequestMethod("POST");
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            OutputStream os = null;
            PrintWriter writer = null;
            try {
                os = conn.getOutputStream();
                writer = new PrintWriter(new OutputStreamWriter(os));
                writer.append("--" + boundary).append(LINE_FEED);
                writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + this.filename + "\"").append(LINE_FEED);
                writer.append("Content-Type: " + this.mimeType).append(LINE_FEED);
                writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
                writer.append(LINE_FEED);
                writer.flush();
                FileInputStream inputStream = new FileInputStream(this.fileToUpload);
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
                os.flush();
                inputStream.close();
                writer.append(LINE_FEED);
                writer.flush();
                writer.append(LINE_FEED);
                writer.append("--" + boundary + "--").append(LINE_FEED);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            int responseCode = conn.getResponseCode();
            BufferedReader in = null;
            if (responseCode == 200) {
                in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                this.sent = true;
            } else if (responseCode >= 400) {
                in = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            }
            if (in != null) {
                String line;
                buffer_out = new ArrayList<String>();
                while ((line = in.readLine()) != null) {
                    buffer_out.add(line);
                    System.out.println(line);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer_out;
    }
}

