/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBRegisto;
import fme.CFLib;
import fme.CHCampo;
import fme.CHCampo_Combo;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_PME;
import fme._lib;
import fme.fmeApp;
import fme.fmeComum;

class CBRegisto_CaracConjuntos
extends CBRegisto {
    Frame_PME P01;

    public String getPagina() {
        return "Proj_1";
    }

    CBRegisto_CaracConjuntos() {
        this.tag = "Conjuntos";
        this.P01 = (Frame_PME)fmeApp.Paginas.getPage("PME");
        if (this.P01 == null) {
            return;
        }
        this.started = true;
        this.Campos.add(new CHCampo_Text("n_pme_prev", this.P01.getjTextField_n_PME_prev(), CFLib.VLD_INT));
        this.Campos.add(new CHCampo_Text("n_pme_apres", this.P01.getjTextField_n_PME_apres(), CFLib.VLD_INT));
        this.Campos.add(new CHCampo_Text("elegivel_apres", this.P01.getjTextField_Eleg_apres(), CFLib.VLD_VALOR));
        CHCampo_Opt opt_c = new CHCampo_Opt("regiao_unica", this);
        opt_c.setOptions("S", "N");
        opt_c.addComponent(this.P01.getJCheckBox_Regiao_Sim());
        opt_c.addComponent(this.P01.getjCheckBox_Regiao_Nao());
        opt_c.dummy = this.P01.jCheckBox_RegiaoClear;
        this.Campos.add(opt_c);
        this.Campos.add(new CHCampo_Combo("nuts_ii", "NUTS_II", this.P01.getJComboBox_Regiao(), this));
        String[] opt_v = new String[]{"S"};
        CHCampo_Opt opt_d = new CHCampo_Opt("declaracao", opt_v, this);
        opt_d.addComponent(this.P01.getjCheckBox_Declaracao());
        opt_d.dummy = this.P01.jCheckBox_DeclaracaoClear;
        this.Campos.add(opt_d);
    }

    void Clear() {
        int i = 0;
        while (i < this.Campos.size()) {
            if (!((CHCampo)this.Campos.elementAt((int)i)).tag.equals("elegivel_apres")) {
                ((CHCampo)this.Campos.elementAt(i)).clear();
            }
            ++i;
        }
    }

    void after_open() {
        this.on_update("regiao_unica");
    }

    void on_update(String tag) {
        if (tag.equals("regiao_unica")) {
            if (this.getByName((String)"regiao_unica").v.equals("S")) {
                this.P01.jLabel_RegiaoInv.setForeground(fmeComum.color_1);
                this.P01.getJComboBox_Regiao().setEnabled(true);
                this.P01.getJComboBox_Regiao().setForeground(fmeComum.color_1);
            } else {
                this.P01.jLabel_RegiaoInv.setForeground(fmeComum.color_2);
                this.getByName((String)"nuts_ii").v = "";
                this.P01.getJComboBox_Regiao().setSelectedIndex(0);
                this.P01.getJComboBox_Regiao().setEnabled(false);
                this.P01.getJComboBox_Regiao().setForeground(fmeComum.color_2);
            }
        }
    }

    String on_xml(String tag) {
        String s = "";
        if (tag.equals("nuts_ii")) {
            String c = this.getByName(tag).getStringValue();
            s = c.length() == 0 ? String.valueOf(s) + "<nuts_ii_d/>\n" : String.valueOf(s) + _lib.xml_encode("nuts_ii_d", CTabelas.NUTS_II.getDesign(c));
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Caracter\u00edsticas do projeto conjunto");
        }
        this.extract();
        if (this.getByName("n_pme_prev").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("n_pme_prev", "N\u00ba de PME envolvidas no projeto conjunto (Previsto) - %o"));
        } else {
            int prev = _lib.numUnNull(this.getByName((String)"n_pme_prev").v);
            int apres = _lib.numUnNull(this.getByName((String)"n_pme_apres").v);
            if ((double)apres < (double)prev * 0.5 || apres < 5) {
                err_list.add_msg(new CHValid_Msg("n_pme_prev", 'W', "N\u00ba de PME envolvidas no projeto conjunto - o Apresentado dever\u00e1 ser 50% do Previsto, com um m\u00ednimo de 5"));
            }
        }
        if (this.getByName("regiao_unica").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("regiao_unica", "O Investimento vai estar concentrado numa s\u00f3 Regi\u00e3o ? - %o"));
        } else if (this.getByName((String)"regiao_unica").v.equals("S")) {
            if (this.getByName("nuts_ii").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("nuts_ii", "Regi\u00e3o onde o Investimento vai estar concentrado - %o"));
            }
        } else if (this.getByName((String)"regiao_unica").v.equals("N") && !this.getByName("nuts_ii").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nuts_ii", "Regi\u00e3o onde o Investimento vai estar concentrado - Neste Caso N\u00e3o Preenche"));
        }
        if (this.getByName("declaracao").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("declaracao", "Declaro ter verificado que todas as empresas identificadas... - %o"));
        }
        return err_list;
    }
}

