/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CHCampo;
import fme.CHCampo_Text;
import fme.CHCampo_TextArea;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CParseConfig;
import fme.Frame_CondAcesso;
import fme._lib;
import fme.fmeApp;

class CBRegisto_CondAcesso
extends CBRegisto {
    boolean pre = false;
    boolean pos = false;
    boolean pos_interanc = false;
    boolean imp_inv = false;
    boolean valor_oferta_nac = false;
    boolean is_inov = CParseConfig.hconfig.get("extensao").equals("i20");
    Frame_CondAcesso P07;

    public String getPagina() {
        return "CondAcesso";
    }

    CBRegisto_CondAcesso() {
        this.tag = "CondAcesso";
        this.P07 = (Frame_CondAcesso)fmeApp.Paginas.getPage("CondAcesso");
        if (this.P07 == null) {
            return;
        }
        this.started = true;
        this.pre = this.P07.perc_pre != 0.0;
        this.pos = this.P07.perc_pos != 0.0;
        this.pos_interanc = this.P07.perc_pos_internac != 0.0;
        this.imp_inv = this.P07.perc_imp != 0.0;
        this.valor_oferta_nac = this.P07.valor_oferta_nac;
        this.Campos.add(new CHCampo_Text("vol_neg_int_pre", this.P07.getJTextField_VolNegIntPre(), CFLib.VLD_VALOR, null));
        this.Campos.add(new CHCampo_Text("vol_neg_tt_pre", this.P07.getJTextField_VolNegTotPre(), CFLib.VLD_VALOR, null));
        this.Campos.add(new CHCampo_Text("perc_pre", this.P07.getJTextField_PercPre(), CFLib.VLD_VALOR, null));
        this.Campos.add(new CHCampo_Text("vol_neg_int_pos", this.P07.getJTextField_VolNegIntPos(), CFLib.VLD_VALOR, this));
        this.Campos.add(new CHCampo_Text("vol_neg_tt_pos", this.P07.getJTextField_VolNegTotPos(), CFLib.VLD_VALOR, this));
        this.Campos.add(new CHCampo_Text("perc_pos", this.P07.getJTextField_PercPos(), CFLib.VLD_VALOR, this));
        this.Campos.add(new CHCampo_Text("elegivel", this.P07.getJTextField_Eleg(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_Text("act_fixo_tang", this.P07.getJTextField_ActFixoTang(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_Text("act_intang", this.P07.getJTextField_ActIntang(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_Text("perc_imp_inv", this.P07.getJTextField_PercImpInvest(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_TextArea("texto", this.P07.getJTextArea_FundamInternac(), this));
        this.Campos.add(new CHCampo_Text("cae", this.P07.getJTextField_CaeProj(), null, this));
        this.Campos.add(new CHCampo_Text("vol_emp_pre", this.P07.getJTextField_PTrab_1(), null, this));
        this.Campos.add(new CHCampo_Text("vol_emp_0", this.P07.getJTextField_PTrab_2(), null, this));
        this.Campos.add(new CHCampo_Text("vol_emp_pos", this.P07.getJTextField_PTrab_3(), null, this));
        this.Campos.add(new CHCampo_Text("criacao_pt", this.P07.getJTextField_CriacaoPTrab(), CFLib.VLD_NUM_0, this));
    }

    void bind_updates() {
        CBData.Params.bind_ano_cand_update(this);
        CBData.DadosProjecto.bind_dt_fim_update(this);
    }

    void on_update(String tag) {
        if (tag.startsWith("vol_emp_")) {
            int pre = _lib.to_int(this.getByName((String)"vol_emp_pre").v);
            int cand = _lib.to_int(this.getByName((String)"vol_emp_0").v);
            int pos = _lib.to_int(this.getByName((String)"vol_emp_pos").v);
            int criacao = 0;
            criacao = pre > cand ? pos - pre : pos - cand;
            this.getByName("criacao_pt").setStringValue(String.valueOf(criacao));
        }
        if (tag.equals("cae")) {
            String cae = this.getByName((String)"cae").v;
            boolean enq = false;
            if (cae.length() == 0) {
                enq = false;
            } else if (cae.matches("90040|91041|91042|93210|93110|93192|93292|93293|93294|96040")) {
                enq = true;
            } else if (cae.substring(0, 4).matches("0161|0240")) {
                enq = true;
            } else if (cae.substring(0, 3).matches("383|493|494|561|563")) {
                enq = true;
            } else if (cae.substring(0, 2).matches("52|55|58|62|63")) {
                enq = true;
            } else if (cae.substring(0, 2).compareTo("05") >= 0 && cae.substring(0, 2).compareTo("09") <= 0) {
                enq = true;
            } else if (cae.substring(0, 2).compareTo("10") >= 0 && cae.substring(0, 2).compareTo("33") <= 0) {
                enq = true;
            } else if (cae.substring(0, 2).compareTo("69") >= 0 && cae.substring(0, 2).compareTo("73") <= 0) {
                enq = true;
            } else if (cae.substring(0, 2).matches("74") && !cae.matches("74200|74300")) {
                enq = true;
            }
            this.P07.jLabel_NotaCaeProj.setText(enq ? "" : "N\u00e3o enquadr\u00e1vel");
        }
    }

    void calc_perc(String tag) {
        if (tag.equals("pre") || tag.equals("pos")) {
            double vol_neg_int = this.getByName("vol_neg_int_" + tag).valueAsDouble();
            double vol_neg_tt = this.getByName("vol_neg_tt_" + tag).valueAsDouble();
            this.getByName("perc_" + tag).setStringValue("");
            if (vol_neg_tt > 0.0) {
                double perc = vol_neg_int / vol_neg_tt * 100.0;
                this.getByName("perc_" + tag).setStringValue(_lib.to_string(perc));
            }
        }
        if (tag.equals("imp_inv")) {
            double desp_eleg = this.getByName("elegivel").valueAsDouble();
            double act_fixo_tang = this.getByName("act_fixo_tang").valueAsDouble();
            double act_intang = this.getByName("act_intang").valueAsDouble();
            double activo = _lib.round(act_fixo_tang + act_intang);
            this.getByName("perc_imp_inv").setStringValue("");
            if (activo > 0.0) {
                double perc = desp_eleg / activo * 100.0;
                this.getByName("perc_imp_inv").setStringValue(_lib.to_string(perc));
            }
        }
    }

    void calc_vol_neg_int() {
        double vol_neg_int_pre = 0.0;
        double vol_neg_int_pos = 0.0;
        int i = 0;
        while (i < CBData.Mercados.dados.size()) {
            if (!(CBData.Mercados.isRowEmpty(i) || CBData.Mercados.getColValue("tipo", i).equals("") || !CBData.Mercados.getColValue("tipo", i).equals("01") || CBData.Mercados.getColValue("pais", i).equals("") || CBData.Mercados.getColValue("pais", i).equals("PT"))) {
                vol_neg_int_pre += _lib.to_double(CBData.Mercados.getColValue("val_pre", i));
                vol_neg_int_pos += _lib.to_double(CBData.Mercados.getColValue("val_pos", i));
            }
            ++i;
        }
        i = 0;
        while (i < CBData.VendasExt.dados.size()) {
            double v;
            double vendas_pre_EXT = 0.0;
            double vendas_pos_EXT = 0.0;
            if (CBData.VendasExt.getColValue("vendas_pre", i).length() > 0) {
                vendas_pre_EXT = _lib.to_double(CBData.VendasExt.getColValue("vendas_pre", i));
            }
            if (CBData.VendasExt.getColValue("vendas_pos", i).length() > 0) {
                vendas_pos_EXT = _lib.to_double(CBData.VendasExt.getColValue("vendas_pos", i));
            }
            double vol_neg_int_pre_EXT = 0.0;
            double vol_neg_int_pos_EXT = 0.0;
            if (CBData.VendasExt.getColValue("vol_neg_int_pre", i).length() > 0) {
                vol_neg_int_pre_EXT = _lib.to_double(CBData.VendasExt.getColValue("vol_neg_int_pre", i));
            }
            if (CBData.VendasExt.getColValue("vol_neg_int_pos", i).length() > 0) {
                vol_neg_int_pos_EXT = _lib.to_double(CBData.VendasExt.getColValue("vol_neg_int_pos", i));
            }
            double vol_neg_tt_pre_EXT = 0.0;
            double vol_neg_tt_pos_EXT = 0.0;
            if (CBData.VendasExt.getColValue("vol_neg_tt_pre", i).length() > 0) {
                vol_neg_tt_pre_EXT = _lib.to_double(CBData.VendasExt.getColValue("vol_neg_tt_pre", i));
            }
            if (CBData.VendasExt.getColValue("vol_neg_tt_pos", i).length() > 0) {
                vol_neg_tt_pos_EXT = _lib.to_double(CBData.VendasExt.getColValue("vol_neg_tt_pos", i));
            }
            if (vol_neg_tt_pre_EXT > 0.0 && (v = vol_neg_int_pre_EXT / vol_neg_tt_pre_EXT * vendas_pre_EXT) > 0.0) {
                vol_neg_int_pre += _lib.round(v);
            }
            if (vol_neg_tt_pos_EXT > 0.0 && (v = vol_neg_int_pos_EXT / vol_neg_tt_pos_EXT * vendas_pos_EXT) > 0.0) {
                vol_neg_int_pos += _lib.round(v);
            }
            ++i;
        }
        if (this.pre) {
            this.getByName("vol_neg_int_pre").setStringValue(_lib.to_string(vol_neg_int_pre));
            this.calc_perc("pre");
        }
        if (this.pos) {
            this.getByName("vol_neg_int_pos").setStringValue(_lib.to_string(vol_neg_int_pos));
            this.calc_perc("pos");
        }
    }

    void calc_vol_neg_tt() {
        if (this.pre) {
            this.getByName("vol_neg_tt_pre").setStringValue(CBData.DR_SNC.getColValue("val_p1", 0));
            this.calc_perc("pre");
        }
        if (this.pos) {
            this.getByName("vol_neg_tt_pos").setStringValue(CBData.vol_neg_pos);
            this.calc_perc("pos");
        }
    }

    void calc_desp_eleg() {
        if (!this.imp_inv) {
            return;
        }
        double desp_eleg = 0.0;
        int i = 0;
        while (i < CBData.QInv.dados.size()) {
            if (!(CBData.QInv.isRowEmpty(i) || CBData.QInv.getColValue("classe", i).equals("") || !CBData.QInv.getColValue("classe", i).startsWith("1") && !CBData.QInv.getColValue("classe", i).startsWith("2") || CBData.QInv.getColValue("elegivel", i).equals(""))) {
                desp_eleg += _lib.to_double(CBData.QInv.getColValue("elegivel", i));
            }
            ++i;
        }
        this.getByName("elegivel").setStringValue(_lib.to_string(desp_eleg));
        this.calc_perc("imp_inv");
    }

    void calc_activos(int balRow, String tipo) {
        if (!this.imp_inv) {
            return;
        }
        this.getByName(tipo).setStringValue(CBData.Balanco_SNC.getColValue("val_p1", balRow));
        this.calc_perc("imp_inv");
    }

    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        if (tag.equals("ano_cand")) {
            int ano = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
            if (ano > 0) {
                this.P07.jLabel_PTrab_1.setText("(1) em 31 de dezembro de " + (ano - 1));
                this.P07.jLabel_PTrab_2.setText("(2) em 31 de dezembro de " + ano);
            } else {
                this.P07.jLabel_PTrab_1.setText("(1) em 31 de dezembro de Ano Ref\u00aa-1" + (ano - 1));
                this.P07.jLabel_PTrab_2.setText("(2) em 31 de dezembro de Ano Ref\u00aa");
            }
        }
        if (tag.equals("dt_fim")) {
            int n_anos = CParseConfig.hconfig.get("extensao").equals("i20") ? 3 : 1;
            String dt_fim = CBData.DadosProjecto.getByName((String)"dt_fim").v;
            if (!dt_fim.equals("") && dt_fim.length() == 10) {
                int ano_fim = Integer.parseInt(dt_fim.substring(0, 4));
                this.P07.jLabel_PTrab_3.setText("(3) " + Integer.toString(ano_fim + n_anos));
            } else {
                this.P07.jLabel_PTrab_3.setText("(3) no Ano Fim Proj.+" + n_anos);
            }
        }
        if (tag.startsWith("val_")) {
            double pre = _lib.to_double(this.getByName((String)"vol_emp_pre").v);
            double cand = _lib.to_double(this.getByName((String)"vol_emp_0").v);
            String n = "2";
            if (pre > cand) {
                n = "1";
            }
            this.P07.jLabel_CriacaoPTrab.setText("(3 - " + n + ") Cria\u00e7\u00e3o L\u00edquida de Postos de Trabalho");
        }
    }

    void Clear() {
        int i = 0;
        while (i < this.Campos.size()) {
            if (((CHCampo)this.Campos.elementAt((int)i)).tag.equals("texto")) {
                ((CHCampo)this.Campos.elementAt(i)).clear();
            }
            ++i;
        }
    }

    CHValid_Grp validar_1(CHValid_Grp err_list) {
        double perc_pre;
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Intensidade das exporta\u00e7\u00f5es (pr\u00e9-projeto)");
        }
        this.extract();
        int ano_cand = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
        if (ano_cand > 0) {
            String dt_inicio_act = CBData.Promotor.getByName((String)"dt_inicio_act").v;
            if (dt_inicio_act.length() == 0) {
                return err_list;
            }
            int ano_inicio = _lib.to_int(dt_inicio_act.substring(0, 4));
            if (ano_inicio >= ano_cand) {
                return err_list;
            }
        }
        double vol_neg_int_pre = this.getByName("vol_neg_int_pre").valueAsDouble();
        double vol_neg_tt_pre = this.getByName("vol_neg_tt_pre").valueAsDouble();
        if (vol_neg_tt_pre < vol_neg_int_pre) {
            err_list.add_msg(new CHValid_Msg("vol_neg_tt_pre", "O Volume de Neg\u00f3cios Internacional n\u00e3o pode ser superior ao Volume de Neg\u00f3cios Total. P.f. verifique o quadro de Atividades Econ\u00f3micas por Mercado e o quadro de Vendas ao Exterior Indiretas."));
        }
        if ((perc_pre = this.getByName("perc_pre").valueAsDouble()) < this.P07.perc_pre) {
            err_list.add_msg(new CHValid_Msg("perc_pre", 'W', "Dever\u00e1 ser igual ou superior a " + _lib.to_format(this.P07.perc_pre) + "%"));
        }
        return err_list;
    }

    CHValid_Grp validar_2(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Intensidade das exporta\u00e7\u00f5es (p\u00f3s-projeto)");
        }
        this.extract();
        double vol_neg_int_pos = this.getByName("vol_neg_int_pos").valueAsDouble();
        double vol_neg_tt_pos = this.getByName("vol_neg_tt_pos").valueAsDouble();
        if (vol_neg_tt_pos < vol_neg_int_pos) {
            err_list.add_msg(new CHValid_Msg("vol_neg_tt_pos", "O Volume de Neg\u00f3cios Internacional n\u00e3o pode ser superior ao Volume de Neg\u00f3cios Total. P.f. verifique o quadro de Atividades Econ\u00f3micas por Mercado e o quadro de Vendas ao Exterior Indiretas."));
        }
        double perc = this.P07.perc_pos;
        double perc_pos = this.getByName("perc_pos").valueAsDouble();
        if (this.pos_interanc) {
            boolean tip_internac = false;
            boolean tip_not_internac = false;
            int ii = 0;
            while (ii < CBData.Tipologia.dados.size()) {
                if (CBData.Tipologia.getColValue("tipologia", ii).equals("11") && CBData.Tipologia.getColValue("select", ii).equals("S")) {
                    tip_internac = true;
                }
                if (!CBData.Tipologia.getColValue("tipologia", ii).equals("11") && CBData.Tipologia.getColValue("select", ii).equals("S")) {
                    tip_not_internac = true;
                }
                ++ii;
            }
            if (tip_internac && !tip_not_internac) {
                perc = this.P07.perc_pos_internac;
            }
            if (!tip_internac && tip_not_internac) {
                perc = this.P07.perc_pos;
            }
            if (tip_internac && tip_not_internac) {
                double d = perc = this.P07.perc_pos < this.P07.perc_pos_internac ? this.P07.perc_pos_internac : this.P07.perc_pos;
            }
            if (!(!(perc_pos < perc) || tip_internac && tip_not_internac)) {
                err_list.add_msg(new CHValid_Msg("designacao", 'W', "Dever\u00e1 ser igual ou superior a " + _lib.to_format(perc) + "%"));
            } else if (perc_pos < perc && tip_internac && tip_not_internac) {
                err_list.add_msg(new CHValid_Msg("designacao", 'W', "Se o seu projeto for de 'Internacionaliza\u00e7\u00e3o', dever\u00e1 ser igual ou superior a " + _lib.to_format(this.P07.perc_pos_internac) + "%. Caso contr\u00e1rio, dever\u00e1 ser igual ou superior a " + _lib.to_format(this.P07.perc_pos) + "%."));
            }
        } else if (perc_pos < perc) {
            err_list.add_msg(new CHValid_Msg("designacao", 'W', "Dever\u00e1 ser igual ou superior a " + _lib.to_format(perc) + "%"));
        }
        return err_list;
    }

    CHValid_Grp validar_3(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Impacto do investimento");
        }
        this.extract();
        double perc_imp_inv = this.getByName("perc_imp_inv").valueAsDouble();
        if (perc_imp_inv < this.P07.perc_imp) {
            err_list.add_msg(new CHValid_Msg("designacao", 'W', "Dever\u00e1 ser igual ou superior a " + _lib.to_format(this.P07.perc_imp) + "%"));
        }
        return err_list;
    }

    CHValid_Grp validar_4(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Relev\u00e2ncia e fundamenta\u00e7\u00e3o da estrat\u00e9gia de internacionaliza\u00e7\u00e3o");
        }
        this.extract();
        String erro = "Texto demasiado extenso. Por favor, abrevie at\u00e9 32000 caracteres.";
        if (!this.getByName("texto").isEmpty() && this.getByName((String)"texto").v.length() > 32000) {
            err_list.add_msg(new CHValid_Msg("texto", erro));
        }
        return err_list;
    }
}

