/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBData_Comum;
import fme.CBRegisto;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHCampo;
import fme.CHCampo_Text;
import fme.CHCampo_TextArea;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CParseConfig;
import fme.Frame_Proj_1;
import fme._lib;
import fme.fmeApp;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTextArea;

class CBRegisto_DadosProjecto
extends CBRegisto {
    Frame_Proj_1 P07;
    int limite = 3000;
    Vector dt_fim_updates = new Vector();

    public String getPagina() {
        return "Proj_1";
    }

    CBRegisto_DadosProjecto() {
        this.tag = "DadosProjecto";
        this.P07 = (Frame_Proj_1)fmeApp.Paginas.getPage("Proj_1");
        if (this.P07 == null) {
            return;
        }
        this.started = true;
        this.Campos.add(new CHCampo_Text("designacao", this.P07.getJTextField_Designacao(), null, this));
        this.Campos.add(new CHCampo_Text("dt_inicio", this.P07.getJTextField_Inicio(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("n_meses", this.P07.getJTextField_Meses(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_Text("dt_fim", this.P07.getJTextField_Fim(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("investimento", this.P07.getJTextField_Inv(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_Text("elegivel", this.P07.getJTextField_Eleg(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_TextArea("fundamento", this.P07.getJTextArea_Fundam(), this));
    }

    void after_open() {
        this.on_update("dt_inicio");
        this.on_update("fundamento");
    }

    void on_update(String tag) {
        CHCampo chc;
        if (tag.equals("dt_fim")) {
            int i = 0;
            while (i < this.dt_fim_updates.size()) {
                ((CBData_Comum)this.dt_fim_updates.elementAt(i)).on_external_update(tag);
                ++i;
            }
            CBData.DR_SNC.calc_vol_neg_tt();
        }
        if (tag.equals("dt_inicio") || tag.equals("dt_fim")) {
            String dt_inicio = this.getByName((String)"dt_inicio").v;
            String dt_fim = this.getByName((String)"dt_fim").v;
            if (dt_inicio.length() == 0 || dt_fim.length() == 0 || dt_fim.compareTo(dt_inicio) < 0) {
                this.getByName("n_meses").setStringValue("");
                return;
            }
            int ano_i = Integer.parseInt(dt_inicio.substring(0, 4));
            int ano_f = Integer.parseInt(dt_fim.substring(0, 4));
            int mes_i = Integer.parseInt(dt_inicio.substring(5, 7));
            int mes_f = Integer.parseInt(dt_fim.substring(5, 7));
            int dia_i = Integer.parseInt(dt_inicio.substring(8, 10));
            int dia_f = Integer.parseInt(dt_fim.substring(8, 10));
            double n_meses = (ano_f - ano_i) * 12 + (mes_f - mes_i - 1);
            double mes = mes_i;
            double d = 0.0;
            if (mes == 1.0 || mes == 3.0 || mes == 5.0 || mes == 7.0 || mes == 8.0 || mes == 10.0 || mes == 12.0) {
                d = 31.0;
            }
            if (mes == 4.0 || mes == 6.0 || mes == 9.0 || mes == 11.0) {
                d = 30.0;
            }
            if (mes == 2.0 && ano_i % 4 == 0) {
                d = 29.0;
            }
            if (mes == 2.0 && ano_i % 4 != 0) {
                d = 28.0;
            }
            n_meses += (d - (double)dia_i + 1.0) / d;
            mes = mes_f;
            if (mes == 1.0 || mes == 3.0 || mes == 5.0 || mes == 7.0 || mes == 8.0 || mes == 10.0 || mes == 12.0) {
                d = 31.0;
            }
            if (mes == 4.0 || mes == 6.0 || mes == 9.0 || mes == 11.0) {
                d = 30.0;
            }
            if (mes == 2.0 && ano_f % 4 == 0) {
                d = 29.0;
            }
            if (mes == 2.0 && ano_f % 4 != 0) {
                d = 28.0;
            }
            this.getByName("n_meses").setStringValue(Double.toString(n_meses += (double)dia_f / d));
        }
        if (tag.equals("fundamento") && (chc = this.getByName(tag)) instanceof CHCampo_TextArea) {
            JTextArea jta = ((CHCampo_TextArea)chc).jcomp;
            int n = jta.getText().length();
            this.P07.jLabel_Count.setText(String.valueOf(this.limite - n) + "/" + this.limite);
        }
    }

    void Clear() {
        int i = 0;
        while (i < this.Campos.size()) {
            if (!((CHCampo)this.Campos.elementAt((int)i)).tag.equals("investimento") && !((CHCampo)this.Campos.elementAt((int)i)).tag.equals("elegivel")) {
                ((CHCampo)this.Campos.elementAt(i)).clear();
            }
            ++i;
        }
        this.on_update("dt_fim");
    }

    CHValid_Grp validar_1(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Designa\u00e7\u00e3o do Projeto e Tipologia(s)");
        }
        this.extract();
        if (this.getByName("designacao").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("designacao", "Designa\u00e7\u00e3o - %o"));
        }
        CBData.Tipologia.validar(err_list);
        String erro = "Texto demasiado extenso. Por favor, abrevie at\u00e9 32000 caracteres.";
        if (this.getByName("fundamento").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("fundamento", "Enquadramento do projeto na(s) tipologia(s) selecionada(s) - %o"));
        }
        if (!this.getByName("fundamento").isEmpty() && this.getByName((String)"fundamento").v.length() > this.limite) {
            err_list.add_msg(new CHValid_Msg("fundamento", erro));
        }
        return err_list;
    }

    CHValid_Grp validar_2(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Calendariza\u00e7\u00e3o");
        }
        this.extract();
        int ano_c = _lib.to_int(CBData.Params.getByName((String)"ano_cand").v);
        if (this.getByName("dt_inicio").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de In\u00edcio do Projeto - %o"));
        } else {
            int ano_i = _lib.to_int(this.getByName((String)"dt_inicio").v.substring(0, 4));
            if (ano_i < ano_c || ano_i > ano_c + 2) {
                err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de In\u00edcio do Projeto - fora do intervalo de refer\u00eancia aceit\u00e1vel"));
            }
        }
        if (this.getByName("dt_fim").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_fim", "Data de Fim do Projeto - %o"));
        } else if (!this.getByName("dt_inicio").isEmpty()) {
            Date today = new Date();
            Date dt_inicio = CFType_Data.parse_date(this.getByName((String)"dt_inicio").v);
            Date dt_fim = CFType_Data.parse_date(this.getByName((String)"dt_fim").v);
            if (dt_inicio != null && dt_fim != null && dt_fim.before(dt_inicio)) {
                err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de In\u00edcio n\u00e3o pode ser posterior \u00e0 Data de Fim do Projeto"));
            } else {
                int ano_i = _lib.to_int(this.getByName((String)"dt_inicio").v.substring(0, 4));
                int ano_f = _lib.to_int(this.getByName((String)"dt_fim").v.substring(0, 4));
                int limite = 3;
                if (CParseConfig.hconfig.get("extensao").equals("i20")) {
                    limite = 4;
                }
                if (ano_f > ano_i + limite) {
                    err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de Fim do Projeto - fora do intervalo de refer\u00eancia aceit\u00e1vel"));
                }
            }
        }
        if (!this.getByName("n_meses").isEmpty() && _lib.to_double(this.getByName((String)"n_meses").v) > 24.0) {
            err_list.add_msg(new CHValid_Msg("dt_fim", 'W', "Dura\u00e7\u00e3o do projeto superior a 2 anos"));
        }
        return err_list;
    }

    void bind_dt_fim_update(CBData_Comum d) {
        this.dt_fim_updates.add(d);
    }
}

