/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHCampo;
import fme.CHCampo_Combo;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CParseConfig;
import fme.CTabelas;
import fme.Frame_IdProm_1;
import fme._lib;
import fme.fmeApp;
import java.util.Date;
import java.util.GregorianCalendar;

class CBRegisto_Promotor
extends CBRegisto {
    Frame_IdProm_1 P01;
    int tab_index = 0;

    public String getPagina() {
        return "IdProm_01";
    }

    CBRegisto_Promotor() {
        this.P01 = (Frame_IdProm_1)fmeApp.Paginas.getPage("IdProm_1");
        if (this.P01 == null) {
            return;
        }
        this.initialize();
    }

    CBRegisto_Promotor(Frame_IdProm_1 p, int idx) {
        this.P01 = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "Promotor";
        this.started = true;
        this.P01.cbd_promotor = this;
        this.Campos.add(new CHCampo_Text("nif", this.P01.getJTextField_NIF(), CFLib.VLD_NIF));
        this.Campos.add(new CHCampo_Text("nome", this.P01.getJTextField_Nome(), null, this));
        this.Campos.add(new CHCampo_Text("morada", this.P01.getJTextField_Morada(), null));
        this.Campos.add(new CHCampo_Text("localidade", this.P01.getJTextField_Localidade(), null));
        this.Campos.add(new CHCampo_Text("cod_postal", this.P01.getJTextField_CodPostal(), CFLib.VLD_COD_POSTAL));
        this.Campos.add(new CHCampo_Text("cod_postal_loc", this.P01.getJTextField_CodPostalLocal(), null));
        this.Campos.add(new CHCampo_Combo("distrito", "Distritos", this.P01.getJComboBox_Distrito(), this));
        this.Campos.add(new CHCampo_Combo("concelho", "ConcelhosF1", this.P01.getJComboBox_Concelho(), this));
        this.Campos.add(new CHCampo_Text("telefone", this.P01.getJTextField_Telefone(), null));
        this.Campos.add(new CHCampo_Text("telefax", this.P01.getJTextField_Telefax(), null));
        this.Campos.add(new CHCampo_Text("email", this.P01.getJTextField_Email(), CFLib.VLD_EMAIL));
        this.Campos.add(new CHCampo_Text("url", this.P01.getJTextField_Url(), null));
        this.Campos.add(new CHCampo_Combo("nat_jur", "NatJuridica", this.P01.getJComboBox_NatJur(), this));
        CHCampo_Opt opt_fins = new CHCampo_Opt("fins_lucro");
        opt_fins.setOptions("S", "N");
        opt_fins.addComponent(this.P01.getJCheckBox_FinsLucro_Sim());
        opt_fins.addComponent(this.P01.getJCheckBox_FinsLucro_Nao());
        opt_fins.dummy = this.P01.jCheckBox_FinsLucro_Clear;
        this.Campos.add(opt_fins);
        this.Campos.add(new CHCampo_Text("dt_const", this.P01.getJTextField_DtConst(), CFLib.VLD_DATA));
        this.Campos.add(new CHCampo_Text("dt_inicio_act", this.P01.getJTextField_DtInicioAct(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("cap_social", this.P01.getJTextField_CapSocial(), CFLib.VLD_VALOR));
        this.Campos.add(new CHCampo_Text("rgc_num", this.P01.getJTextField_Matricula(), null));
        this.Campos.add(new CHCampo_Text("rgc_cons", this.P01.getJTextField_Conservatoria(), null));
        CBData.Params.bind_ano_cand_update(this);
    }

    void Clear() {
        int i = 0;
        while (i < this.Campos.size()) {
            if (!((CHCampo)this.Campos.elementAt((int)i)).tag.equals("nif") || !fmeApp.contexto.equals("toolbar") || CBData.reg_C.equals("")) {
                ((CHCampo)this.Campos.elementAt(i)).clear();
            }
            ++i;
        }
    }

    void Clear2() {
        int i = 0;
        while (i < this.Campos.size()) {
            if (!(((CHCampo)this.Campos.elementAt((int)i)).tag.equals("nat_jur") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("fins_lucro") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("cont_publica"))) {
                ((CHCampo)this.Campos.elementAt(i)).clear();
            }
            ++i;
        }
    }

    void on_update(String tag) {
        String concelho;
        if (tag.equals("nome")) {
            CTabelas.Empresas.refresh();
        }
        if (tag.equals("concelho") && (concelho = this.getByName("concelho").getStringValue()).length() > 0) {
            this.getByName("distrito").setStringValue(concelho.substring(0, 2));
        }
        if (tag.equals("distrito")) {
            String distrito = this.getByName("distrito").getStringValue();
            String concelho2 = this.getByName("concelho").getStringValue();
            if (concelho2.length() > 0 && !concelho2.substring(0, 2).equals(distrito)) {
                this.getByName("concelho").setStringValue("");
            }
        }
    }

    String on_xml(String tag) {
        String c;
        String s = "";
        if (tag.equals("concelho")) {
            c = this.getByName(tag).getStringValue();
            s = c.length() == 0 ? String.valueOf(s) + "<concelho_d/>\n" : String.valueOf(s) + _lib.xml_encode("concelho_d", CTabelas.Concelhos.getDesign(c));
        }
        if (tag.equals("distrito")) {
            String d = this.getByName(tag).getStringValue();
            s = d.length() == 0 ? String.valueOf(s) + "<distrito_d/>\n" : String.valueOf(s) + _lib.xml_encode("distrito_d", CTabelas.Distritos.getDesign(d));
        }
        if (tag.equals("nat_jur")) {
            c = this.getByName(tag).getStringValue();
            s = c.length() == 0 ? String.valueOf(s) + "<nat_jur_d/>\n" : String.valueOf(s) + _lib.xml_encode("nat_jur_d", CTabelas.NatJuridica.getDesign(c));
        }
        return s;
    }

    boolean isEmpty() {
        int i = 0;
        while (i < this.Campos.size()) {
            block5: {
                CHCampo c;
                block4: {
                    c = (CHCampo)this.Campos.elementAt(i);
                    try {
                        CHCampo_Text c1 = (CHCampo_Text)this.Campos.elementAt(i);
                        if (c1.jcomp.isEditable()) break block4;
                        break block5;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!c.isEmpty()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        String titulo = "Identifica\u00e7\u00e3o do Benefici\u00e1rio";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        this.extract();
        if (this.tab_index > 0 && this.isEmpty()) {
            return err_list;
        }
        if (this.getByName("nif").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nif", "N\u00ba de Identifica\u00e7\u00e3o Fiscal - %o"));
        }
        if (this.getByName("nome").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nome", "Nome ou Designa\u00e7\u00e3o Social - %o"));
        }
        if (this.getByName("morada").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("morada", "Morada (Sede Social) - %o"));
        }
        if (this.getByName("localidade").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("localidade", "Localidade - %o"));
        }
        if (this.getByName("cod_postal").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("cod_postal", "C\u00f3digo Postal - %o"));
        }
        if (this.getByName("cod_postal_loc").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("cod_postal_loc", "C\u00f3digo Postal (localidade) - %o"));
        }
        if (this.getByName("distrito").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("distrito", "Distrito - %o"));
        } else if (this.getByName((String)"distrito").v.equals("99")) {
            err_list.add_msg(new CHValid_Msg("distrito", "Distrito inv\u00e1lido"));
        }
        if (this.getByName("concelho").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("concelho", "Concelho - %o"));
        }
        if (this.getByName("telefone").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("telefone", "Telefone - %o"));
        }
        if (this.getByName("email").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("email", "E-mail - %o"));
        }
        if (this.getByName("nat_jur").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nat_jur", "Natureza Jur\u00eddica - %o"));
        }
        if (this.getByName("fins_lucro").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("fins_lucro", "Fins Lucrativos - %o"));
        }
        if (!this.getByName("nat_jur").isEmpty()) {
            if (!this.getByName((String)"nat_jur").v.startsWith("2")) {
                if (this.getByName("dt_const").isEmpty()) {
                    err_list.add_msg(new CHValid_Msg("dt_const", "Data de Constitui\u00e7\u00e3o - %o"));
                }
            } else if (this.getByName((String)"nat_jur").v.equals("203") && this.getByName("dt_const").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("dt_const", "Data de Constitui\u00e7\u00e3o - %o"));
            }
        }
        Date today = new Date();
        Date dt_const = CFType_Data.parse_date(this.getByName((String)"dt_const").v);
        Date dt_act = CFType_Data.parse_date(this.getByName((String)"dt_inicio_act").v);
        if (this.getByName("dt_inicio_act").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_inicio_act", "Data de In\u00edcio de Atividade - %o"));
        } else {
            int ano_c = _lib.to_int(CBData.Params.getByName((String)"ano_cand").v);
            int ano_i = _lib.to_int(this.getByName((String)"dt_inicio_act").v.substring(0, 4));
            if (ano_i > ano_c + 1) {
                err_list.add_msg(new CHValid_Msg("dt_inicio_act", "Data de In\u00edcio de Atividade - fora do intervalo de refer\u00eancia aceit\u00e1vel"));
            }
            if (((String)CParseConfig.hconfig.get("aviso")).matches("2012_13") && !this.is_criacao()) {
                err_list.add_msg(new CHValid_Msg("dt_inicio_act", 'W', "Data de In\u00edcio de Atividade - cria\u00e7\u00e3o h\u00e1 mais de 3 anos"));
            }
        }
        if (dt_const != null && dt_const.after(today)) {
            err_list.add_msg(new CHValid_Msg("dt_const", 'W', "Data de Constitui\u00e7\u00e3o ?"));
        }
        if (dt_const != null && dt_act != null && dt_act.before(dt_const)) {
            err_list.add_msg(new CHValid_Msg("dt_const", "Data de In\u00edcio de Atividade anterior \u00e0 Data de Constitui\u00e7\u00e3o"));
        }
        if (!this.getByName("nat_jur").isEmpty()) {
            double capital;
            if (!this.getByName((String)"nat_jur").v.startsWith("2")) {
                if (this.getByName("rgc_num").isEmpty() && !this.getByName((String)"nat_jur").v.equals("10")) {
                    err_list.add_msg(new CHValid_Msg("rgc_num", "Matriculada sob o n.\u00ba - %o"));
                }
                if (this.getByName("rgc_cons").isEmpty() && !this.getByName((String)"nat_jur").v.equals("10")) {
                    err_list.add_msg(new CHValid_Msg("rgc_cons", "Conservat\u00f3ria do Registo Comercial - %o"));
                }
                if (this.getByName("cap_social").isEmpty() && !this.getByName((String)"nat_jur").v.equals("10")) {
                    err_list.add_msg(new CHValid_Msg("cap_social", String.valueOf(this.P01.jLabel_CapSocial.getText()) + " - %o"));
                }
            } else if (this.getByName("cap_social").isEmpty() && this.getByName((String)"nat_jur").v.startsWith("203")) {
                err_list.add_msg(new CHValid_Msg("cap_social", String.valueOf(this.P01.jLabel_CapSocial.getText()) + " - %o"));
            } else if (!this.getByName("cap_social").isEmpty() && _lib.round(capital = _lib.to_double(this.getByName((String)"cap_social").v)) < 5000.0) {
                err_list.add_msg(new CHValid_Msg("cap_social", 'W', String.valueOf(this.P01.jLabel_CapSocial.getText()) + " inferior a 5.000 \u20ac ?"));
            }
        }
        if (!this.getByName("dt_inicio_act").isEmpty()) {
            int ano_cand;
            int ano = ano_cand = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
            String v = this.getByName((String)"dt_inicio_act").v;
            if (v.length() == 10) {
                ano = Integer.parseInt(v.substring(0, 4));
            }
        }
        return err_list;
    }

    boolean is_criacao() {
        if (this.getByName("dt_inicio_act").isEmpty()) {
            return false;
        }
        Date today = new Date();
        Date dt_act = CFType_Data.parse_date(this.getByName((String)"dt_inicio_act").v);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(today);
        gc.add(1, -3);
        Date result = gc.getTime();
        return !dt_act.before(result);
    }
}

