/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_IdProm_3;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_Part
extends CBTabela {
    boolean upd = false;
    Frame_IdProm_3 P01;
    int tab_index = 0;

    public String getPagina() {
        return "IdProm_3";
    }

    CBTabela_Part() {
        this.P01 = (Frame_IdProm_3)fmeApp.Paginas.getPage("IdProm_3");
        if (this.P01 == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_Part(Frame_IdProm_3 p, int idx) {
        this.P01 = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "Part";
        this.started = true;
        this.P01.cbd_part = this;
        this.cols = new CHTabColModel[7];
        this.cols[0] = new CHTabColModel("design", "Designa\u00e7\u00e3o", true, true, true, null);
        this.cols[1] = new CHTabColModel("nif", "NIF/NIPC", true, true, true, CFLib.VLD_NIF);
        this.cols[2] = new CHTabColModel("perc", "Particip.<br>%", true, true, true, CFLib.VLD_PERC);
        this.cols[3] = new CHTabColModel("pais", "Pa\u00eds (id)", true, true, false, null);
        this.cols[4] = new CHTabColModel("pais_d", "Pa\u00eds", false, true, true, null);
        this.cols[5] = new CHTabColModel("controlo", "Controlo (id)", true, true, false, null);
        this.cols[6] = new CHTabColModel("controlo_d", "Controlo<br>Empresa", false, true, true, null);
        this.init_dados(4);
        this.init_handler(this.P01.getJTable_Part());
        this.P01.getJTable_Part().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P01.getJScrollPane_Part().getWidth() - 20;
        this.handler.set_col_text(0, 0.475, null);
        this.handler.set_col_text(1, 0.128, null);
        this.handler.set_col_text(2, 0.095, "R");
        this.handler.set_col_comboS(4, 0.2, null, CTabelas.Pais, 1, 170);
        this.handler.set_col_comboS(6, 0.1, null, CTabelas.SimNao, 1, 0);
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("pais_d")) {
            String pais = "";
            if (v.length() > 0) {
                pais = CTabelas.Pais.lookup(1, v, 0);
            }
            this.setColValue("pais", nRow, pais);
        }
        if (colname.equals("pais")) {
            String pais_d = "";
            if (v.length() > 0) {
                pais_d = CTabelas.Pais.lookup(0, v, 1);
            }
            if (CBData.reading_xml && pais_d == null) {
                pais_d = "";
            }
            this.setColValue("pais_d", nRow, pais_d);
        }
        if (colname.equals("controlo_d")) {
            String controlo = "";
            if (v.length() > 0) {
                controlo = CTabelas.SimNao.lookup(1, v, 0);
            }
            this.setColValue("controlo", nRow, controlo);
        }
        if (colname.equals("controlo")) {
            String controlo_d = "";
            if (v.length() > 0) {
                controlo_d = CTabelas.SimNao.lookup(0, v, 1);
            }
            this.setColValue("controlo_d", nRow, controlo_d);
        }
        if (colname.equals("perc") && v.length() > 0 && this.getColValue("controlo", nRow).equals("") && _lib.to_double(this.getColValue("perc", nRow)) > 50.0) {
            this.setColValue("controlo", nRow, "S");
            this.on_update("controlo", nRow, "S");
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Participa\u00e7\u00f5es do Benefici\u00e1rio no Capital de Outras Entidades");
        }
        boolean in_reg = false;
        int i = 0;
        while (i < CBData.PromLocal.dados.size()) {
            String freguesia = CBData.PromLocal.getColValue("freguesia", i);
            if (!freguesia.equals("") && !freguesia.equals("111127") && freguesia.matches("1105.*|1106.*|1110.*|1111.*|1115.*|1116.*")) {
                in_reg = true;
                break;
            }
            ++i;
        }
        if (in_reg && CBData.Dimensao.getByName((String)"dimensao").v.equals("4") && this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("part", "Lista vazia"));
        }
        i = 0;
        while (i < this.dados.size()) {
            TabError[] e = this.isIncompletAll(i, this.getMask(i));
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                ++ii;
            }
            if (_lib.to_double(this.getColValue("perc", i)) > 50.0 && this.getColValue("controlo", i).equals("N")) {
                err_list.add_msg(new CHValid_Msg("part", "Linha " + (i + 1) + ": se a Participa\u00e7\u00e3o \u00e9 superior a 50,00% deve indicar 'Sim' no Controlo Empresa"));
            }
            ++i;
        }
        if (!this.isUnique("nif")) {
            err_list.add_msg(new CHValid_Msg("unique", "N\u00e3o podem existir NIF's repetidos"));
        }
        return err_list;
    }

    String getMask(int i) {
        StringBuffer mask = new StringBuffer("R-R-R-R");
        if (this.getColValue("pais", i).equals("PT")) {
            mask.setCharAt(this.getColIndex("nif"), 'R');
        }
        return mask.toString();
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("pais")) {
            s = String.valueOf(s) + _lib.xml_encode("pais_d", this.getColValue("pais_d", row));
        }
        if (tag.equals("controlo")) {
            s = String.valueOf(s) + _lib.xml_encode("controlo_d", this.getColValue("controlo_d", row));
        }
        return s;
    }
}

