/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_IdProm_1;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_PromCae
extends CBTabela {
    Frame_IdProm_1 P01;
    int tab_index = 0;
    String lst_caes_pos = "";

    public String getPagina() {
        return "IdProm_1";
    }

    CBTabela_PromCae() {
        this.P01 = (Frame_IdProm_1)fmeApp.Paginas.getPage("IdProm_1");
        if (this.P01 == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_PromCae(Frame_IdProm_1 p, int idx) {
        this.P01 = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "PromCae";
        this.started = true;
        this.force_xml = true;
        this.cols = new CHTabColModel[5];
        this.cols[0] = new CHTabColModel("origem", "Origem", true, false, false, null);
        this.cols[1] = new CHTabColModel("cae", "CAE", true, true, true, null);
        this.cols[2] = new CHTabColModel("cae_d", "Designa\u00e7\u00e3o", false, false, true, null);
        this.cols[3] = new CHTabColModel("perc_pre", "% (pr\u00e9)", true, false, true, CFLib.VLD_PERC);
        this.cols[4] = new CHTabColModel("perc_pos", "% (p\u00f3s)", true, true, true, CFLib.VLD_PERC);
        this.init_dados(4);
        this.init_handler(this.P01.getJTable_CAE());
        this.P01.getJTable_CAE().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P01.getJScrollPane_CAE().getWidth() - 2;
        this.handler.set_col_comboD(1, 0.1, null, CTabelas.Cae, 0, 450);
        this.handler.set_col(2, 0.765, null);
        this.handler.set_col_text(3, 0.07, "R");
        this.handler.set_col_text(4, 0.07, "R");
    }

    boolean isCellEditable(int i, int j) {
        String origem = this.getColValue("origem", i);
        if (j == this.getColIndex("cae") && origem.equals("ADC")) {
            return false;
        }
        return this.cols[j].editable;
    }

    void on_update(String tag, int row, String v) {
        if (tag.equals("cae")) {
            String design = "";
            if (v.length() > 0) {
                design = CTabelas.Cae.lookup(0, v, 1);
            }
            this.setColValue("cae_d", row, design);
        }
    }

    boolean isRowEmpty(int row) {
        int j = 0;
        while (j < this.cols.length) {
            String s = ((String[])this.dados.elementAt(row))[j];
            if (s.length() > 0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        String titulo = "Atividade(s) Econ\u00f3mica(s) do Benefici\u00e1rio";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (this.isEmpty() && this.tab_index == 0) {
            err_list.add_msg(new CHValid_Msg("prom_cae", "Lista vazia"));
        } else {
            TabError e;
            if (!this.isUnique("cae")) {
                err_list.add_msg(new CHValid_Msg("unique", "N\u00e3o podem existir CAE's repetidas"));
            }
            if ((e = this.isIncomplet("-R---")) != null) {
                err_list.add_msg(new CHValid_Msg("incomplet", e.msg("Linha %L incompleta: %T - %o", ""), e.row, e.col));
            }
            if (_lib.round(this.getSum("perc_pre")) != 100.0 && !this.isEmpty()) {
                err_list.add_msg(new CHValid_Msg("100%", "Deve indicar as CAE's correspondentes a 100% da atividade (pr\u00e9-projeto)"));
            }
            if (_lib.round(this.getSum("perc_pos")) != 100.0 && !this.isEmpty()) {
                err_list.add_msg(new CHValid_Msg("100%", "Deve indicar as CAE's correspondentes a 100% da atividade (p\u00f3s-projeto)"));
            }
            double v = 0.0;
            double v_anterior = 0.0;
            int nRows = this.dados.size();
            int i = 0;
            while (i < nRows) {
                String pos = ((String[])this.dados.elementAt(i))[this.getColIndex("perc_pos")];
                String s = ((String[])this.dados.elementAt(i))[this.getColIndex("perc_pre")];
                if (_lib.to_double(pos) + _lib.to_double(s) == 0.0 && this.isIncomplet(i, "-R-RR") != null) {
                    err_list.add_msg(new CHValid_Msg("soma", "Linha " + (i + 1) + " - Deve indicar pelo menos uma das % (pr\u00e9 ou p\u00f3s)"));
                }
                ++i;
            }
        }
        return err_list;
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("cae")) {
            s = String.valueOf(s) + _lib.xml_encode("cae_d", this.getColValue("cae_d", row));
        }
        return s;
    }

    void before_get_dados_adc() {
        this.lst_caes_pos = "";
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.getColValue("cae", i).equals("") && !this.getColValue("perc_pos", i).equals("")) {
                this.lst_caes_pos = String.valueOf(this.lst_caes_pos) + this.getColValue("origem", i) + "::" + this.getColValue("cae", i) + "=" + this.getColValue("perc_pos", i) + ";";
            }
            ++i;
        }
        if (this.lst_caes_pos.length() > 0) {
            this.lst_caes_pos = this.lst_caes_pos.substring(0, this.lst_caes_pos.length() - 1);
        }
    }

    void after_get_dados_adc() {
        if (this.lst_caes_pos.length() == 0) {
            return;
        }
        String[] clist = this.lst_caes_pos.split(";");
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.getColValue("cae", i).equals("")) {
                int j = 0;
                while (j < clist.length) {
                    String[] cae = clist[j].split("=");
                    String[] cae2 = cae[0].split("::");
                    int ii = 0;
                    boolean on_tab = false;
                    ii = 0;
                    while (ii < this.dados.size()) {
                        if ("".equals(this.getColValue("cae", ii))) break;
                        if (cae2[1].equals(this.getColValue("cae", ii))) {
                            this.setColValue("perc_pos", ii, cae[1]);
                            on_tab = true;
                        }
                        if (on_tab) break;
                        ++ii;
                    }
                    if (!on_tab) {
                        this.setColValue("cae", ii, cae2[1]);
                        this.on_update("cae", ii, cae2[1]);
                        this.setColValue("perc_pos", ii, cae[1]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.dados.size()) {
            if (!this.getColValue("cae", i).equals("") && !this.getColValue("perc_pos", i).equals("")) {
                this.lst_caes_pos = String.valueOf(this.lst_caes_pos) + this.getColValue("origem", i) + "::" + this.getColValue("cae", i) + "=" + this.getColValue("perc_pos", i) + ";";
            }
            ++i;
        }
        if (this.lst_caes_pos.length() > 0) {
            this.lst_caes_pos = this.lst_caes_pos.substring(0, this.lst_caes_pos.length() - 1);
        }
    }

    void clearRow(int i) {
        int j = 0;
        while (j < this.cols.length) {
            ((String[])this.dados.elementAt((int)i))[j] = "";
            if (((String[])this.dados.elementAt(i))[j] == null) {
                ((String[])this.dados.elementAt((int)i))[j] = "";
            }
            this.on_update(this.cols[j].col_tag, i, "");
            ++j;
        }
    }
}

