/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CParseConfig;
import fme.CTabelas;
import fme.Frame_QInv;
import fme.GroupableTableHeaderUI;
import fme.SteppedComboBox;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_QInv
extends CBTabela {
    public SteppedComboBox cboAtividades = null;
    public SteppedComboBox cboEstabs = null;
    public SteppedComboBox cboEmpresas = null;
    public SteppedComboBox cboPME = null;
    Frame_QInv P12;
    String baixa_densidade = CParseConfig.hconfig.get("baixa_dens") != null ? (String)CParseConfig.hconfig.get("baixa_dens") : "";

    public String getPagina() {
        return "QInv";
    }

    CBTabela_QInv() {
        this.tag = "Inv";
        this.P12 = (Frame_QInv)fmeApp.Paginas.getPage("QInv");
        if (this.P12 == null) {
            return;
        }
        this.started = true;
        this.cols = new CHTabColModel[21];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, CFLib.VLD_INT);
        this.cols[1] = new CHTabColModel("atividade", "Atividade<br>de Inova\u00e7\u00e3o", true, true, true, null);
        this.cols[2] = new CHTabColModel("atividade_d", "Atividade<br>de Inova\u00e7\u00e3o<br>(Designa\u00e7\u00e3o)", true, false, true, null);
        this.cols[3] = new CHTabColModel("design", "Designa\u00e7\u00e3o", true, true, true, null);
        this.cols[4] = new CHTabColModel("excepcao", "Exce\u00e7\u00e3o", true, true, true, null);
        this.cols[4].is_check = true;
        this.cols[5] = new CHTabColModel("calendario", "Aquisi\u00e7\u00e3o<br>(aaaa-mm)", true, true, true, CFLib.VLD_ANO_MES);
        this.cols[6] = new CHTabColModel("investimento", "Investimento", true, true, true, CFLib.VLD_VALOR);
        this.cols[7] = new CHTabColModel("elegivel", "Eleg\u00edvel", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[8] = new CHTabColModel("classe", "Classifica\u00e7\u00e3o das Despesas (id)", true, true, false, null);
        this.cols[9] = new CHTabColModel("classe_d", "Classifica\u00e7\u00e3o das Despesas", false, true, true, null);
        this.cols[10] = new CHTabColModel("tipologia", "Tipologia da Opera\u00e7\u00e3o (id)", true, true, false, null);
        this.cols[11] = new CHTabColModel("tipologia_d", "Tipologia da Opera\u00e7\u00e3o", false, false, true, null);
        this.cols[12] = new CHTabColModel("snc", "SNC (id)", true, true, false, null);
        this.cols[13] = new CHTabColModel("snc_d", "SNC", false, true, true, null);
        this.cols[14] = new CHTabColModel("mercado", "Mercado (id)", true, true, false, null);
        this.cols[15] = new CHTabColModel("mercado_d", "Mercado", false, true, true, null);
        this.cols[16] = new CHTabColModel("estab", "Estab.", true, true, true, null);
        this.cols[17] = new CHTabColModel("concelho", "Concelho (id)", true, true, false, null);
        this.cols[18] = new CHTabColModel("concelho_d", "Concelho", false, false, true, null);
        this.cols[19] = new CHTabColModel("nuts_ii", "NUTS II (id)", false, true, false, null);
        this.cols[20] = new CHTabColModel("nuts_ii_d", "NUTS II", false, false, true, null);
        this.init_dados(14);
        this.init_handler(this.P12.getJTable_QInv());
        this.P12.getJTable_QInv().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P12.getJScrollPane_QInv().getWidth();
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(1, this.P12.getJTable_QInv());
        this.ui.add_col(0, 0, 1, 1, "N\u00ba");
        this.ui.add_col(1, 0, 2, 1, "Atividade de Inova\u00e7\u00e3o");
        this.ui.add_col(3, 0, 1, 1, "Designa\u00e7\u00e3o");
        this.ui.add_col(4, 0, 1, 1, "Exce\u00e7\u00e3o");
        this.ui.add_col(5, 0, 1, 1, "<html><center>Aquisi\u00e7\u00e3o<br>(aaaa-mm)</center></html>");
        this.ui.add_col(6, 0, 1, 1, "Investimento");
        this.ui.add_col(7, 0, 1, 1, "Eleg\u00edvel");
        this.ui.add_col(8, 0, 1, 1, "Classifica\u00e7\u00e3o das Despesas");
        this.ui.add_col(9, 0, 1, 1, "Tipologia da Opera\u00e7\u00e3o");
        this.ui.add_col(10, 0, 1, 1, "SNC");
        this.ui.add_col(11, 0, 1, 1, "Mercado");
        this.ui.add_col(12, 0, 1, 1, "Estab.");
        this.ui.add_col(13, 0, 1, 1, "Concelho");
        this.ui.add_col(14, 0, 1, 1, "NUTS II");
        this.P12.getJTable_QInv().getTableHeader().setUI(this.ui);
        this.handler.set_col_text(0, 0.06, "C");
        this.cboAtividades = this.handler.set_col_comboD(1, 0.06, "C", CTabelas.Atividades, 0, 200);
        this.handler.set_col_text(2, 0.2, null);
        this.handler.set_col_text(3, 0.25, null);
        this.handler.set_col_check(4, 0.08);
        this.handler.set_col_text(5, 0.1, null);
        this.handler.set_col_text(6, 0.15, "R");
        this.handler.set_col_text(7, 0.15, "R");
        this.handler.set_col_comboS(9, 0.25, null, CTabelas.TipoDesp, 1, 380);
        this.handler.set_col_comboS(11, 0.25, null, CTabelas.TipoProj, 1, 350);
        this.handler.set_col_comboS(13, 0.25, null, CTabelas.RubricasSNC, 1, 320);
        this.handler.set_col_comboS(15, 0.25, null, CTabelas.Pais, 1, 170);
        this.cboEstabs = this.handler.set_col_comboFD(16, 0.075, "C", CTabelas.EstabsF1, 1, 200);
        this.handler.set_col_text(18, 0.2, null);
        this.handler.set_col_text(20, 0.15, null);
        CBData.Atividades.addClient(this, "atividade", this.cboAtividades, " no Quadro de Investimentos");
        this.started = true;
    }

    void on_update(String colname, int nRow, String v) {
        this.numerar(0);
        if (colname.equals("classe_d")) {
            String classe = "";
            if (v.length() > 0) {
                classe = CTabelas.TipoDesp.lookup(1, v, 0);
            }
            this.setColValue("classe", nRow, classe);
        }
        if (colname.equals("classe")) {
            String classe_d = "";
            if (v.length() > 0) {
                classe_d = CTabelas.TipoDesp.lookup(0, v, 1);
            }
            this.setColValue("classe_d", nRow, classe_d);
        }
        if (colname.equals("snc_d")) {
            String snc = "";
            if (v.length() > 0) {
                snc = CTabelas.RubricasSNC.lookup(1, v, 0);
            }
            this.setColValue("snc", nRow, snc);
        }
        if (colname.equals("snc")) {
            String snc_d = "";
            if (v.length() > 0) {
                snc_d = CTabelas.RubricasSNC.lookup(0, v, 1);
            }
            this.setColValue("snc_d", nRow, snc_d);
        }
        if (colname.equals("tipologia_d")) {
            String tipologia = "";
            if (v.length() > 0) {
                tipologia = CTabelas.TipoProj.lookup(1, v, 0);
            }
            this.setColValue("tipologia", nRow, tipologia);
        }
        if (colname.equals("tipologia")) {
            String tipologia_d = "";
            if (v.length() > 0) {
                tipologia_d = CTabelas.TipoProj.lookup(0, v, 1);
            }
            this.setColValue("tipologia_d", nRow, tipologia_d);
        }
        if (colname.equals("mercado_d")) {
            String mercado = "";
            if (v.length() > 0) {
                mercado = CTabelas.Pais.lookup(1, v, 0);
            }
            this.setColValue("mercado", nRow, mercado);
        }
        if (colname.equals("mercado")) {
            String mercado_d = "";
            if (v.length() > 0) {
                mercado_d = CTabelas.Pais.lookup(0, v, 1);
            }
            this.setColValue("mercado_d", nRow, mercado_d);
        }
        if (colname.equals("estab")) {
            String concelho = "";
            String concelho_d = "";
            if (v.length() > 0) {
                CTabelas.EstabsF1.set_filter(3, "0");
                concelho = CTabelas.EstabsF1.lookup(0, v, 2);
            }
            this.setColValue("concelho", nRow, concelho);
            this.on_update("concelho", nRow, concelho);
        }
        if (colname.equals("concelho")) {
            String estab;
            if (CBData.reading_xml && v.length() > 0 && (estab = this.getColValue("estab", nRow)).length() == 0) {
                this.setColValue("concelho", nRow, "");
                this.setColValue("concelho_d", nRow, "");
                this.on_update("nuts_ii", nRow, "");
                this.setColValue("nuts_ii", nRow, "");
                return;
            }
            String concelho_d = "";
            if (v.length() > 0) {
                concelho_d = CTabelas.Concelhos.lookup(0, v, 1);
            }
            this.setColValue("concelho_d", nRow, concelho_d);
            if (v.length() > 0) {
                int idx = CTabelas.Concelhos.getIndexFromCode(v) + 1;
                String nuts = CTabelas.Concelhos.getColFromIndex(idx, 2).substring(0, 2);
                if (nuts.length() > 0 && !nuts.equals("99")) {
                    this.setColValue("nuts_ii", nRow, nuts);
                    this.on_update("nuts_ii", nRow, nuts);
                } else {
                    this.setColValue("nuts_ii", nRow, "");
                    this.setColValue("nuts_ii_d", nRow, "");
                }
            } else {
                this.setColValue("nuts_ii", nRow, "");
                this.on_update("nuts_ii", nRow, "");
            }
        }
        if (colname.equals("nuts_ii")) {
            String nuts_ii_d = "";
            if (v.length() > 0) {
                nuts_ii_d = CTabelas.NUTS_II.lookup(0, v, 1);
            }
            this.setColValue("nuts_ii_d", nRow, nuts_ii_d);
        }
        if (colname.equals("atividade")) {
            String atividade_d = "";
            if (v.length() > 0) {
                atividade_d = CTabelas.Atividades.lookup(0, v, 1);
            }
            this.setColValue("atividade_d", nRow, atividade_d);
            if (!CBData.reading_xml) {
                String tipologia = "";
                if (v.length() > 0) {
                    tipologia = CTabelas.Atividades.lookup(0, v, 2);
                }
                this.setColValue("tipologia", nRow, tipologia);
                this.on_update("tipologia", nRow, tipologia);
            }
        }
        if (!CBData.reading_xml) {
            this.calc_dados_projecto();
        }
        this.handler.j.repaint();
    }

    boolean existem_estabs() {
        int i = 0;
        while (i < this.dados.size()) {
            if (this.getColValue("estab", i).length() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void limpar_estabs() {
        int i = 0;
        while (i < this.dados.size()) {
            this.setColValue("estab", i, "");
            this.on_update("estab", i, "");
            ++i;
        }
    }

    void _filter_populate_estabs(SteppedComboBox cboEstabs, int row) {
        int n;
        String estabs = this.getColValue("estab", row);
        CTabelas.EstabsF1.set_filter(3, "0");
        CTabelas.EstabsF1._populateComboBox(cboEstabs, 0);
        if (estabs.length() > 0 && (n = CTabelas.EstabsF1.getIndexFromCode(estabs)) >= 0) {
            cboEstabs.setSelectedIndex(n + 1);
        }
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("classe")) {
            s = String.valueOf(s) + _lib.xml_encode("classe_d", this.getColValue("classe_d", row));
        }
        if (tag.equals("snc")) {
            s = String.valueOf(s) + _lib.xml_encode("snc_d", this.getColValue("snc_d", row));
        }
        if (tag.equals("tipologia")) {
            s = String.valueOf(s) + _lib.xml_encode("tipologia_d", this.getColValue("tipologia_d", row));
        }
        if (tag.equals("mercado")) {
            s = String.valueOf(s) + _lib.xml_encode("mercado_d", this.getColValue("mercado_d", row));
        }
        if (tag.equals("custos")) {
            s = String.valueOf(s) + _lib.xml_encode("custos_d", this.getColValue("custos_d", row));
        }
        if (tag.equals("concelho")) {
            s = String.valueOf(s) + _lib.xml_encode("concelho_d", this.getColValue("concelho_d", row));
            s = String.valueOf(s) + _lib.xml_encode("nuts_ii", this.getColValue("nuts_ii", row));
            s = String.valueOf(s) + _lib.xml_encode("nuts_ii_d", this.getColValue("nuts_ii_d", row));
        }
        return s;
    }

    void calc_dados_projecto() {
        if (!CBData.Finan.started) {
            return;
        }
        double inv = _lib.round(this.getSum("investimento"));
        double c_fse = _lib.to_double(CBData.FSE.getColValue("total", 10));
        CBData.investimento = _lib.to_string(inv + c_fse);
        CBData.DadosProjecto.getByName("inv_geral").setStringValue(_lib.to_string(inv));
        CBData.DadosProjecto.getByName("inv_fse").setStringValue(_lib.to_string(c_fse));
        CBData.DadosProjecto.getByName("investimento").setStringValue(_lib.to_string(inv + c_fse));
        double eleg = _lib.round(this.getSum("elegivel"));
        CBData.elegivel = _lib.to_string(eleg + c_fse);
        CBData.DadosProjecto.getByName("elegivel").setStringValue(Double.toString(eleg + c_fse));
        String ano_cand = CBData.Params.getByName("ano_cand").getStringValue();
        if (ano_cand.length() > 0) {
            String eleg6;
            String inv6;
            String eleg5;
            String inv5;
            String eleg4;
            String inv4;
            String eleg3;
            String inv3;
            String eleg2;
            String inv2;
            String eleg1;
            String inv1;
            String eleg0;
            String inv0;
            String eleg_1;
            String inv_1;
            int row_inv = CBData.Finan.h(20);
            int row_eleg = CBData.Finan.h(21);
            int ano = Integer.parseInt(ano_cand);
            double fse_1 = _lib.to_double(CBData.FSE.getColValue("val_p1", 10));
            ((String[])CBData.Finan.dados.elementAt((int)row_inv))[2] = inv_1 = _lib.to_string(_lib.round(this.getSum("investimento", Integer.toString(ano - 1)) + fse_1));
            ((String[])CBData.Finan.dados.elementAt((int)row_eleg))[2] = eleg_1 = _lib.to_string(_lib.round(this.getSum("elegivel", Integer.toString(ano - 1)) + fse_1));
            double fse0 = _lib.to_double(CBData.FSE.getColValue("val_0", 10));
            ((String[])CBData.Finan.dados.elementAt((int)row_inv))[3] = inv0 = _lib.to_string(_lib.round(this.getSum("investimento", Integer.toString(ano)) + fse0));
            ((String[])CBData.Finan.dados.elementAt((int)row_eleg))[3] = eleg0 = _lib.to_string(_lib.round(this.getSum("elegivel", Integer.toString(ano)) + fse0));
            double fse1 = _lib.to_double(CBData.FSE.getColValue("val_1", 10));
            ((String[])CBData.Finan.dados.elementAt((int)row_inv))[4] = inv1 = _lib.to_string(_lib.round(this.getSum("investimento", Integer.toString(ano + 1)) + fse1));
            ((String[])CBData.Finan.dados.elementAt((int)row_eleg))[4] = eleg1 = _lib.to_string(_lib.round(this.getSum("elegivel", Integer.toString(ano + 1)) + fse1));
            double fse2 = _lib.to_double(CBData.FSE.getColValue("val_2", 10));
            ((String[])CBData.Finan.dados.elementAt((int)row_inv))[5] = inv2 = _lib.to_string(_lib.round(this.getSum("investimento", Integer.toString(ano + 2)) + fse2));
            ((String[])CBData.Finan.dados.elementAt((int)row_eleg))[5] = eleg2 = _lib.to_string(_lib.round(this.getSum("elegivel", Integer.toString(ano + 2)) + fse2));
            double fse3 = _lib.to_double(CBData.FSE.getColValue("val_3", 10));
            ((String[])CBData.Finan.dados.elementAt((int)row_inv))[6] = inv3 = _lib.to_string(_lib.round(this.getSum("investimento", Integer.toString(ano + 3)) + fse3));
            ((String[])CBData.Finan.dados.elementAt((int)row_eleg))[6] = eleg3 = _lib.to_string(_lib.round(this.getSum("elegivel", Integer.toString(ano + 3)) + fse3));
            ((String[])CBData.Finan.dados.elementAt((int)row_inv))[7] = inv4 = _lib.to_string(_lib.round(this.getSum("investimento", Integer.toString(ano + 4))));
            ((String[])CBData.Finan.dados.elementAt((int)row_eleg))[7] = eleg4 = _lib.to_string(_lib.round(this.getSum("elegivel", Integer.toString(ano + 4))));
            ((String[])CBData.Finan.dados.elementAt((int)row_inv))[8] = inv5 = _lib.to_string(_lib.round(this.getSum("investimento", Integer.toString(ano + 5))));
            ((String[])CBData.Finan.dados.elementAt((int)row_eleg))[8] = eleg5 = _lib.to_string(_lib.round(this.getSum("elegivel", Integer.toString(ano + 5))));
            ((String[])CBData.Finan.dados.elementAt((int)row_inv))[9] = inv6 = _lib.to_string(_lib.round(this.getSum("investimento", Integer.toString(ano + 6))));
            ((String[])CBData.Finan.dados.elementAt((int)row_eleg))[9] = eleg6 = _lib.to_string(_lib.round(this.getSum("elegivel", Integer.toString(ano + 6))));
            CBData.Finan.on_update("val_p1", row_inv, "");
            CBData.Finan.on_update("val_p1", row_eleg, "");
            this.calc_regioes();
        }
    }

    void calc_regioes() {
        double inv = _lib.round(this.getSum("investimento"));
        double inv_fse = _lib.to_double(CBData.FSE.getColValue("total", CBData.FSE.dados.size() - 1));
        double internac = 0.0;
        double nute_norte = 0.0;
        double nute_centro = 0.0;
        double nute_lisboa = 0.0;
        double nute_alentejo = 0.0;
        double nute_algarve = 0.0;
        int i = 0;
        while (i < this.dados.size()) {
            if (this.getColValue("tipologia", i).startsWith("10")) {
                internac += _lib.to_double(this.getColValue("investimento", i));
            }
            if (this.getColValue("nuts_ii", i).equals("11")) {
                nute_norte += _lib.to_double(this.getColValue("investimento", i));
            }
            if (this.getColValue("nuts_ii", i).equals("16")) {
                nute_centro += _lib.to_double(this.getColValue("investimento", i));
            }
            if (this.getColValue("nuts_ii", i).equals("17")) {
                nute_lisboa += _lib.to_double(this.getColValue("investimento", i));
            }
            if (this.getColValue("nuts_ii", i).equals("18")) {
                nute_alentejo += _lib.to_double(this.getColValue("investimento", i));
            }
            if (this.getColValue("nuts_ii", i).equals("15")) {
                nute_algarve += _lib.to_double(this.getColValue("investimento", i));
            }
            ++i;
        }
        double nute_norte_fse = 0.0;
        double nute_centro_fse = 0.0;
        double nute_lisboa_fse = 0.0;
        double nute_alentejo_fse = 0.0;
        double nute_algarve_fse = 0.0;
        double total_accao = _lib.round(CBData.ListaAccoes.getSum("r1") + CBData.ListaAccoes.getSum("r2_i") + CBData.ListaAccoes.getSum("r2_e"));
        int i2 = 0;
        while (i2 < CBData.ListaAccoes.dados.size()) {
            double inv_accao = _lib.to_double(CBData.ListaAccoes.getColValue("r1", i2)) + _lib.to_double(CBData.ListaAccoes.getColValue("r2_i", i2)) + _lib.to_double(CBData.ListaAccoes.getColValue("r2_e", i2));
            if (CBData.ListaAccoes.getColValue("nuts_ii", i2).equals("11")) {
                nute_norte_fse += _lib.round(inv_accao);
            }
            if (CBData.ListaAccoes.getColValue("nuts_ii", i2).equals("16")) {
                nute_centro_fse += _lib.round(inv_accao);
            }
            if (CBData.ListaAccoes.getColValue("nuts_ii", i2).equals("17")) {
                nute_lisboa_fse += _lib.round(inv_accao);
            }
            if (CBData.ListaAccoes.getColValue("nuts_ii", i2).equals("18")) {
                nute_alentejo_fse += _lib.round(inv_accao);
            }
            if (CBData.ListaAccoes.getColValue("nuts_ii", i2).equals("15")) {
                nute_algarve_fse += _lib.round(inv_accao);
            }
            ++i2;
        }
        double proporcao = 1.0;
        if (total_accao <= inv_fse) {
            if (total_accao > 0.0) {
                proporcao = inv_fse / total_accao;
            }
        } else {
            inv_fse = total_accao;
        }
        nute_norte += (nute_norte_fse *= proporcao);
        nute_centro += (nute_centro_fse *= proporcao);
        nute_lisboa += (nute_lisboa_fse *= proporcao);
        nute_alentejo += (nute_alentejo_fse *= proporcao);
        nute_algarve += (nute_algarve_fse *= proporcao);
        double perc_internac = internac / inv * 100.0;
        CBData.perc_internac = _lib.to_string(perc_internac);
        double norte = _lib.round(nute_norte / (inv + inv_fse) * 100.0);
        CBData.nuts_ii_norte = norte != 0.0 ? _lib.to_string(norte) : "";
        double centro = _lib.round(nute_centro / (inv + inv_fse) * 100.0);
        CBData.nuts_ii_centro = centro != 0.0 ? _lib.to_string(centro) : "";
        double lisboa = _lib.round(nute_lisboa / (inv + inv_fse) * 100.0);
        CBData.nuts_ii_lisboa = lisboa != 0.0 ? _lib.to_string(lisboa) : "";
        double alentejo = _lib.round(nute_alentejo / (inv + inv_fse) * 100.0);
        CBData.nuts_ii_alentejo = alentejo != 0.0 ? _lib.to_string(alentejo) : "";
        double algarve = _lib.round(nute_algarve / (inv + inv_fse) * 100.0);
        CBData.nuts_ii_algarve = algarve != 0.0 ? _lib.to_string(algarve) : "";
        String PO = "";
        if (this.baixa_densidade.equals("1")) {
            if (nute_norte > 0.0) {
                PO = String.valueOf(PO) + "05;";
            }
            if (nute_centro > 0.0) {
                PO = String.valueOf(PO) + "06;";
            }
            if (nute_lisboa > 0.0) {
                PO = String.valueOf(PO) + "07;";
            }
            if (nute_alentejo > 0.0) {
                PO = String.valueOf(PO) + "08;";
            }
            if (nute_algarve > 0.0) {
                PO = String.valueOf(PO) + "09;";
            }
        } else if (nute_lisboa > 0.0 && nute_norte == 0.0 && nute_centro == 0.0 && nute_alentejo == 0.0 && nute_algarve == 0.0) {
            PO = String.valueOf(PO) + "07;";
        } else if (nute_lisboa == 0.0 && nute_norte == 0.0 && nute_centro == 0.0 && nute_alentejo == 0.0 && nute_algarve > 0.0) {
            PO = String.valueOf(PO) + "09;";
        } else {
            if (CBData.Dimensao.getByName((String)"dimensao").v.matches("1|2")) {
                if (nute_norte > 0.0 && nute_centro == 0.0 && nute_alentejo == 0.0) {
                    PO = String.valueOf(PO) + "05;";
                } else if (nute_norte == 0.0 && nute_centro > 0.0 && nute_alentejo == 0.0) {
                    PO = String.valueOf(PO) + "06;";
                } else if (nute_norte == 0.0 && nute_centro == 0.0 && nute_alentejo > 0.0) {
                    PO = String.valueOf(PO) + "08;";
                } else if (nute_norte > 0.0 || nute_centro > 0.0 || nute_alentejo > 0.0) {
                    PO = String.valueOf(PO) + "01;";
                }
            } else {
                PO = String.valueOf(PO) + "01;";
            }
            if (nute_lisboa > 0.0) {
                PO = String.valueOf(PO) + "07;";
            }
            if (nute_algarve > 0.0) {
                PO = String.valueOf(PO) + "09;";
            }
        }
        if (PO.length() > 0) {
            PO = PO.substring(0, PO.length() - 1);
        }
        CBData.Params.getByName("aut_gestao").setStringValue(PO);
        CBData.Params.getByName("norte").setStringValue(CBData.nuts_ii_norte);
        CBData.Params.getByName("centro").setStringValue(CBData.nuts_ii_centro);
        CBData.Params.getByName("lisboa").setStringValue(CBData.nuts_ii_lisboa);
        CBData.Params.getByName("alentejo").setStringValue(CBData.nuts_ii_alentejo);
        CBData.Params.getByName("algarve").setStringValue(CBData.nuts_ii_algarve);
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Quadro de Investimentos");
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("q_invest", "Lista vazia"));
        }
        boolean quadros_tecn = false;
        String[] aviso = ((String)CParseConfig.hconfig.get("aviso")).split("_");
        String data_i = CBData.DadosProjecto.getByName((String)"dt_inicio").v;
        String data_f = CBData.DadosProjecto.getByName((String)"dt_fim").v;
        String ano_i = data_i.length() > 0 ? data_i.substring(0, 4) : "";
        String ano_f = data_f.length() > 0 ? data_f.substring(0, 4) : "";
        boolean dentro_bd = this.baixa_densidade.equals("1");
        boolean fora_bd = this.baixa_densidade.equals("0");
        String estabs_bd = this.estabs_bd_ok(dentro_bd, fora_bd);
        int i = 0;
        while (i < this.dados.size()) {
            StringBuffer mask = new StringBuffer("RRRR-RRR-R-R-R--R----");
            String classe = this.getColValue("classe", i);
            if (classe.matches("2.*|31.*|32.*")) {
                mask.setCharAt(this.getColIndex("mercado_d"), 'R');
            }
            TabError[] e = this.isIncompletAll(i, mask.toString());
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                ++ii;
            }
            String calend = this.getColValue("calendario", i);
            if (calend.length() > 0) {
                String ano_calend = calend.substring(0, 4);
                if (ano_i.length() > 0 && Integer.parseInt(ano_calend) < Integer.parseInt(ano_i) - 1) {
                    err_list.add_msg(new CHValid_Msg("calendario", "Linha " + (i + 1) + ": Calendariza\u00e7\u00e3o Ano-M\u00eas - ano anterior a " + (Integer.parseInt(ano_i) - 1) + " (Ano de In\u00edcio do Projeto - 1)"));
                }
                if (data_f.length() > 0 && data_f.substring(0, 7).compareTo(calend) < 0) {
                    err_list.add_msg(new CHValid_Msg("calendario", "Linha " + (i + 1) + ": Calendariza\u00e7\u00e3o Ano-M\u00eas - posterior \u00e0 Data de Fim do Projeto (" + data_f + ")"));
                }
                if (CParseConfig.hconfig.get("limite_eleg") != null && ((String)CParseConfig.hconfig.get("limite_eleg")).length() > 0 && ((String)CParseConfig.hconfig.get("limite_eleg")).substring(0, 7).compareTo(calend) < 0) {
                    err_list.add_msg(new CHValid_Msg("calendario", 'W', "Linha " + (i + 1) + ": Calendariza\u00e7\u00e3o Ano-M\u00eas - posterior a " + (String)CParseConfig.hconfig.get("limite_eleg")));
                }
            }
            double inv = _lib.to_double(((String[])CBData.QInv.dados.elementAt(i))[CBData.QInv.getColIndex("investimento")]);
            double eleg = _lib.to_double(((String[])CBData.QInv.dados.elementAt(i))[CBData.QInv.getColIndex("elegivel")]);
            if (_lib.round(eleg) > _lib.round(inv)) {
                err_list.add_msg(new CHValid_Msg("elegivel", "Linha " + (i + 1) + ": o Eleg\u00edvel n\u00e3o pode ser superior ao Investimento"));
            }
            if (eleg > 0.0 && this.getColValue("classe", i).equals("999")) {
                err_list.add_msg(new CHValid_Msg("calendario", 'W', "Linha " + (i + 1) + ": despesa classificada como 'Despesas n\u00e3o eleg\u00edveis' com valor Eleg\u00edvel > 0"));
            }
            String tip = this.getColValue("tipologia", i);
            boolean tip_selected = false;
            if (!tip.equals("")) {
                int ii2 = 0;
                while (ii2 < CBData.Tipologia.dados.size()) {
                    if (tip.equals(CBData.Tipologia.getColValue("tipologia", ii2))) {
                        if (CBData.Tipologia.getColValue("select", ii2).equals("S")) {
                            tip_selected = true;
                        }
                        break;
                    }
                    ++ii2;
                }
            } else {
                tip_selected = true;
            }
            if (!tip_selected) {
                err_list.add_msg(new CHValid_Msg("tipologia", "Linha " + (i + 1) + ": Tipologia de Opera\u00e7\u00e3o n\u00e3o selecionada na p\u00e1gina de Dados do Projeto"));
            }
            String estab = this.getColValue("estab", i);
            if ((dentro_bd || fora_bd) && estab.length() > 0 && !estab.matches(estabs_bd)) {
                if (dentro_bd) {
                    err_list.add_msg(new CHValid_Msg("estab", "Linha " + (i + 1) + ": Estabelecimento n\u00ba " + estab + this.estab_conc_freg(estab) + " fora dos territ\u00f3rios de baixa densidade"));
                }
                if (fora_bd) {
                    err_list.add_msg(new CHValid_Msg("estab", "Linha " + (i + 1) + ": Estabelecimento n\u00ba " + estab + this.estab_conc_freg(estab) + " em territ\u00f3rio de baixa densidade"));
                }
            }
            if (this.getColValue("concelho", i).equals("9999")) {
                err_list.add_msg(new CHValid_Msg("concelho", "Linha " + (i + 1) + ": N\u00e3o pode apresentar investimentos no Estrangeiro"));
            }
            if (this.getColValue("classe", i).equals("130")) {
                quadros_tecn = true;
            }
            ++i;
        }
        if (!quadros_tecn && CBData.QuadrosTecn.started && !CBData.QuadrosTecn.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("classe", "Obrigat\u00f3rio incluir despesas com contrata\u00e7\u00e3o de pessoal"));
        }
        String aviso_n_deve_lx_alg = "Nos termos do Aviso de Abertura, os projetos com investimentos localizados nas regi\u00f5es de Lisboa e Algarve, o promotor dever\u00e1 apresentar uma candidatura aut\u00f3noma para os investimentos localizados nessas regi\u00f5es.";
        String aviso_n_deve_alg = "Nos projetos com investimentos localizados na regi\u00e3o do Algarve o promotor deve apresentar candidatura aut\u00f3noma para os investimentos localizados nessa regi\u00e3o.";
        String aviso_n_pode_lisboa = "Nos termos do Aviso de Abertura, o projeto n\u00e3o dever\u00e1 incluir investimentos localizados na regi\u00e3o NUTS II Lisboa.";
        if (((String)CParseConfig.hconfig.get("nuts_invest")).equals("n_deve_lx_alg") && (_lib.to_double(CBData.nuts_ii_lisboa) > 0.0 && _lib.to_double(CBData.nuts_ii_lisboa) != 100.0 || _lib.to_double(CBData.nuts_ii_algarve) > 0.0 && _lib.to_double(CBData.nuts_ii_algarve) != 100.0)) {
            err_list.add_msg(new CHValid_Msg("concelho", aviso_n_deve_lx_alg));
        }
        if (((String)CParseConfig.hconfig.get("nuts_invest")).equals("n_deve_alg") && _lib.to_double(CBData.nuts_ii_algarve) > 0.0 && _lib.to_double(CBData.nuts_ii_algarve) != 100.0) {
            err_list.add_msg(new CHValid_Msg("concelho", 'W', aviso_n_deve_alg));
        }
        if (((String)CParseConfig.hconfig.get("nuts_invest")).equals("n_pode_lisboa") && _lib.to_double(CBData.nuts_ii_lisboa) > 0.0) {
            err_list.add_msg(new CHValid_Msg("concelho", 'W', aviso_n_pode_lisboa));
        }
        return err_list;
    }

    String estabs_bd_ok(boolean dentro, boolean fora) {
        if (!dentro && !fora) {
            return "";
        }
        String territorios_bd = "1601.*|1603.*|1604.*|1605.*|1606.*|1610.*|0310.*|0313.*|0304.*|0307.*|1705.*|0309.*|0311.*|0104.*|1702.*|1703.*|1706.*|1709.*|1712.*|1713.*|1302.*|0305.*|1804.*|1813.*|1701.*|1801.*|0403.*|0404.*|1805.*|1704.*|1807.*|1707.*|1812.*|1708.*|1710.*|1711.*|1815.*|1818.*|1819.*|1820.*|0409.*|0914.*|1714.*|0401.*|0402.*|0405.*|0406.*|0407.*|0408.*|0410.*|0411.*|0412.*|0117.*|0601.*|0606.*|0607.*|0609.*|1808.*|0611.*|0612.*|0613.*|0614.*|0615.*|0616.*|0617.*|1002.*|1003.*|1007.*|1008.*|1013.*|0901.*|1802.*|1803.*|1806.*|1809.*|1810.*|1811.*|1814.*|1816.*|1817.*|1821.*|1822.*|1824.*|0502.*|0505.*|0506.*|0507.*|0508.*|0511.*|1401.*|1408.*|1411.*|1413.*|1417.*|0509.*|0510.*|1420.*|0902.*|0501.*|0903.*|0503.*|0904.*|0905.*|0504.*|0906.*|0907.*|0908.*|0909.*|0910.*|0911.*|0912.*|0913.*|1501.*|1505.*|0211.*|1509.*|0201.*|0202.*|0203.*|0204.*|0205.*|0206.*|0207.*|0208.*|0209.*|0210.*|0212.*|0213.*|0214.*|1407.*|1409.*|1201.*|1202.*|1203.*|1204.*|1205.*|1206.*|1207.*|1208.*|1209.*|1210.*|1211.*|1212.*|1213.*|1214.*|1215.*|0701.*|0702.*|0703.*|0704.*|0705.*|0706.*|0707.*|0708.*|0709.*|0710.*|0711.*|0712.*|0713.*|0714.*|0802.*|0803.*|0804.*|0809.*|0815.*|160209|160221|160223|160701|160753|160754|160755|160707|160709|160756|160757|160713|160717|160724|160727|160728|160729|160759|160760|160734|160746|160802|160805|160818|160819|160920|030120|030112|030126|030129|030877|011901|011905|130103|130107|130134|130118|130128|130129|130141|130143|130146|130139|010606|130740|010123|010127|060407|101501|101610|182305|182307|182310|182322|182329|182335|142105|142119|142121|142122|141808|141814|141817|141818|141820|141631|080802|080803|080807|080812|081306|081401|081404";
        String estabs_ok = "";
        int i = 0;
        while (i < CBData.PromLocal.dados.size()) {
            String freguesia = CBData.PromLocal.getColValue("freguesia", i);
            if (freguesia.length() != 0) {
                String estab = CBData.PromLocal.getColValue("n_estab", i);
                if (dentro && freguesia.matches(territorios_bd)) {
                    estabs_ok = String.valueOf(estabs_ok) + estab + "|";
                }
                if (fora && !freguesia.matches(territorios_bd)) {
                    estabs_ok = String.valueOf(estabs_ok) + estab + "|";
                }
            }
            ++i;
        }
        if (estabs_ok.length() > 0) {
            return estabs_ok.substring(0, estabs_ok.length() - 1);
        }
        return "";
    }

    String estab_conc_freg(String estab) {
        int i = 0;
        while (i < CBData.PromLocal.dados.size()) {
            if (estab.equals(CBData.PromLocal.getColValue("n_estab", i))) {
                String freguesia_d = CBData.PromLocal.getColValue("freguesia_d", i);
                String concelho_d = CBData.PromLocal.getColValue("concelho_d", i);
                return " [" + concelho_d + " | " + freguesia_d + "]";
            }
            ++i;
        }
        return " ?";
    }
}

