/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHCampo;
import fme.CHCampo_Combo;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Proj_1;
import fme._lib;
import fme.fmeApp;
import java.util.Date;

class CBRegisto_DadosProjecto
extends CBRegisto {
    public Frame_Proj_1 P07;

    public String getPagina() {
        return "Proj_1";
    }

    CBRegisto_DadosProjecto() {
        this.tag = "DadosProjecto";
        this.P07 = (Frame_Proj_1)fmeApp.Paginas.getPage("Proj_1");
        if (this.P07 == null) {
            return;
        }
        this.started = true;
        this.Campos.add(new CHCampo_Text("designacao", this.P07.getJTextField_Designacao(), null, this));
        this.Campos.add(new CHCampo_Combo("modalidade", "ModProj", this.P07.getJComboBox_Modalidade(), this));
        this.Campos.add(new CHCampo_Text("dt_inicio", this.P07.getJTextField_Inicio(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("n_meses", this.P07.getJTextField_Meses(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_Text("dt_fim", this.P07.getJTextField_Fim(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("inv_geral", this.P07.getJTextField_InvQInv(), CFLib.VLD_VALOR, null));
        this.Campos.add(new CHCampo_Text("inv_pessoal", this.P07.getJTextField_InvPessoal(), CFLib.VLD_VALOR, null));
        this.Campos.add(new CHCampo_Text("investimento", this.P07.getJTextField_InvTotal(), CFLib.VLD_VALOR, null));
    }

    void Clear() {
        int i = 0;
        while (i < this.Campos.size()) {
            if (!(((CHCampo)this.Campos.elementAt((int)i)).tag.equals("investimento") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("inv_geral") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("inv_custos") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("cust_pess"))) {
                ((CHCampo)this.Campos.elementAt(i)).clear();
            }
            ++i;
        }
    }

    void on_update(String tag) {
        if (tag.equals("dt_inicio") || tag.equals("dt_fim")) {
            String dt_inicio = this.getByName((String)"dt_inicio").v;
            String dt_fim = this.getByName((String)"dt_fim").v;
            if (dt_inicio.length() == 0 || dt_fim.length() == 0 || dt_fim.compareTo(dt_inicio) < 0) {
                this.getByName("n_meses").setStringValue("");
                return;
            }
            this.getByName("n_meses").setStringValue(Double.toString(this.n_meses(dt_inicio, dt_fim)));
        }
    }

    double n_meses(String dt_inicio, String dt_fim) {
        int ano_i = Integer.parseInt(dt_inicio.substring(0, 4));
        int ano_f = Integer.parseInt(dt_fim.substring(0, 4));
        int mes_i = Integer.parseInt(dt_inicio.substring(5, 7));
        int mes_f = Integer.parseInt(dt_fim.substring(5, 7));
        int dia_i = Integer.parseInt(dt_inicio.substring(8, 10));
        int dia_f = Integer.parseInt(dt_fim.substring(8, 10));
        double n_meses = (ano_f - ano_i) * 12 + (mes_f - mes_i - 1);
        double mes = mes_i;
        double d = 0.0;
        if (mes == 1.0 || mes == 3.0 || mes == 5.0 || mes == 7.0 || mes == 8.0 || mes == 10.0 || mes == 12.0) {
            d = 31.0;
        }
        if (mes == 4.0 || mes == 6.0 || mes == 9.0 || mes == 11.0) {
            d = 30.0;
        }
        if (mes == 2.0 && ano_i % 4 == 0) {
            d = 29.0;
        }
        if (mes == 2.0 && ano_i % 4 != 0) {
            d = 28.0;
        }
        n_meses += (d - (double)dia_i + 1.0) / d;
        mes = mes_f;
        if (mes == 1.0 || mes == 3.0 || mes == 5.0 || mes == 7.0 || mes == 8.0 || mes == 10.0 || mes == 12.0) {
            d = 31.0;
        }
        if (mes == 4.0 || mes == 6.0 || mes == 9.0 || mes == 11.0) {
            d = 30.0;
        }
        if (mes == 2.0 && ano_f % 4 == 0) {
            d = 29.0;
        }
        if (mes == 2.0 && ano_f % 4 != 0) {
            d = 28.0;
        }
        return n_meses += (double)dia_f / d;
    }

    String on_xml(String tag) {
        String c;
        String s = "";
        if (tag.equals("dominio")) {
            c = this.getByName(tag).getStringValue();
            s = c.length() == 0 ? String.valueOf(s) + "<dominio_d/>\n" : String.valueOf(s) + _lib.xml_encode("dominio_d", CTabelas.Dominios.getDesign(c));
        }
        if (tag.equals("modalidade")) {
            c = this.getByName(tag).getStringValue();
            s = c.length() == 0 ? String.valueOf(s) + "<modalidade_d/>\n" : String.valueOf(s) + _lib.xml_encode("modalidade_d", CTabelas.ModProj.getDesign(c));
        }
        return s;
    }

    CHValid_Grp validar_1(CHValid_Grp err_list, boolean tipologia) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Descri\u00e7\u00e3o e Tipologia(s) do Projeto");
        }
        this.extract();
        if (this.getByName("designacao").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("designacao", "Designa\u00e7\u00e3o do Projeto - %o"));
        }
        if (this.getByName("modalidade").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("modalidade", "Modalidade - %o"));
        }
        if (tipologia) {
            CBData.Tipologia.validar(err_list);
        }
        return err_list;
    }

    CHValid_Grp validar_2(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Calendariza\u00e7\u00e3o");
        }
        this.extract();
        if (this.getByName("dt_inicio").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de In\u00edcio - %o"));
        }
        if (this.getByName("dt_fim").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_fim", "Data de Fim - %o"));
        }
        Date today = new Date();
        Date dt_inicio = CFType_Data.parse_date(this.getByName((String)"dt_inicio").v);
        Date dt_fim = CFType_Data.parse_date(this.getByName((String)"dt_fim").v);
        if (dt_inicio != null && dt_fim != null && dt_fim.before(dt_inicio)) {
            err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de In\u00edcio n\u00e3o pode ser posterior \u00e0 Data de Fim"));
        }
        return err_list;
    }
}

