/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData_Comum;
import fme.CBRegisto;
import fme.CFLib;
import fme.CFType_AnoCand;
import fme.CHCampo;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHCampo_TextArea;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CParseConfig;
import fme.CTabelas;
import fme.Frame_Params;
import fme._lib;
import fme.fmeApp;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

class CBRegisto_Params
extends CBRegisto {
    Frame_Params P;
    int limite = 250;
    Vector ano_cand_updates = new Vector();

    public String getPagina() {
        return "Params";
    }

    CBRegisto_Params() {
        this.tag = "Parametros";
        this.P = (Frame_Params)fmeApp.Paginas.getPage("Params");
        if (this.P == null) {
            return;
        }
        this.started = true;
        this.Campos.add(new CHCampo_Text("ano_cand", this.P.getJTextField_AnoCand(), CFLib.VLD_ANO_CAND, this));
        this.Campos.add(new CHCampo_Text("aut_gestao", this.P.jTextField_ProgOperacional, null, this));
        this.Campos.add(new CHCampo_Text("aut_gestao_d", this.P.jTextField_ProgOperacionalD, null, this));
        this.Campos.add(new CHCampo_Text("obj_tema", this.P.jTextField_ObjTematico, null, this));
        this.Campos.add(new CHCampo_Text("obj_tema_d", this.P.jTextField_ObjTematicoD, null, this));
        this.Campos.add(new CHCampo_Text("prioridade", this.P.jTextField_Prioridade, null, this));
        this.Campos.add(new CHCampo_Text("prioridade_d", this.P.jTextField_PrioridadeD, null, this));
        this.Campos.add(new CHCampo_Text("tipologia", this.P.jTextField_Tipologia, null, this));
        this.Campos.add(new CHCampo_Text("tipologia_d", this.P.jTextField_TipologiaD, null, this));
        this.Campos.add(new CHCampo_Text("norte", this.P.getJTextField_Norte(), CFLib.VLD_PERC_0, this));
        this.Campos.add(new CHCampo_Text("centro", this.P.getJTextField_Centro(), CFLib.VLD_PERC_0, this));
        this.Campos.add(new CHCampo_Text("lisboa", this.P.getJTextField_Lisboa(), CFLib.VLD_PERC_0, this));
        this.Campos.add(new CHCampo_Text("alentejo", this.P.getJTextField_Alentejo(), CFLib.VLD_PERC_0, this));
        this.Campos.add(new CHCampo_Text("algarve", this.P.getJTextField_Algarve(), CFLib.VLD_PERC_0, this));
        CHCampo_Opt opt_c = new CHCampo_Opt("ambito", this);
        opt_c.setOptions("1", "2");
        opt_c.addComponent(this.P.getJCheckBox_Individual());
        opt_c.addComponent(this.P.getJCheckBox_CoPromocao());
        opt_c.dummy = this.P.jCheckBox_Ambito_Clear;
        this.Campos.add(opt_c);
        this.Campos.add(new CHCampo_TextArea("txt_resumo", this.P.getJTextArea_Resumo(), null));
        if (CParseConfig.hconfig.get("ano_cand_inicial") != null) {
            CFType_AnoCand.ano_inicial = Integer.parseInt(CParseConfig.hconfig.get("ano_cand_inicial").toString());
        }
        if (CParseConfig.hconfig.get("ano_cand_final") != null) {
            CFType_AnoCand.ano_final = Integer.parseInt(CParseConfig.hconfig.get("ano_cand_final").toString());
        }
    }

    void Clear() {
        int i = 0;
        while (i < this.Campos.size()) {
            if (!(((CHCampo)this.Campos.elementAt((int)i)).tag.startsWith("aut_gestao") || ((CHCampo)this.Campos.elementAt((int)i)).tag.startsWith("obj_tema") || ((CHCampo)this.Campos.elementAt((int)i)).tag.startsWith("prioridade") || ((CHCampo)this.Campos.elementAt((int)i)).tag.startsWith("tipologia"))) {
                ((CHCampo)this.Campos.elementAt(i)).clear();
            }
            ++i;
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Enquadramento no Aviso de Abertura");
        }
        this.extract();
        if (this.getByName("ano_cand").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("ano_cand", "Ano de Refer\u00eancia - %o"));
        } else {
            int ano = Integer.parseInt(this.getByName((String)"ano_cand").v);
            if (ano < CFType_AnoCand.ano_inicial || ano > CFType_AnoCand.ano_final) {
                err_list.add_msg(new CHValid_Msg("ano_cand", "Ano de Candidatura inv\u00e1lido"));
            }
        }
        double norte = _lib.to_double(this.getByName((String)"norte").v);
        double centro = _lib.to_double(this.getByName((String)"centro").v);
        double lisboa = _lib.to_double(this.getByName((String)"lisboa").v);
        double alentejo = _lib.to_double(this.getByName((String)"alentejo").v);
        double algarve = _lib.to_double(this.getByName((String)"algarve").v);
        if (_lib.round(norte + centro + lisboa + alentejo + algarve) != 100.0) {
            err_list.add_msg(new CHValid_Msg("ambito", "Localiza\u00e7\u00e3o do Projeto (NUTS II) - Deve perfazer 100%"));
        }
        if (this.getByName("ambito").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("ambito", "N\u00ba de entidades promotoras - %o"));
        }
        if (this.getByName("txt_resumo").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("txt_resumo", "Resumo - %o"));
        } else if (this.getByName((String)"txt_resumo").v.length() > this.limite) {
            String erro = "Texto demasiado extenso. Por favor, abrevie at\u00e9 " + this.limite + " caracteres.";
            err_list.add_msg(new CHValid_Msg("txt_resumo", "Resumo - " + erro));
        }
        return err_list;
    }

    void init() {
        Date d = new Date();
        int ano = d.getYear() + 1900;
        if (CParseConfig.hconfig.get("ano_cand") != null) {
            this.getByName("ano_cand").setStringValue(CParseConfig.hconfig.get("ano_cand").toString());
            this.P.getJTextField_AnoCand().setEditable(false);
            this.P.getJTextField_AnoCand().setVisible(false);
            this.P.jLabel_LblAnoCand.setVisible(false);
        } else {
            this.getByName("ano_cand").setStringValue(String.valueOf(ano));
            this.P.getJTextField_AnoCand().setEditable(true);
            this.P.getJTextField_AnoCand().setVisible(true);
            this.P.jLabel_LblAnoCand.setVisible(true);
        }
        this.on_update("ano_cand");
        this.update_rosto();
    }

    void update_rosto() {
        this.getByName("aut_gestao").setStringValue(CParseConfig.hconfig.get("aut_gestao").toString());
        this.getByName("obj_tema").setStringValue(CParseConfig.hconfig.get("obj_tema").toString());
        this.getByName("prioridade").setStringValue(CParseConfig.hconfig.get("prioridade").toString());
        this.getByName("tipologia").setStringValue(CParseConfig.hconfig.get("tipologia").toString());
    }

    void after_open() {
        this.update_rosto();
        if (CParseConfig.hconfig.get("ano_cand") == null) {
            return;
        }
        String old = this.getByName((String)"ano_cand").v;
        String actual = CParseConfig.hconfig.get("ano_cand").toString();
        if (old.equals(actual)) {
            return;
        }
        this.getByName("ano_cand").setStringValue(actual);
        JOptionPane.showMessageDialog(null, "<html>O ficheiro que abriu foi preenchido com uma vers\u00e3o anterior do formul\u00e1rio.<br>O ano pr\u00e9-projeto foi alterado para " + (_lib.to_int(actual) - 1) + ",<br>p.f. <strong><u>corrija todos os campos e quadros indexados a este ano</u></strong>.</html>", "Aviso", 2);
    }

    void on_update(String tag) {
        CHCampo chc;
        if (tag.equals("txt_resumo") && (chc = this.getByName(tag)) instanceof CHCampo_TextArea) {
            JTextArea jta = ((CHCampo_TextArea)chc).jcomp;
            int n = jta.getText().length();
            this.P.jLabel_Count.setText(String.valueOf(this.limite - n) + "/" + this.limite);
        }
        if (tag.equals("ambito")) {
            CTabelas.Empresas.refresh();
        }
        if (tag.equals("ano_cand")) {
            int i = 0;
            while (i < this.ano_cand_updates.size()) {
                ((CBData_Comum)this.ano_cand_updates.elementAt(i)).on_external_update(tag);
                ++i;
            }
        }
        if (tag.equals("aut_gestao")) {
            String aut_gestao_d = "";
            if (this.getByName((String)tag).v.length() > 0) {
                String[] POs = this.getByName((String)tag).v.split(";");
                int count = POs.length;
                int i = 0;
                while (i < POs.length) {
                    if (aut_gestao_d.length() > 0) {
                        aut_gestao_d = String.valueOf(aut_gestao_d) + "; ";
                    }
                    aut_gestao_d = String.valueOf(aut_gestao_d) + CTabelas.POs.lookup(0, POs[i], 1);
                    ++i;
                }
            }
            this.P.jLabel_ProgOperacional.setText("<html>" + aut_gestao_d + "</html>");
            this.getByName("aut_gestao_d").setStringValue(aut_gestao_d);
        }
        if (tag.equals("obj_tema")) {
            String obj_tema_d = "";
            if (this.getByName((String)tag).v.length() > 0) {
                obj_tema_d = String.valueOf(obj_tema_d) + CTabelas.ObjTematico.lookup(0, this.getByName((String)tag).v, 1);
                obj_tema_d = String.valueOf(obj_tema_d) + " - " + CTabelas.ObjTematico.lookup(0, this.getByName((String)tag).v, 2);
            }
            this.P.jLabel_ObjTematico.setText("<html>" + obj_tema_d + "</html>");
            this.getByName("obj_tema_d").setStringValue(obj_tema_d);
        }
        if (tag.equals("prioridade")) {
            String prioridade_d = "";
            if (this.getByName((String)tag).v.length() > 0) {
                prioridade_d = String.valueOf(prioridade_d) + CTabelas.PrioridadeInvest.lookup(0, this.getByName((String)tag).v, 1);
                prioridade_d = String.valueOf(prioridade_d) + " - " + CTabelas.PrioridadeInvest.lookup(0, this.getByName((String)tag).v, 2);
            }
            this.P.jLabel_Prioridade.setText("<html>" + prioridade_d + "</html>");
            this.getByName("prioridade_d").setStringValue(prioridade_d);
        }
        if (tag.equals("tipologia")) {
            String tipologia_d = "";
            if (this.getByName((String)tag).v.length() > 0) {
                tipologia_d = String.valueOf(tipologia_d) + CTabelas.TipologiaInterv.lookup(0, this.getByName((String)tag).v, 1);
                tipologia_d = String.valueOf(tipologia_d) + " - " + CTabelas.TipologiaInterv.lookup(0, this.getByName((String)tag).v, 2);
            }
            this.P.jLabel_Tipologia.setText("<html>" + tipologia_d + "</html>");
            this.getByName("tipologia_d").setStringValue(tipologia_d);
        }
    }

    void bind_ano_cand_update(CBData_Comum d) {
        this.ano_cand_updates.add(d);
    }
}

