/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Tecnicos;
import fme.GroupableTableHeaderUI;
import fme.SteppedComboBox;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;
import javax.swing.JOptionPane;

class CBTabela_Tecnicos
extends CBTabela {
    Frame_Tecnicos PAG;
    public SteppedComboBox cboEntidades = null;
    public SteppedComboBox cboEstabs = null;
    String[] anos = new String[]{"Ano 0", "Ano 1", "Ano 2", "Ano 3"};

    public String getPagina() {
        return "Tecnicos";
    }

    CBTabela_Tecnicos() {
        this.tag = "Tecnicos";
        this.PAG = (Frame_Tecnicos)fmeApp.Paginas.getPage("Tecnicos");
        if (this.PAG == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_Tecnicos(Frame_Tecnicos p) {
        this.tag = "Tecnicos";
        this.PAG = p;
        this.initialize();
    }

    void initialize() {
        this.PAG.CBData_Tecnicos = this;
        this.force_xml = true;
        this.started = true;
        this.cols = new CHTabColModel[28];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, null);
        this.cols[1] = new CHTabColModel("nif", "NIF", true, true, true, CFLib.VLD_NIF);
        this.cols[2] = new CHTabColModel("nome", "Nome", true, true, true, null);
        this.cols[3] = new CHTabColModel("coprom", "Entidade<br>Benefici\u00e1ria (id)", true, true, false, null);
        this.cols[4] = new CHTabColModel("coprom_d", "Entidade<br>Benefici\u00e1ria", false, true, true, null);
        this.cols[5] = new CHTabColModel("cat_prof", null, true, false, false, null);
        this.cols[6] = new CHTabColModel("cat_prof_d", "Categoria<br>Profissional", false, true, true, null);
        this.cols[7] = new CHTabColModel("funcao", "Fun\u00e7\u00e3o no projeto", true, true, true, null);
        this.cols[8] = new CHTabColModel("nivel", null, true, false, false, null);
        this.cols[9] = new CHTabColModel("nivel_d", "N\u00edvel de<br>Qualifica\u00e7\u00e3o", false, true, true, null);
        this.cols[10] = new CHTabColModel("classe_pessoal", null, true, false, false, null);
        this.cols[11] = new CHTabColModel("classe_pessoal_d", "Classifica\u00e7\u00e3o de<br>Pessoal", false, true, true, null);
        this.cols[12] = new CHTabColModel("venc_mes", "Sal\u00e1rio Base Mensal<br>(sem Subs\u00eddio<br>Refei\u00e7\u00e3o)", true, true, true, CFLib.VLD_VALOR);
        this.cols[13] = new CHTabColModel("taxa_segs", "Taxa de<br>Encargos<br>Sociais", true, true, true, CFLib.VLD_PERC_0);
        this.cols[14] = new CHTabColModel("n_meses_0", "N\u00ba Meses<br>de dura\u00e7\u00e3o<br>do projeto<br>ano 0", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[15] = new CHTabColModel("n_meses_1", "N\u00ba Meses<br>de dura\u00e7\u00e3o<br>do projeto<br>ano 1", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[16] = new CHTabColModel("n_meses_2", "N\u00ba Meses<br>de dura\u00e7\u00e3o<br>do projeto<br>ano 2", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[17] = new CHTabColModel("n_meses_3", "N\u00ba Meses<br>de dura\u00e7\u00e3o<br>do projeto<br>ano 3", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[18] = new CHTabColModel("taxa_imput_0", "Taxa de<br>Imputa\u00e7\u00e3o<br>ano 0", true, true, true, CFLib.VLD_PERC_0);
        this.cols[19] = new CHTabColModel("taxa_imput_1", "Taxa de<br>Imputa\u00e7\u00e3o<br>ano 1", true, true, true, CFLib.VLD_PERC_0);
        this.cols[20] = new CHTabColModel("taxa_imput_2", "Taxa de<br>Imputa\u00e7\u00e3o<br>ano 2", true, true, true, CFLib.VLD_PERC_0);
        this.cols[21] = new CHTabColModel("taxa_imput_3", "Taxa de<br>Imputa\u00e7\u00e3o<br>ano 3", true, true, true, CFLib.VLD_PERC_0);
        this.cols[22] = new CHTabColModel("n_horas_sem", "N\u00ba Horas<br>semanais", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[23] = new CHTabColModel("custo_0", "Custo total<br>ano 0", true, false, true, CFLib.VLD_VALOR);
        this.cols[24] = new CHTabColModel("custo_1", "Custo total<br>ano 1", true, false, true, CFLib.VLD_VALOR);
        this.cols[25] = new CHTabColModel("custo_2", "Custo total<br>ano 2", true, false, true, CFLib.VLD_VALOR);
        this.cols[26] = new CHTabColModel("custo_3", "Custo total<br>ano 3", true, false, true, CFLib.VLD_VALOR);
        this.cols[27] = new CHTabColModel("custo_total", "Custo total", true, false, true, CFLib.VLD_VALOR);
        this.init_dados(1);
        this.init_handler(this.PAG.getJTable_Tecnicos());
        this.PAG.getJTable_Tecnicos().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_Tecnicos().getWidth() - 20;
        this.on_external_update("");
        this.handler.set_col_text(0, 0.05, "C");
        this.handler.set_col_text(1, 0.1, null);
        this.handler.set_col_text(2, 0.3, null);
        this.cboEntidades = this.handler.set_col_comboS(4, 0.12, null, CTabelas.Empresas, 1, 200);
        this.handler.set_col_comboS(6, 0.2, null, CTabelas.CatProfissional, 1, 150);
        this.handler.set_col_text(7, 0.3, null);
        this.handler.set_col_comboS(9, 0.1, null, CTabelas.NiveisQual, 1, 100);
        this.handler.set_col_comboS(11, 0.2, null, CTabelas.RubPessoal, 1, 150);
        this.handler.set_col_text(12, 0.13, "R");
        this.handler.set_col_text(13, 0.09, "R");
        this.handler.set_col_text(14, 0.07, "R");
        this.handler.set_col_text(15, 0.07, "R");
        this.handler.set_col_text(16, 0.07, "R");
        this.handler.set_col_text(17, 0.07, "R");
        this.handler.set_col_text(18, 0.07, "R");
        this.handler.set_col_text(19, 0.07, "R");
        this.handler.set_col_text(20, 0.07, "R");
        this.handler.set_col_text(21, 0.07, "R");
        this.handler.set_col_text(22, 0.09, "R");
        this.handler.set_col_text(23, 0.11, "R");
        this.handler.set_col_text(24, 0.11, "R");
        this.handler.set_col_text(25, 0.11, "R");
        this.handler.set_col_text(26, 0.11, "R");
        this.handler.set_col_text(27, 0.11, "R");
        CBData.Params.bind_ano_cand_update(this);
    }

    boolean on_del_row(boolean cascade) {
        this.handler.__garbage_stop_editing();
        int n = this.handler.j.getSelectedRow();
        int m = this.handler.j.getRowCount();
        if (n < m && n != -1) {
            Object[] options = new Object[]{"   Sim   ", "   N\u00e3o   "};
            int q = JOptionPane.showOptionDialog(null, "<html>A linha selecionada " + (cascade ? "<strong><u>e toda a informa\u00e7\u00e3o associada</u></strong> " : "") + "ser\u00e1 eliminada. Pretende continuar?</html>", "Apagar Linha", 0, 3, null, options, options[1]);
            if (q == 0) {
                this.del_row_at(n);
                this.handler.j.revalidate();
                this.handler.j.repaint();
                return true;
            }
        } else {
            JOptionPane.showMessageDialog(null, "N\u00e3o selecionou nenhuma linha na tabela!", "Apagar Linha", 1, null);
        }
        return false;
    }

    boolean on_add_row() {
        this.add_row();
        this.handler.j.revalidate();
        this.handler.j.repaint();
        return true;
    }

    boolean on_ins_row(boolean remove_empty) {
        this.handler.__garbage_stop_editing();
        int n = this.handler.j.getSelectedRow();
        if (n >= 0) {
            this.ins_row_at(n, remove_empty);
            this.handler.j.revalidate();
            this.handler.j.repaint();
            return true;
        }
        return false;
    }

    public void xmlBegin(String path) {
        ++this.idx_xml;
        if (this.idx_xml >= this.dados.size()) {
            this.add_row();
        }
    }

    void numerar(int nCol) {
        int n = 0;
        int i = 0;
        while (i < this.dados.size()) {
            ((String[])this.dados.elementAt((int)i))[nCol] = Integer.toString(++n);
            ++i;
        }
    }

    void on_update(String colname, int nRow, String v) {
        this.numerar(0);
        if (colname.equals("classe_pessoal")) {
            String classe_pessoal_d = "";
            if (v.length() > 0) {
                classe_pessoal_d = CTabelas.RubPessoal.lookup(0, v, 1);
            }
            this.setColValue("classe_pessoal_d", nRow, classe_pessoal_d);
        }
        if (colname.equals("classe_pessoal_d")) {
            String classe_pessoal = "";
            if (v.length() > 0) {
                classe_pessoal = CTabelas.RubPessoal.lookup(1, v, 0);
            }
            this.setColValue("classe_pessoal", nRow, classe_pessoal);
        }
        if (colname.equals("cat_prof")) {
            String cat_prof_d = "";
            if (v.length() > 0) {
                cat_prof_d = CTabelas.CatProfissional.lookup(0, v, 1);
            }
            this.setColValue("cat_prof_d", nRow, cat_prof_d);
        }
        if (colname.equals("cat_prof_d")) {
            String cat_prof = "";
            if (v.length() > 0) {
                cat_prof = CTabelas.CatProfissional.lookup(1, v, 0);
            }
            this.setColValue("cat_prof", nRow, cat_prof);
        }
        if (colname.equals("nivel")) {
            String nivel_d = "";
            if (v.length() > 0) {
                nivel_d = CTabelas.NiveisQual.lookup(0, v, 1);
            }
            this.setColValue("nivel_d", nRow, nivel_d);
        }
        if (colname.equals("nivel_d")) {
            String nivel = "";
            if (v.length() > 0) {
                nivel = CTabelas.NiveisQual.lookup(1, v, 0);
            }
            this.setColValue("nivel", nRow, nivel);
        }
        if (colname.equals("coprom_d")) {
            String coprom = "";
            if (v.length() > 0) {
                coprom = CTabelas.Empresas.lookup(1, v, 0);
            }
            this.setColValue("coprom", nRow, coprom);
        }
        if (colname.equals("coprom")) {
            String coprom_d = "";
            if (v.length() > 0) {
                coprom_d = CTabelas.Empresas.lookup(0, v, 1);
            }
            this.setColValue("coprom_d", nRow, coprom_d);
        }
        if ((colname.equals("coprom_d") || colname.equals("classe_pessoal_d") || colname.equals("venc_mes") || colname.equals("taxa_segs") || colname.startsWith("n_meses_") || colname.startsWith("taxa_imput_")) && !CBData.reading_xml && !CBData.clear_pg) {
            this.calc_custo_tecnico(nRow);
            CBData.QInv_CP.custos_pessoal_xml();
            CBData.QInv.calc_dados_projecto();
        }
    }

    double getSumEntidade(String colName, String ent) {
        double v = 0.0;
        int n = this.getColIndex(colName);
        int ent_col = this.getColIndex("coprom");
        int nRows = this.dados.size();
        int i = 0;
        while (i < nRows) {
            String e;
            String s = ((String[])this.dados.elementAt(i))[n];
            if (s.length() > 0 && (e = ((String[])this.dados.elementAt(i))[ent_col]).length() != 0 && e.equals(ent)) {
                v = _lib.round(v + Double.parseDouble(s));
            }
            ++i;
        }
        return v;
    }

    void calc_custo_tecnico(int nRow) {
        double taxa_segs = 0.0;
        if (!this.getColValue("taxa_segs", nRow).equals("")) {
            taxa_segs = Double.parseDouble(this.getColValue("taxa_segs", nRow));
        }
        double venc_mes = 0.0;
        if (!this.getColValue("venc_mes", nRow).equals("")) {
            venc_mes = Double.parseDouble(this.getColValue("venc_mes", nRow));
        }
        double SB_tss = venc_mes * (1.0 + taxa_segs / 100.0) * 14.0 / 12.0;
        double n_meses_0 = 0.0;
        if (!this.getColValue("n_meses_0", nRow).equals("")) {
            n_meses_0 = Double.parseDouble(this.getColValue("n_meses_0", nRow));
        }
        double n_meses_1 = 0.0;
        if (!this.getColValue("n_meses_1", nRow).equals("")) {
            n_meses_1 = Double.parseDouble(this.getColValue("n_meses_1", nRow));
        }
        double n_meses_2 = 0.0;
        if (!this.getColValue("n_meses_2", nRow).equals("")) {
            n_meses_2 = Double.parseDouble(this.getColValue("n_meses_2", nRow));
        }
        double n_meses_3 = 0.0;
        if (!this.getColValue("n_meses_3", nRow).equals("")) {
            n_meses_3 = Double.parseDouble(this.getColValue("n_meses_3", nRow));
        }
        double taxa_imput_0 = 0.0;
        if (!this.getColValue("taxa_imput_0", nRow).equals("")) {
            taxa_imput_0 = Double.parseDouble(this.getColValue("taxa_imput_0", nRow));
        }
        double taxa_imput_1 = 0.0;
        if (!this.getColValue("taxa_imput_1", nRow).equals("")) {
            taxa_imput_1 = Double.parseDouble(this.getColValue("taxa_imput_1", nRow));
        }
        double taxa_imput_2 = 0.0;
        if (!this.getColValue("taxa_imput_2", nRow).equals("")) {
            taxa_imput_2 = Double.parseDouble(this.getColValue("taxa_imput_2", nRow));
        }
        double taxa_imput_3 = 0.0;
        if (!this.getColValue("taxa_imput_3", nRow).equals("")) {
            taxa_imput_3 = Double.parseDouble(this.getColValue("taxa_imput_3", nRow));
        }
        double custo_0 = _lib.round(SB_tss * n_meses_0 * (taxa_imput_0 / 100.0));
        double custo_1 = _lib.round(SB_tss * n_meses_1 * (taxa_imput_1 / 100.0));
        double custo_2 = _lib.round(SB_tss * n_meses_2 * (taxa_imput_2 / 100.0));
        double custo_3 = _lib.round(SB_tss * n_meses_3 * (taxa_imput_3 / 100.0));
        double custo_total = _lib.round(custo_0 + custo_1 + custo_2 + custo_3);
        this.setColValue("custo_0", nRow, _lib.to_string(custo_0));
        this.setColValue("custo_1", nRow, _lib.to_string(custo_1));
        this.setColValue("custo_2", nRow, _lib.to_string(custo_2));
        this.setColValue("custo_3", nRow, _lib.to_string(custo_3));
        this.setColValue("custo_total", nRow, _lib.to_string(custo_total));
        ((Frame_Tecnicos)fmeApp.Paginas.getPage("Tecnicos")).getJTextField_Total().setText(_lib.to_format(this.getSum("custo_total")));
    }

    void calc_custo_pessoal() {
        int i = 0;
        while (i < this.dados.size()) {
            this.calc_custo_tecnico(i);
            ++i;
        }
        CBData.QInv.calc_dados_projecto();
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("classe_pessoal")) {
            s = String.valueOf(s) + _lib.xml_encode("classe_pessoal_d", this.getColValue("classe_pessoal_d", row));
        }
        if (tag.equals("cat_prof")) {
            s = String.valueOf(s) + _lib.xml_encode("cat_prof_d", this.getColValue("cat_prof_d", row));
        }
        if (tag.equals("nivel")) {
            s = String.valueOf(s) + _lib.xml_encode("nivel_d", this.getColValue("nivel_d", row));
        }
        if (tag.equals("coprom")) {
            s = String.valueOf(s) + _lib.xml_encode("coprom_d", this.getColValue("coprom_d", row));
        }
        return s;
    }

    public void on_external_update(String tag) {
        int ano;
        if (!this.started) {
            return;
        }
        if (tag.equals("ano_cand") && (ano = (int)CBData.Params.getByName("ano_cand").valueAsDouble()) > 0) {
            this.anos[3] = Integer.toString(ano + 3);
            this.anos[2] = Integer.toString(ano + 2);
            this.anos[1] = Integer.toString(ano + 1);
            this.anos[0] = Integer.toString(ano);
        }
        this.cols[this.getColIndex((String)"n_meses_0")].col_name = "N\u00ba Meses de dura\u00e7\u00e3o do projeto - " + this.anos[0];
        this.cols[this.getColIndex((String)"n_meses_1")].col_name = "N\u00ba Meses de dura\u00e7\u00e3o do projeto - " + this.anos[1];
        this.cols[this.getColIndex((String)"n_meses_2")].col_name = "N\u00ba Meses de dura\u00e7\u00e3o do projeto - " + this.anos[2];
        this.cols[this.getColIndex((String)"n_meses_3")].col_name = "N\u00ba Meses de dura\u00e7\u00e3o do projeto - " + this.anos[3];
        this.cols[this.getColIndex((String)"taxa_imput_0")].col_name = "Taxa de Imputa\u00e7\u00e3o - " + this.anos[0];
        this.cols[this.getColIndex((String)"taxa_imput_1")].col_name = "Taxa de Imputa\u00e7\u00e3o - " + this.anos[1];
        this.cols[this.getColIndex((String)"taxa_imput_2")].col_name = "Taxa de Imputa\u00e7\u00e3o - " + this.anos[2];
        this.cols[this.getColIndex((String)"taxa_imput_3")].col_name = "Taxa de Imputa\u00e7\u00e3o - " + this.anos[3];
        this.cols[this.getColIndex((String)"custo_0")].col_name = "Custo Total - " + this.anos[0];
        this.cols[this.getColIndex((String)"custo_1")].col_name = "Custo Total - " + this.anos[1];
        this.cols[this.getColIndex((String)"custo_2")].col_name = "Custo Total - " + this.anos[2];
        this.cols[this.getColIndex((String)"custo_3")].col_name = "Custo Total - " + this.anos[3];
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.PAG.getJTable_Tecnicos());
        this.ui.add_col(0, 0, 1, 2, "N\u00ba");
        this.ui.add_col(1, 0, 1, 2, "NIF");
        this.ui.add_col(2, 0, 1, 2, "Nome");
        this.ui.add_col(3, 0, 1, 2, "<html><center>Entidade<br>Benefici\u00e1ria</center></html>");
        this.ui.add_col(4, 0, 1, 2, "<html><center>Categoria Profissional</center></html>");
        this.ui.add_col(5, 0, 1, 2, "<html><center>Fun\u00e7\u00e3o no projeto</center></html>");
        this.ui.add_col(6, 0, 1, 2, "<html><center>N\u00edvel de<br>Qualifica\u00e7\u00e3o</center></html>");
        this.ui.add_col(7, 0, 1, 2, "<html><center>Classifica\u00e7\u00e3o de<br>Pessoal</center></html>");
        this.ui.add_col(8, 0, 1, 2, "<html><center>Sal\u00e1rio Base<br>Mensal<br>(sem Subs\u00eddio<br>de Refei\u00e7\u00e3o)</center></html>");
        this.ui.add_col(9, 0, 1, 2, "<html><center>Taxa de<br>Encargos<br>Sociais</center></html>");
        this.ui.add_col(10, 0, 4, 1, "<html><center>N\u00ba Meses de dura\u00e7\u00e3o do projeto (1)</center></html>");
        this.ui.add_col(10, 1, 1, 1, "<html><center>" + this.anos[0] + "</center></html>");
        this.ui.add_col(11, 1, 1, 1, "<html><center>" + this.anos[1] + "</center></html>");
        this.ui.add_col(12, 1, 1, 1, "<html><center>" + this.anos[2] + "</center></html>");
        this.ui.add_col(13, 1, 1, 1, "<html><center>" + this.anos[3] + "</center></html>");
        this.ui.add_col(14, 0, 4, 1, "<html><center>Taxa de Imputa\u00e7\u00e3o</center></html>");
        this.ui.add_col(14, 1, 1, 1, "<html><center>" + this.anos[0] + "</center></html>");
        this.ui.add_col(15, 1, 1, 1, "<html><center>" + this.anos[1] + "</center></html>");
        this.ui.add_col(16, 1, 1, 1, "<html><center>" + this.anos[2] + "</center></html>");
        this.ui.add_col(17, 1, 1, 1, "<html><center>" + this.anos[3] + "</center></html>");
        this.ui.add_col(18, 0, 1, 2, "<html><center>N\u00ba Horas<br>semanais</center></html>");
        this.ui.add_col(19, 0, 5, 1, "<html><center>Custo Total</center></html>");
        this.ui.add_col(19, 1, 1, 1, "<html><center>" + this.anos[0] + "</center></html>");
        this.ui.add_col(20, 1, 1, 1, "<html><center>" + this.anos[1] + "</center></html>");
        this.ui.add_col(21, 1, 1, 1, "<html><center>" + this.anos[2] + "</center></html>");
        this.ui.add_col(22, 1, 1, 1, "<html><center>" + this.anos[3] + "</center></html>");
        this.ui.add_col(23, 1, 1, 1, "<html><center>Total</center></html>");
        this.PAG.getJTable_Tecnicos().getTableHeader().setUI(this.ui);
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        return this.validar(err_list, "");
    }

    CHValid_Grp validar(CHValid_Grp err_list, String nt) {
        String dt_act_f;
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Pessoal t\u00e9cnico do(s) benefici\u00e1rio(s) a afetar ao projeto" + nt);
        }
        if (!this.started) {
            return err_list;
        }
        String dt_inicio = CBData.DadosProjecto.getByName((String)"dt_inicio").v;
        String dt_fim = CBData.DadosProjecto.getByName((String)"dt_fim").v;
        StringBuffer mask = new StringBuffer("--R-R-RR-R-RRR--------R-----");
        int ano_i = Integer.parseInt(CBData.Params.getByName((String)"ano_cand").v) - 1;
        int ano_f = Integer.parseInt(CBData.Params.getByName((String)"ano_cand").v) - 1;
        String dt_act_i = CBData.DadosProjecto.getByName((String)"dt_inicio").v;
        if (dt_act_i.length() == 10) {
            ano_i = _lib.to_int(dt_act_i.substring(0, 4));
        }
        if ((dt_act_f = CBData.DadosProjecto.getByName((String)"dt_fim").v).length() == 10) {
            ano_f = _lib.to_int(dt_act_f.substring(0, 4));
        }
        int aux = -1;
        int i = 0;
        while (i < this.cols.length) {
            if (this.cols[i].col_tag.startsWith("n_meses_")) {
                if (_lib.to_int(this.anos[++aux]) >= ano_i && _lib.to_int(this.anos[aux]) <= ano_f) {
                    mask.setCharAt(i, 'R');
                } else {
                    mask.setCharAt(i, 'N');
                }
            }
            ++i;
        }
        aux = -1;
        i = 0;
        while (i < this.cols.length) {
            if (this.cols[i].col_tag.startsWith("taxa_imput_")) {
                if (_lib.to_int(this.anos[++aux]) >= ano_i && _lib.to_int(this.anos[aux]) <= ano_f) {
                    mask.setCharAt(i, 'R');
                } else {
                    mask.setCharAt(i, 'N');
                }
            }
            ++i;
        }
        int j = 0;
        while (j < this.dados.size()) {
            if (!this.isRowEmpty(j)) {
                TabError[] e = this.isIncompletAll(j, mask.toString());
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o", "Linha %L: %T - Neste Caso N\u00e3o Preenche")));
                    ++ii;
                }
            }
            ++j;
        }
        if (!this.isUnique("nif")) {
            err_list.add_msg(new CHValid_Msg("unique", "N\u00e3o podem existir NIFs repetidos"));
        }
        return err_list;
    }
}

