/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_DadosAccao;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;

class CBTabela_AccaoFormandos
extends CBTabela {
    Frame_DadosAccao PAG;
    int index = 0;

    public String getPagina() {
        return "DadosAccao";
    }

    CBTabela_AccaoFormandos(Frame_DadosAccao p, int idx) {
        this.index = idx;
        this.PAG = p;
        this.initialize();
    }

    void initialize() {
        this.PAG.CBData_AccaoFormandos = this;
        this.tag = "AccaoFormandos";
        this.started = true;
        this.cols = new CHTabColModel[6];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, null);
        this.cols[1] = new CHTabColModel("categoria", "Categoria (id)", true, true, false, null);
        this.cols[2] = new CHTabColModel("categoria_d", "Categoria", false, true, true, null);
        this.cols[3] = new CHTabColModel("n_formandos", "N\u00ba<br>Formandos", true, true, true, CFLib.VLD_NUM);
        this.cols[4] = new CHTabColModel("regiao", "Regi\u00e3o (id)", true, true, false, null);
        this.cols[5] = new CHTabColModel("regiao_d", "Regi\u00e3o", false, true, true, null);
        this.init_dados(6);
        this.init_handler(this.PAG.getJTable_Formandos());
        this.PAG.getJTable_Formandos().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_Formandos().getWidth() - 20;
        this.handler.set_col_text(0, 0.13, "C");
        this.handler.set_col_comboS(2, 0.38, null, CTabelas.TipoFormando, 1, 0);
        this.handler.set_col_text(3, 0.2, "C");
        this.handler.set_col_comboS(5, 0.29, null, CTabelas.NUTS_II_Continente, 1, 0);
    }

    void on_update(String colname, int nRow, String v) {
        this.numerar(0);
        if (colname.equals("categoria_d")) {
            String categoria = "";
            if (v.length() > 0) {
                categoria = CTabelas.TipoFormando.lookup(1, v, 0);
            }
            this.setColValue("categoria", nRow, categoria);
        }
        if (colname.equals("categoria")) {
            String categoria_d = "";
            if (v.length() > 0) {
                categoria_d = CTabelas.TipoFormando.lookup(0, v, 1);
            }
            this.setColValue("categoria_d", nRow, categoria_d);
        }
        if (colname.equals("regiao_d")) {
            String regiao = "";
            if (v.length() > 0) {
                regiao = CTabelas.NUTS_II_Continente.lookup(1, v, 0);
            }
            this.setColValue("regiao", nRow, regiao);
        }
        if (colname.equals("regiao")) {
            String regiao_d = "";
            if (v.length() > 0) {
                regiao_d = CTabelas.NUTS_II_Continente.lookup(0, v, 1);
            }
            this.setColValue("regiao_d", nRow, regiao_d);
        }
        if (colname.equals("n_formandos")) {
            this.calc_n_formandos();
        }
    }

    void calc_n_formandos() {
        int n_formandos = 0;
        int i = 0;
        while (i < this.dados.size()) {
            n_formandos += _lib.to_int(this.getColValue("n_formandos", i));
            ++i;
        }
        CBData.ListaAccoes.setColValue("n_formandos", this.index - 1, n_formandos > 0 ? String.valueOf(n_formandos) : "");
        CBData.ListaAccoes.on_update("n_formandos", this.index - 1, n_formandos > 0 ? String.valueOf(n_formandos) : "");
        CBData.ListaAccoes.handler.j.repaint();
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("categoria")) {
            s = String.valueOf(s) + _lib.xml_encode("categoria_d", this.getColValue("categoria_d", row));
        }
        if (tag.equals("regiao")) {
            s = String.valueOf(s) + _lib.xml_encode("regiao_d", this.getColValue("regiao_d", row));
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        return this.validar(err_list, "");
    }

    CHValid_Grp validar(CHValid_Grp err_list, String nt) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Formandos" + nt);
        }
        if (!this.started) {
            return err_list;
        }
        int j = 0;
        while (j < this.dados.size()) {
            String mask = "--RR-R";
            if (!this.isRowEmpty(j)) {
                TabError[] e = this.isIncompletAll(j, mask.toString());
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                    ++ii;
                }
            }
            ++j;
        }
        return err_list;
    }
}

