/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHTabQuadro;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_Financ;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_Finan
extends CBTabela {
    String p3 = "";
    String p2 = "";
    String rubrica = "";
    int tab_index = 0;
    Frame_Financ P13 = null;

    public String getPagina() {
        return "Financ";
    }

    CBTabela_Finan() {
        this.P13 = (Frame_Financ)fmeApp.Paginas.getPage("Financ");
        if (this.P13 == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_Finan(Frame_Financ p, int idx) {
        this.P13 = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "Financ";
        this.started = true;
        this.cols = new CHTabColModel[9];
        this.cols[0] = new CHTabColModel("rubrica", "Rubricas", true, false, false, null);
        this.cols[1] = new CHTabColModel("rubrica_d", "Rubricas", false, false, true, null);
        this.cols[2] = new CHTabColModel("val_p1", "Ano -1", true, true, false, CFLib.VLD_VALOR_S);
        this.cols[3] = new CHTabColModel("val_0", "Ano 0", true, true, true, CFLib.VLD_VALOR_S);
        this.cols[4] = new CHTabColModel("val_1", "Ano 1", true, true, true, CFLib.VLD_VALOR_S);
        this.cols[5] = new CHTabColModel("val_2", "Ano 2", true, true, true, CFLib.VLD_VALOR_S);
        this.cols[6] = new CHTabColModel("val_3", "Ano 3", true, true, true, CFLib.VLD_VALOR_S);
        this.cols[7] = new CHTabColModel("total", "Total", false, false, true, CFLib.VLD_VALOR_S);
        this.cols[8] = new CHTabColModel("perc", "%", true, false, false, CFLib.VLD_VALOR_S);
        this.init_dados(12);
        this.init_handler(new CHTabQuadro(), this.P13.getJTable_Financ());
        this.P13.getJTable_Financ().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P13.getJScrollPane_Financ().getWidth() - 1;
        this.cols[0].disable_row_calc = true;
        this.cols[1].disable_row_calc = true;
        this.cols[8].disable_row_calc = true;
        ((CHTabQuadro)this.handler).start_rows();
        ((CHTabQuadro)this.handler).row_editable[1] = false;
        ((CHTabQuadro)this.handler).row_editable[2] = false;
        ((CHTabQuadro)this.handler).row_editable[9] = false;
        ((CHTabQuadro)this.handler).row_editable[10] = false;
        ((CHTabQuadro)this.handler).row_editable[11] = false;
        this.keyCol = 0;
        ((String[])this.dados.elementAt((int)0))[0] = "06";
        ((String[])this.dados.elementAt((int)1))[0] = "07";
        ((String[])this.dados.elementAt((int)2))[0] = "0701";
        ((String[])this.dados.elementAt((int)3))[0] = "070101";
        ((String[])this.dados.elementAt((int)4))[0] = "070102";
        ((String[])this.dados.elementAt((int)5))[0] = "070199";
        ((String[])this.dados.elementAt((int)6))[0] = "0703";
        ((String[])this.dados.elementAt((int)7))[0] = "0706";
        ((String[])this.dados.elementAt((int)8))[0] = "0799";
        ((String[])this.dados.elementAt((int)9))[0] = "90";
        ((String[])this.dados.elementAt((int)10))[0] = "91";
        ((String[])this.dados.elementAt((int)11))[0] = "92";
        ((String[])this.dados.elementAt((int)0))[1] = "Comparticipa\u00e7\u00e3o FEDER/FSE";
        ((String[])this.dados.elementAt((int)1))[1] = "Comparticipa\u00e7\u00e3o Nacional";
        ((String[])this.dados.elementAt((int)2))[1] = "    OE";
        ((String[])this.dados.elementAt((int)3))[1] = "        Cap\u00edtulo 50\u00ba";
        ((String[])this.dados.elementAt((int)4))[1] = "        Cap\u00edtulo 3";
        ((String[])this.dados.elementAt((int)5))[1] = "        Outras Fontes OE";
        ((String[])this.dados.elementAt((int)6))[1] = "    AL (Autarquia Local)";
        ((String[])this.dados.elementAt((int)7))[1] = "    OR (Or\u00e7amento Regional)";
        ((String[])this.dados.elementAt((int)8))[1] = "    Outras Fontes";
        ((String[])this.dados.elementAt((int)9))[1] = "FINANCIAMENTO TOTAL";
        ((String[])this.dados.elementAt((int)10))[1] = "INVESTIMENTO TOTAL";
        ((String[])this.dados.elementAt((int)11))[1] = "INVESTIMENTO ELEG\u00cdVEL TOTAL";
        this.handler.set_col_text(1, 0.3, null);
        this.handler.set_col_text(3, 0.14, "R");
        this.handler.set_col_text(4, 0.14, "R");
        this.handler.set_col_text(5, 0.14, "R");
        this.handler.set_col_text(6, 0.14, "R");
        this.handler.set_col_text(7, 0.14, "R");
        ((CHTabQuadro)this.handler).row_autocalc[1] = "$soma(+3,+4,+5,+6,+7,+8)";
        ((CHTabQuadro)this.handler).row_autocalc[2] = "$soma(+3,+4,+5)";
        ((CHTabQuadro)this.handler).row_autocalc[9] = "$soma(+0,+3,+4,+5,+6,+7,+8)";
        CBData.Params.bind_ano_cand_update(this);
    }

    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        if (tag.equals("ano_cand")) {
            int ano = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
            this.cols[2].col_name = Integer.toString(ano - 1);
            this.cols[3].col_name = Integer.toString(ano);
            this.cols[4].col_name = Integer.toString(ano + 1);
            this.cols[5].col_name = Integer.toString(ano + 2);
            this.cols[6].col_name = Integer.toString(ano + 3);
            this.handler.repaint_col_names();
        }
    }

    public void Clear() {
        int i = 0;
        while (i < this.dados.size() - 2) {
            this.clearRow(i);
            ++i;
        }
        this.idx_xml = -1;
        this.handler.j.repaint();
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.startsWith("val_")) {
            double total = 0.0;
            double v_1 = _lib.to_double(((String[])this.dados.elementAt(nRow))[2]);
            double v0 = _lib.to_double(((String[])this.dados.elementAt(nRow))[3]);
            double v1 = _lib.to_double(((String[])this.dados.elementAt(nRow))[4]);
            double v2 = _lib.to_double(((String[])this.dados.elementAt(nRow))[5]);
            double v3 = _lib.to_double(((String[])this.dados.elementAt(nRow))[6]);
            total = _lib.round(v_1 + v0 + v1 + v2 + v3);
            ((String[])this.dados.elementAt((int)nRow))[this.getColIndex((String)"total")] = Double.toString(total);
            this.autocalc();
            this.handler.j.repaint();
            double financiamento = _lib.to_double(((String[])this.dados.elementAt(9))[2]) + _lib.to_double(((String[])this.dados.elementAt(9))[3]) + _lib.to_double(((String[])this.dados.elementAt(9))[4]) + _lib.to_double(((String[])this.dados.elementAt(9))[5]) + _lib.to_double(((String[])this.dados.elementAt(9))[6]);
            ((String[])this.dados.elementAt((int)9))[this.getColIndex((String)"total")] = Double.toString(financiamento);
            int i = 0;
            while (i < this.dados.size() - 2) {
                double perc = 0.0;
                total = 0.0;
                v_1 = _lib.to_double(((String[])this.dados.elementAt(i))[2]);
                v0 = _lib.to_double(((String[])this.dados.elementAt(i))[3]);
                v1 = _lib.to_double(((String[])this.dados.elementAt(i))[4]);
                v2 = _lib.to_double(((String[])this.dados.elementAt(i))[5]);
                v3 = _lib.to_double(((String[])this.dados.elementAt(i))[6]);
                total = _lib.round(v_1 + v0 + v1 + v2 + v3);
                if (_lib.round(financiamento) > 0.0) {
                    perc = _lib.round(total / financiamento * 100.0);
                    ((String[])this.dados.elementAt((int)i))[this.getColIndex((String)"perc")] = Double.toString(perc);
                } else {
                    ((String[])this.dados.elementAt((int)i))[this.getColIndex((String)"perc")] = "";
                }
                ++i;
            }
        }
        this.autocalc();
        this.handler.j.repaint();
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("rubrica")) {
            s = String.valueOf(s) + _lib.xml_encode("rubrica_d", ((String[])this.dados.elementAt(row))[1]);
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        String titulo = "Estrutura de Financiamento (Recursos Financeiros)";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        double fin_total = _lib.round(_lib.to_double(this.getColValue("total", 9)));
        double inv_total = _lib.round(_lib.to_double(this.getColValue("total", 10)));
        if (fin_total == 0.0) {
            err_list.add_msg(new CHValid_Msg("finan", "%o"));
        }
        if (inv_total != fin_total) {
            err_list.add_msg(new CHValid_Msg("finan", "O Financiamento Total \u00e9 diferente do Investimento Total"));
        }
        int j = 2;
        while (j <= 6) {
            double fin;
            double inv;
            if (this.cols[j].visible && (inv = _lib.round(_lib.to_double(((String[])this.dados.elementAt(10))[j]))) != (fin = _lib.round(_lib.to_double(((String[])this.dados.elementAt(9))[j])))) {
                err_list.add_msg(new CHValid_Msg("finan", "Financiamento diferente do Investimento Total (" + this.cols[j].col_name + ")"));
            }
            ++j;
        }
        return err_list;
    }
}

