/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CBTabela_PromLocal;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Tecnicos;
import fme.GroupableTableHeaderUI;
import fme.SteppedComboBox;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;
import javax.swing.JOptionPane;

class CBTabela_Tecnicos
extends CBTabela {
    Frame_Tecnicos PAG;
    public SteppedComboBox cboEntidades = null;
    public SteppedComboBox cboEstabs = null;

    public String getPagina() {
        return "Tecnicos";
    }

    CBTabela_Tecnicos() {
        this.tag = "Tecnicos";
        this.PAG = (Frame_Tecnicos)fmeApp.Paginas.getPage("Tecnicos");
        if (this.PAG == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_Tecnicos(Frame_Tecnicos p) {
        this.tag = "Tecnicos";
        this.PAG = p;
        this.initialize();
    }

    void initialize() {
        this.PAG.CBData_Tecnicos = this;
        this.force_xml = true;
        this.started = true;
        this.cols = new CHTabColModel[27];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, null);
        this.cols[1] = new CHTabColModel("nif", "NIF", true, true, true, CFLib.VLD_NIF);
        this.cols[2] = new CHTabColModel("nome", "Nome", true, true, true, null);
        this.cols[3] = new CHTabColModel("cat_prof", null, true, false, false, null);
        this.cols[4] = new CHTabColModel("cat_prof_d", "Categoria<br>Profissional", false, true, true, null);
        this.cols[5] = new CHTabColModel("grau_acad", null, true, false, false, null);
        this.cols[6] = new CHTabColModel("grau_acad_d", "N\u00edvel de<br>Qualifica\u00e7\u00e3o", false, true, true, null);
        this.cols[7] = new CHTabColModel("coprom", "Entidade<br>Benefici\u00e1ria (id)", true, true, false, null);
        this.cols[8] = new CHTabColModel("coprom_d", "Entidade<br>Benefici\u00e1ria", false, true, true, null);
        this.cols[9] = new CHTabColModel("estab", "Estab.", true, true, true, null);
        this.cols[10] = new CHTabColModel("conteudo", "Conte\u00fado Funcional da Participa\u00e7\u00e3o", true, true, true, null);
        this.cols[11] = new CHTabColModel("taxa_segs", "Taxa de<br>Encargos<br>Sociais", true, true, true, CFLib.VLD_PERC);
        this.cols[12] = new CHTabColModel("htrab_sem", "Horas de<br>Trabalho<br>Semanais", true, true, true, CFLib.VLD_VALOR);
        this.cols[13] = new CHTabColModel("venc_mes", "Remunera\u00e7\u00e3o<br>Bruta<br>Mensal", true, true, true, CFLib.VLD_VALOR);
        this.cols[14] = new CHTabColModel("venc_mes_tss", "Remunera\u00e7\u00e3o<br>Mensal", true, false, true, CFLib.VLD_VALOR);
        this.cols[15] = new CHTabColModel("custo_hora", "Custo/hora", true, false, true, CFLib.VLD_VALOR);
        this.cols[16] = new CHTabColModel("n_horas_p1", "N\u00ba Horas<br>ano -1", true, true, false, CFLib.VLD_VALOR_0);
        this.cols[17] = new CHTabColModel("n_horas_0", "N\u00ba Horas<br>ano 0", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[18] = new CHTabColModel("n_horas_1", "N\u00ba Horas<br>ano 1", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[19] = new CHTabColModel("n_horas_2", "N\u00ba Horas<br>ano 2", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[20] = new CHTabColModel("n_horas_3", "N\u00ba Horas<br>ano 3", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[21] = new CHTabColModel("custo_p1", "Custo total<br>ano -1", true, false, false, CFLib.VLD_VALOR);
        this.cols[22] = new CHTabColModel("custo_0", "Custo total<br>ano 0", true, false, true, CFLib.VLD_VALOR);
        this.cols[23] = new CHTabColModel("custo_1", "Custo total<br>ano 1", true, false, true, CFLib.VLD_VALOR);
        this.cols[24] = new CHTabColModel("custo_2", "Custo total<br>ano 2", true, false, true, CFLib.VLD_VALOR);
        this.cols[25] = new CHTabColModel("custo_3", "Custo total<br>ano 3", true, false, true, CFLib.VLD_VALOR);
        this.cols[26] = new CHTabColModel("custo_total", "Custo total", true, false, true, CFLib.VLD_VALOR);
        this.init_dados(1);
        this.init_handler(this.PAG.getJTable_Tecnicos());
        this.PAG.getJTable_Tecnicos().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_Tecnicos().getWidth() - 20;
        this.on_external_update("");
        this.handler.set_col_text(0, 0.05, "C");
        this.handler.set_col_text(1, 0.1, null);
        this.handler.set_col_text(2, 0.3, null);
        this.handler.set_col_comboS(4, 0.2, null, CTabelas.CatProfissional, 1, 0);
        this.handler.set_col_comboS(6, 0.1, null, CTabelas.NiveisQual, 1, 0);
        this.cboEntidades = this.handler.set_col_comboS(8, 0.2, null, CTabelas.Empresas, 1, 280);
        this.cboEstabs = this.handler.set_col_comboFD(9, 0.075, "C", CTabelas.EstabsF1, 1, 200);
        this.handler.set_col_text(10, 0.25, null);
        this.handler.set_col_text(11, 0.09, "R");
        this.handler.set_col_text(12, 0.09, "R");
        this.handler.set_col_text(13, 0.12, "R");
        this.handler.set_col_text(14, 0.12, "R");
        this.handler.set_col_text(15, 0.12, "R");
        this.handler.set_col_text(17, 0.08, "R");
        this.handler.set_col_text(18, 0.08, "R");
        this.handler.set_col_text(19, 0.08, "R");
        this.handler.set_col_text(20, 0.08, "R");
        this.handler.set_col_text(22, 0.13, "R");
        this.handler.set_col_text(23, 0.13, "R");
        this.handler.set_col_text(24, 0.13, "R");
        this.handler.set_col_text(25, 0.13, "R");
        this.handler.set_col_text(26, 0.13, "R");
        CBData.Params.bind_ano_cand_update(this);
    }

    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        String[] anos = new String[]{"Ano -1", "Ano 0", "Ano 1", "Ano 2", "Ano 3"};
        if (tag.equals("ano_cand")) {
            int ano = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
            if (ano > 0) {
                anos[4] = Integer.toString(ano + 3);
                anos[3] = Integer.toString(ano + 2);
                anos[2] = Integer.toString(ano + 1);
                anos[1] = Integer.toString(ano + 0);
                anos[0] = Integer.toString(ano - 1);
            }
            this.cols[this.getColIndex((String)"n_horas_p1")].col_name = "N\u00ba Horas - " + anos[0];
            this.cols[this.getColIndex((String)"n_horas_0")].col_name = "N\u00ba Horas - " + anos[1];
            this.cols[this.getColIndex((String)"n_horas_1")].col_name = "N\u00ba Horas - " + anos[2];
            this.cols[this.getColIndex((String)"n_horas_2")].col_name = "N\u00ba Horas - " + anos[3];
            this.cols[this.getColIndex((String)"n_horas_3")].col_name = "N\u00ba Horas - " + anos[4];
            this.cols[this.getColIndex((String)"custo_p1")].col_name = "Custo Total - " + anos[0];
            this.cols[this.getColIndex((String)"custo_0")].col_name = "Custo Total - " + anos[1];
            this.cols[this.getColIndex((String)"custo_1")].col_name = "Custo Total - " + anos[2];
            this.cols[this.getColIndex((String)"custo_2")].col_name = "Custo Total - " + anos[3];
            this.cols[this.getColIndex((String)"custo_3")].col_name = "Custo Total - " + anos[4];
        }
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.PAG.getJTable_Tecnicos());
        this.ui.add_col(0, 0, 1, 2, "N\u00ba");
        this.ui.add_col(1, 0, 1, 2, "NIF");
        this.ui.add_col(2, 0, 1, 2, "Nome");
        this.ui.add_col(3, 0, 1, 2, "<html><center>Categoria<br>Profissional</center></html>");
        this.ui.add_col(4, 0, 1, 2, "<html><center>N\u00edvel de<br>Qualifica\u00e7\u00e3o</center></html>");
        this.ui.add_col(5, 0, 1, 2, "<html><center>Entidade<br>Benefici\u00e1ria</center></html>");
        this.ui.add_col(6, 0, 1, 2, "<html><center>Estab.</center></html>");
        this.ui.add_col(7, 0, 1, 2, "<html><center>Conte\u00fado Funcional<br>da Participa\u00e7\u00e3o</center></html>");
        this.ui.add_col(8, 0, 1, 2, "<html><center>Taxa de<br>Encargos<br>Sociais</center></html>");
        this.ui.add_col(9, 0, 1, 2, "<html><center>Horas de<br>Trabalho<br>Semanais</center></html>");
        this.ui.add_col(10, 0, 1, 2, "<html><center>Remunera\u00e7\u00e3o<br>Bruta<br>Mensal</center></html>");
        this.ui.add_col(11, 0, 1, 2, "<html><center>Remunera\u00e7\u00e3o<br>Mensal</center></html>");
        this.ui.add_col(12, 0, 1, 2, "<html><center>Custo/hora</center></html>");
        this.ui.add_col(13, 0, 4, 1, "N\u00ba Horas");
        this.ui.add_col(13, 1, 1, 1, anos[1]);
        this.ui.add_col(14, 1, 1, 1, anos[2]);
        this.ui.add_col(15, 1, 1, 1, anos[3]);
        this.ui.add_col(16, 1, 1, 1, anos[4]);
        this.ui.add_col(17, 0, 5, 1, "Custo Total");
        this.ui.add_col(17, 1, 1, 1, anos[1]);
        this.ui.add_col(18, 1, 1, 1, anos[2]);
        this.ui.add_col(19, 1, 1, 1, anos[3]);
        this.ui.add_col(20, 1, 1, 1, anos[4]);
        this.ui.add_col(21, 1, 1, 1, "Total");
        this.PAG.getJTable_Tecnicos().getTableHeader().setUI(this.ui);
    }

    boolean on_del_row(boolean cascade) {
        this.handler.__garbage_stop_editing();
        int n = this.handler.j.getSelectedRow();
        int m = this.handler.j.getRowCount();
        if (n < m && n != -1) {
            Object[] options = new Object[]{"   Sim   ", "   N\u00e3o   "};
            int q = JOptionPane.showOptionDialog(null, "<html>A linha selecionada " + (cascade ? "<strong><u>e toda a informa\u00e7\u00e3o associada</u></strong> " : "") + "ser\u00e1 eliminada. Pretende continuar?</html>", "Apagar Linha", 0, 3, null, options, options[1]);
            if (q == 0) {
                this.del_row_at(n);
                this.handler.j.revalidate();
                this.handler.j.repaint();
                return true;
            }
        } else {
            JOptionPane.showMessageDialog(null, "N\u00e3o selecionou nenhuma linha na tabela!", "Apagar Linha", 1, null);
        }
        return false;
    }

    boolean on_add_row() {
        this.add_row();
        this.handler.j.revalidate();
        this.handler.j.repaint();
        return true;
    }

    boolean on_ins_row(boolean remove_empty) {
        this.handler.__garbage_stop_editing();
        int n = this.handler.j.getSelectedRow();
        if (n >= 0) {
            this.ins_row_at(n, remove_empty);
            this.handler.j.revalidate();
            this.handler.j.repaint();
            return true;
        }
        return false;
    }

    public void xmlBegin(String path) {
        ++this.idx_xml;
        if (this.idx_xml >= this.dados.size()) {
            this.add_row();
        }
    }

    boolean del_ins_ok(String option) {
        this.handler.__garbage_stop_editing();
        int n = this.handler.j.getSelectedRow();
        int m = this.handler.j.getRowCount();
        boolean emp_ok = false;
        String msg = "";
        String n_ordem = this.getColValue("n_ordem", n);
        return true;
    }

    void numerar(int nCol) {
        int n = 0;
        int i = 0;
        while (i < this.dados.size()) {
            ((String[])this.dados.elementAt((int)i))[nCol] = Integer.toString(++n);
            ++i;
        }
    }

    void calc_total() {
        ((Frame_Tecnicos)fmeApp.Paginas.getPage("Tecnicos")).getJTextField_Total().setText(_lib.to_format(this.getSum("custo_total")));
    }

    void _filter_populate_estabs(SteppedComboBox cboEstabs, int row) {
        String coprom = this.getColValue("coprom", row);
        String estab = this.getColValue("estab", row);
        if (coprom.length() == 0) {
            cboEstabs.removeAllItems();
            cboEstabs.addItem("");
        } else {
            int n;
            CTabelas.EstabsF1.set_filter(3, coprom);
            CTabelas.EstabsF1._populateComboBox(cboEstabs, 0);
            if (estab.length() > 0 && (n = CTabelas.EstabsF1.getIndexFromCode(estab)) >= 0) {
                cboEstabs.setSelectedIndex(n + 1);
            }
        }
    }

    void on_update(String colname, int nRow, String v) {
        this.numerar(0);
        if (colname.equals("cat_prof")) {
            String cat_prof_d = "";
            if (v.length() > 0) {
                cat_prof_d = CTabelas.CatProfissional.lookup(0, v, 1);
            }
            this.setColValue("cat_prof_d", nRow, cat_prof_d);
        }
        if (colname.equals("cat_prof_d")) {
            String cat_prof = "";
            if (v.length() > 0) {
                cat_prof = CTabelas.CatProfissional.lookup(1, v, 0);
            }
            this.setColValue("cat_prof", nRow, cat_prof);
        }
        if (colname.equals("grau_acad")) {
            String grau_acad_d = "";
            if (v.length() > 0) {
                grau_acad_d = CTabelas.NiveisQual.lookup(0, v, 1);
            }
            this.setColValue("grau_acad_d", nRow, grau_acad_d);
        }
        if (colname.equals("grau_acad_d")) {
            String grau_acad = "";
            if (v.length() > 0) {
                grau_acad = CTabelas.NiveisQual.lookup(1, v, 0);
            }
            this.setColValue("grau_acad", nRow, grau_acad);
        }
        if ((colname.equals("nif") || colname.equals("nome")) && colname.equals("nome")) {
            CTabelas.RecursoInt.refresh();
        }
        if ((colname.equals("taxa_segs") || colname.equals("htrab_sem") || colname.equals("venc_mes") || colname.startsWith("n_horas_")) && !CBData.reading_xml) {
            this.calc_custo_tecnico(nRow);
        }
        if (colname.equals("estab")) {
            boolean existe = false;
            if (CBData.reading_xml && v.length() > 0) {
                String emp = this.getColValue("coprom", nRow);
                if (!emp.equals("1")) {
                    CBTabela_PromLocal pl = (CBTabela_PromLocal)CBData.ListaCoProm.Lista_PromLocal.elementAt(_lib.to_int(emp) - 2);
                    existe = pl.existe_estab(v);
                } else {
                    existe = CBData.PromLocal.existe_estab(v);
                }
                if (!existe) {
                    this.on_update("estab", nRow, "");
                    this.setColValue("estab", nRow, "");
                    return;
                }
            }
        }
        if (colname.equals("coprom")) {
            String coprom_d = "";
            if (v.length() > 0) {
                coprom_d = CTabelas.Empresas.lookup(0, v, 1);
            }
            this.setColValue("coprom_d", nRow, coprom_d);
        }
        if (colname.equals("coprom_d")) {
            String coprom = "";
            String coprom_old = "";
            if (this.getColValue("coprom", nRow).length() > 0) {
                coprom_old = this.getColValue("coprom", nRow);
            }
            if (v.length() == 0) {
                this.setColValue("estab", nRow, "");
            } else {
                coprom = CTabelas.Empresas.lookup(1, v, 0);
                if (!coprom_old.equals(coprom)) {
                    this.setColValue("estab", nRow, "");
                }
            }
            this.setColValue("coprom", nRow, coprom);
        }
    }

    void calc_custo_pessoal() {
        int i = 0;
        while (i < this.dados.size()) {
            this.calc_custo_tecnico(i);
            ++i;
        }
    }

    void calc_custo_tecnico(int nRow) {
        double venc_mes = 0.0;
        if (!this.getColValue("venc_mes", nRow).equals("")) {
            venc_mes = Double.parseDouble(this.getColValue("venc_mes", nRow));
        }
        double taxa_segs = 0.0;
        if (!this.getColValue("taxa_segs", nRow).equals("")) {
            taxa_segs = Double.parseDouble(this.getColValue("taxa_segs", nRow));
        }
        double htrab_sem = 0.0;
        if (!this.getColValue("htrab_sem", nRow).equals("")) {
            htrab_sem = Double.parseDouble(this.getColValue("htrab_sem", nRow));
        }
        double venc_mes_tss = _lib.round(venc_mes * (1.0 + taxa_segs / 100.0));
        this.setColValue("venc_mes_tss", nRow, _lib.to_string(venc_mes_tss));
        double custo_hora = 0.0;
        if (htrab_sem > 0.0) {
            custo_hora = _lib.round(venc_mes_tss * 14.0 / (48.0 * htrab_sem));
        }
        this.setColValue("custo_hora", nRow, _lib.to_string(custo_hora));
        String n_ordem = this.getColValue("n_ordem", nRow);
        double ano_p1 = _lib.to_double(this.getColValue("n_horas_p1", nRow));
        double ano_0 = _lib.to_double(this.getColValue("n_horas_0", nRow));
        double ano_1 = _lib.to_double(this.getColValue("n_horas_1", nRow));
        double ano_2 = _lib.to_double(this.getColValue("n_horas_2", nRow));
        double ano_3 = _lib.to_double(this.getColValue("n_horas_3", nRow));
        double n_horas_tt = ano_p1 + ano_0 + ano_1 + ano_2 + ano_3;
        this.setColValue("custo_p1", nRow, _lib.to_string(ano_p1 * custo_hora));
        this.setColValue("custo_0", nRow, _lib.to_string(ano_0 * custo_hora));
        this.setColValue("custo_1", nRow, _lib.to_string(ano_1 * custo_hora));
        this.setColValue("custo_2", nRow, _lib.to_string(ano_2 * custo_hora));
        this.setColValue("custo_3", nRow, _lib.to_string(ano_3 * custo_hora));
        this.setColValue("custo_total", nRow, _lib.to_string(n_horas_tt * custo_hora));
        this.calc_total();
        CBData.QInv.calc_dados_projecto();
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("cat_prof")) {
            s = String.valueOf(s) + _lib.xml_encode("cat_prof_d", this.getColValue("cat_prof_d", row));
        }
        if (tag.equals("grau_acad")) {
            s = String.valueOf(s) + _lib.xml_encode("grau_acad_d", this.getColValue("grau_acad_d", row));
        }
        if (tag.equals("coprom")) {
            s = String.valueOf(s) + _lib.xml_encode("coprom_d", this.getColValue("coprom_d", row));
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        return this.validar(err_list, "");
    }

    CHValid_Grp validar(CHValid_Grp err_list, String nt) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Pessoal t\u00e9cnico do(s) benefici\u00e1rio(s) a afetar \u00e0 opera\u00e7\u00e3o" + nt);
        }
        if (!this.started) {
            return err_list;
        }
        int j = 0;
        while (j < this.dados.size()) {
            String mask = "--R-R-R-RRR-RR---RRRR------";
            if (!this.isRowEmpty(j)) {
                TabError[] e = this.isIncompletAll(j, mask.toString());
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                    ++ii;
                }
            }
            ++j;
        }
        if (!this.isUnique("nif")) {
            err_list.add_msg(new CHValid_Msg("unique", "N\u00e3o podem existir NIFs repetidos"));
        }
        return err_list;
    }
}

