/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_Formandos;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_Formandos
extends CBTabela {
    Frame_Formandos P = (Frame_Formandos)fmeApp.Paginas.getPage("Formandos");
    int limite = 9000;

    public String getPagina() {
        return "Formandos";
    }

    CBTabela_Formandos() {
        if (this.P == null) {
            return;
        }
        this.initialize();
    }

    void initialize() {
        this.tag = "Formandos";
        this.cols = new CHTabColModel[6];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, null);
        this.cols[1] = new CHTabColModel("design", "Designa\u00e7\u00e3o", true, true, true, null);
        this.cols[2] = new CHTabColModel("rbm", "RBM", true, true, true, CFLib.VLD_VALOR);
        this.cols[3] = new CHTabColModel("n_prest", "N\u00ba<br>Presta\u00e7\u00f5es<br>Anuais", true, true, true, CFLib.VLD_NUM);
        this.cols[4] = new CHTabColModel("n_horas", "N\u00ba<br>Horas", true, true, true, CFLib.VLD_VALOR);
        this.cols[5] = new CHTabColModel("custo_hora", "Custo/hora", true, false, true, CFLib.VLD_VALOR);
        this.init_dados(6);
        this.init_handler(this.P.getJTable_Formandos());
        this.P.getJTable_Formandos().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P.getJScrollPane_Formandos().getWidth();
        this.handler.set_col_text(0, 0.065, "C");
        this.handler.set_col_text(1, 0.47, null);
        this.handler.set_col_text(2, 0.12, "R");
        this.handler.set_col_text(3, 0.11, "R");
        this.handler.set_col_text(4, 0.09, "R");
        this.handler.set_col_text(5, 0.12, "R");
        this.started = true;
    }

    void on_update(String colname, int nRow, String v) {
        this.numerar(0);
        if (colname.matches("rbm|n_prest|n_horas")) {
            double rbm = _lib.to_double(this.getColValue("rbm", nRow));
            double n_prest = _lib.to_double(this.getColValue("n_prest", nRow));
            double n_horas = _lib.to_double(this.getColValue("n_horas", nRow));
            double custo_hora = 0.0;
            if (n_horas > 0.0) {
                custo_hora = _lib.round(rbm * n_prest / (48.0 * n_horas));
            }
            this.setColValue("custo_hora", nRow, custo_hora > 0.0 ? String.valueOf(custo_hora) : "");
        }
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("nivel")) {
            s = String.valueOf(s) + _lib.xml_encode("nivel_d", this.getColValue("nivel_d", row));
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        String titulo = "Lista de Perfis de Formandos";
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (!this.started) {
            return err_list;
        }
        int i = 0;
        while (i < this.dados.size()) {
            StringBuffer mask = new StringBuffer("-RRRRR");
            TabError[] e = this.isIncompletAll(i, mask.toString());
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                ++ii;
            }
            ++i;
        }
        return err_list;
    }
}

