/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_IdProm_3;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_PTrabalho
extends CBTabela {
    Frame_IdProm_3 P12;
    int tab_index = 0;
    int n_anos = 1;

    public String getPagina() {
        return "PTrabalho";
    }

    CBTabela_PTrabalho() {
        this.P12 = (Frame_IdProm_3)fmeApp.Paginas.getPage("IdProm_3");
        if (this.P12 == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_PTrabalho(Frame_IdProm_3 p, int idx) {
        this.P12 = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "PTrabalho";
        this.started = true;
        this.P12.cbd_ptrabalho = this;
        this.cols = new CHTabColModel[10];
        this.cols[0] = new CHTabColModel("area", "\u00c1rea Funcional (id)", true, true, false, null);
        this.cols[1] = new CHTabColModel("area_d", "\u00c1rea Funcional", false, true, true, null);
        this.cols[2] = new CHTabColModel("nivel", "N\u00edvel (id)", true, true, false, null);
        this.cols[3] = new CHTabColModel("nivel_d", "N\u00edvel de<br>Qualifica\u00e7\u00e3o", false, true, true, null);
        this.cols[4] = new CHTabColModel("val_m_pre", "Ano<br>Pr\u00e9-Proj. Mulheres", true, true, true, CFLib.VLD_NUM_0);
        this.cols[5] = new CHTabColModel("val_h_pre", "Ano<br>Pr\u00e9-Proj. Homens", true, true, true, CFLib.VLD_NUM_0);
        this.cols[6] = new CHTabColModel("val_tt_pre", "Ano<br>Pr\u00e9-Proj. Total", true, false, true, CFLib.VLD_NUM_0);
        this.cols[7] = new CHTabColModel("val_m_pos", "Ano<br>P\u00f3s-Proj. Mulheres", true, true, true, CFLib.VLD_NUM_0);
        this.cols[8] = new CHTabColModel("val_h_pos", "Ano<br>P\u00f3s-Proj. Homens", true, true, true, CFLib.VLD_NUM_0);
        this.cols[9] = new CHTabColModel("val_tt_pos", "Ano<br>P\u00f3s-Proj. Total", true, false, true, CFLib.VLD_NUM_0);
        this.init_dados(13);
        this.init_handler(this.P12.getJTable_PTrabalho());
        this.P12.getJTable_PTrabalho().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P12.getJScrollPane_PTrabalho().getWidth();
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.P12.getJTable_PTrabalho());
        this.ui.add_col(0, 0, 1, 2, "\u00c1rea Funcional");
        this.ui.add_col(1, 0, 1, 2, "<html><div align='center'>N\u00edvel de<br>Qualifica\u00e7\u00e3o</div></html>");
        this.ui.add_col(2, 0, 3, 1, "Ano Pr\u00e9-Proj.");
        this.ui.add_col(2, 1, 1, 1, "Mulheres");
        this.ui.add_col(3, 1, 1, 1, "Homens");
        this.ui.add_col(4, 1, 1, 1, "Total");
        this.ui.add_col(5, 0, 3, 1, "Ano P\u00f3s-Proj.");
        this.ui.add_col(5, 1, 1, 1, "Mulheres");
        this.ui.add_col(6, 1, 1, 1, "Homens");
        this.ui.add_col(7, 1, 1, 1, "Total");
        this.P12.getJTable_PTrabalho().getTableHeader().setUI(this.ui);
        this.handler.set_col_comboS(1, 0.33, null, CTabelas.AreasFunc, 1, 250);
        this.handler.set_col_comboS(3, 0.11, null, CTabelas.NiveisQual, 1, 80);
        this.handler.set_col_text(4, 0.09, "R");
        this.handler.set_col_text(5, 0.09, "R");
        this.handler.set_col_text(6, 0.09, "R");
        this.handler.set_col_text(7, 0.09, "R");
        this.handler.set_col_text(8, 0.09, "R");
        this.handler.set_col_text(9, 0.09, "R");
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("area_d")) {
            String area = "";
            if (v.length() > 0) {
                area = CTabelas.AreasFunc.lookup(1, v, 0);
            }
            this.setColValue("area", nRow, area);
        }
        if (colname.equals("area")) {
            String area_d = "";
            if (v.length() > 0) {
                area_d = CTabelas.AreasFunc.lookup(0, v, 1);
            }
            this.setColValue("area_d", nRow, area_d);
        }
        if (colname.equals("nivel_d")) {
            String nivel = "";
            if (v.length() > 0) {
                nivel = CTabelas.NiveisQual.lookup(1, v, 0);
            }
            this.setColValue("nivel", nRow, nivel);
        }
        if (colname.equals("nivel")) {
            String nivel_d = "";
            if (v.length() > 0) {
                nivel_d = CTabelas.NiveisQual.lookup(0, v, 1);
            }
            this.setColValue("nivel_d", nRow, nivel_d);
        }
        if (colname.startsWith("val_m_") || colname.startsWith("val_h_")) {
            int h;
            String suffix = colname.substring(colname.lastIndexOf("_") + 1);
            int m = _lib.to_int(this.getColValue("val_m_" + suffix, nRow));
            int tt = m + (h = _lib.to_int(this.getColValue("val_h_" + suffix, nRow)));
            if (tt == 0) {
                this.setColValue("val_tt_" + suffix, nRow, "");
            } else {
                this.setColValue("val_tt_" + suffix, nRow, String.valueOf(tt));
            }
        }
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("area")) {
            s = String.valueOf(s) + _lib.xml_encode("area_d", this.getColValue("area_d", row));
        }
        if (tag.equals("nivel")) {
            s = String.valueOf(s) + _lib.xml_encode("nivel_d", this.getColValue("nivel_d", row));
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        int idx_i;
        int ano_cand;
        String titulo = "Postos de Trabalho do Benefici\u00e1rio";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (!this.started) {
            return err_list;
        }
        if (this.isEmpty() && this.tab_index == 0 && !CBData.Promotor.getByName((String)"nat_jur").v.equals("10")) {
            err_list.add_msg(new CHValid_Msg("ptrabalho", "Lista vazia"));
        }
        int ano_inicial = ano_cand = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
        String v = CBData.Promotor.getByName((String)"dt_inicio_act").v;
        if (v.length() == 10) {
            ano_inicial = Integer.parseInt(v.substring(0, 4));
        }
        if ((idx_i = 4 - (ano_cand - ano_inicial - 1) * 3) < 0) {
            idx_i = 0;
        }
        int j = 0;
        while (j < this.dados.size()) {
            String mask = "-R-R------";
            TabError[] e = this.isIncompletAll(j, mask.toString());
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                ++ii;
            }
            if (!this.isRowEmpty(j)) {
                int i = 4;
                while (i <= 9) {
                    String ano_s = this.cols[i].col_name;
                    String tag = this.cols[i].col_tag;
                    if (i != 6 && i != 9) {
                        String s = ((String[])this.dados.elementAt(j))[i];
                        if (i < 6 && i >= idx_i && s.length() == 0 || i > 6 && s.length() == 0) {
                            String _msg = "Linha " + (j + 1) + " incompleta: " + ano_s + " - %o";
                            _msg = _msg.replaceAll("\n", " ");
                            _msg = _msg.replaceAll("<br>", " ");
                            _msg = _msg.replaceAll("<html>", "");
                            _msg = _msg.replaceAll("</html>", "");
                            _msg = _msg.replaceAll("<div align='center'>", "");
                            _msg = _msg.replaceAll("</div>", "");
                            err_list.add_msg(new CHValid_Msg("ptrabalho", _msg));
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
        return err_list;
    }
}

