/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_VendasExt;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_VendasExt
extends CBTabela {
    Frame_VendasExt P12;
    int tab_index = 0;

    public String getPagina() {
        return "VendasExt";
    }

    CBTabela_VendasExt() {
        this.tag = "VendasExt";
        this.P12 = (Frame_VendasExt)fmeApp.Paginas.getPage("VendasExt");
        if (this.P12 == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_VendasExt(Frame_VendasExt p, int idx) {
        this.tag = "VendasExt";
        this.tab_index = idx;
        this.P12 = p;
        this.initialize();
    }

    void initialize() {
        this.P12.cbd_vendas_ext = this;
        this.started = true;
        this.cols = new CHTabColModel[8];
        this.cols[0] = new CHTabColModel("nif", "NIF", true, true, true, CFLib.VLD_NIF);
        this.cols[1] = new CHTabColModel("design", "Designa\u00e7\u00e3o do Cliente Exportador", true, true, true, null);
        this.cols[2] = new CHTabColModel("vendas_pre", "Vendas do Benefici\u00e1rio ao Cliente (Ano Pr\u00e9-Proj.)", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[3] = new CHTabColModel("vol_neg_int_pre", "Volume de Neg\u00f3cios do Cliente Internacional (Ano Pr\u00e9-Proj.)", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[4] = new CHTabColModel("vol_neg_tt_pre", "Volume de Neg\u00f3cios do Cliente Total (Ano Pr\u00e9-Proj.)", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[5] = new CHTabColModel("vendas_pos", "Vendas do Benefici\u00e1rio ao Cliente (Ano P\u00f3s-Proj.)", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[6] = new CHTabColModel("vol_neg_int_pos", "Volume de Neg\u00f3cios do Cliente Internacional (Ano P\u00f3s-Proj.)", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[7] = new CHTabColModel("vol_neg_tt_pos", "Volume de Neg\u00f3cios do Cliente Total (Ano P\u00f3s-Proj.)", true, true, true, CFLib.VLD_VALOR_0);
        this.init_dados(12);
        this.init_handler(this.P12.getJTable_VendasExt());
        this.P12.getJTable_VendasExt().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P12.getJScrollPane_VendasExt().getWidth();
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(3, this.P12.getJTable_VendasExt());
        this.ui.add_col(0, 0, 1, 3, "NIF");
        this.ui.add_col(1, 0, 1, 3, "Designa\u00e7\u00e3o do Cliente Exportador");
        this.ui.add_col(2, 0, 3, 1, "Ano Pr\u00e9-Proj.");
        this.ui.add_col(2, 1, 1, 2, "<html><div align='center'>Vendas do<br>Benefici\u00e1rio<br>ao Cliente</div></html>");
        this.ui.add_col(3, 1, 2, 1, "<html><div align='center'>Volume de Neg\u00f3cios do Cliente</div></html>");
        this.ui.add_col(3, 2, 1, 1, "Internacional");
        this.ui.add_col(4, 2, 1, 1, "Total");
        this.ui.add_col(5, 0, 3, 1, "Ano P\u00f3s-Proj.");
        this.ui.add_col(5, 1, 1, 2, "<html><div align='center'>Vendas do<br>Benefici\u00e1rio<br>ao Cliente</div></html>");
        this.ui.add_col(6, 1, 2, 1, "<html><div align='center'>Volume de Neg\u00f3cios do Cliente</div></html>");
        this.ui.add_col(6, 2, 1, 1, "Internacional");
        this.ui.add_col(7, 2, 1, 1, "Total");
        this.P12.getJTable_VendasExt().getTableHeader().setUI(this.ui);
        this.handler.set_col_text(0, 0.08, "C");
        this.handler.set_col_text(1, 0.295, null);
        this.handler.set_col_text(2, 0.1, "R");
        this.handler.set_col_text(3, 0.1, "R");
        this.handler.set_col_text(4, 0.1, "R");
        this.handler.set_col_text(5, 0.1, "R");
        this.handler.set_col_text(6, 0.1, "R");
        this.handler.set_col_text(7, 0.1, "R");
    }

    void on_update(String colname, int nRow, String v) {
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        int idx_i;
        int ano_cand;
        String titulo = "Vendas ao Exterior Indiretas";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (!this.started) {
            return err_list;
        }
        int ano_inicial = ano_cand = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
        String v = CBData.Promotor.getByName((String)"dt_inicio_act").v;
        if (v.length() == 10) {
            ano_inicial = Integer.parseInt(v.substring(0, 4));
        }
        if ((idx_i = 2 - (ano_cand - ano_inicial - 1) * 3) < 0) {
            idx_i = 0;
        }
        String nif_promotor = CBData.Promotor.getByName((String)"nif").v;
        int j = 0;
        while (j < this.dados.size()) {
            String mask = "RR------";
            TabError[] e = this.isIncompletAll(j, mask.toString());
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                ++ii;
            }
            if (!this.isRowEmpty(j)) {
                int i = 2;
                while (i <= 7) {
                    String s_aux;
                    String ano_s = this.cols[i].col_name;
                    String s = ((String[])this.dados.elementAt(j))[i];
                    String _msg = ano_s;
                    _msg = _msg.replaceAll("\n", " ");
                    _msg = _msg.replaceAll("<br>", " ");
                    _msg = _msg.replaceAll("<html>", "");
                    _msg = _msg.replaceAll("</html>", "");
                    _msg = _msg.replaceAll("<div align='center'>", "");
                    _msg = _msg.replaceAll("</div>", "");
                    if (s.length() == 0 && i >= idx_i && i <= 4 || s.length() == 0 && i > 4) {
                        _msg = "Linha " + (j + 1) + " incompleta: " + _msg + " - %o";
                        err_list.add_msg(new CHValid_Msg("vendas_ext", _msg));
                    } else if (!(i != 4 && i != 7 || (s_aux = ((String[])this.dados.elementAt(j))[i - 1]).equals(""))) {
                        double vn_tt = _lib.to_double(s);
                        double vn_int = _lib.to_double(s_aux);
                        if (vn_int > vn_tt) {
                            String _msg_aux = this.cols[i - 1].col_name;
                            _msg_aux = _msg_aux.replaceAll("\n", " ");
                            _msg_aux = _msg_aux.replaceAll("<br>", " ");
                            _msg_aux = _msg_aux.replaceAll("<html>", "");
                            _msg_aux = _msg_aux.replaceAll("</html>", "");
                            _msg_aux = _msg_aux.replaceAll("<div align='center'>", "");
                            _msg_aux = _msg_aux.replaceAll("</div>", "");
                            _msg = "Linha " + (j + 1) + ": " + _msg + " n\u00e3o pode ser inferior ao " + _msg_aux;
                            err_list.add_msg(new CHValid_Msg("vendas_ext", _msg));
                        }
                    }
                    ++i;
                }
            }
            if (!nif_promotor.equals("") && nif_promotor.equals(this.getColValue("nif", j))) {
                err_list.add_msg(new CHValid_Msg("vendas_ext", "Linha " + (j + 1) + ": NIF do pr\u00f3prio Promotor"));
            }
            ++j;
        }
        if (!this.isUnique("nif")) {
            err_list.add_msg(new CHValid_Msg("unique", "N\u00e3o podem existir NIF's repetidos"));
        }
        return err_list;
    }
}

