/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBTabela;
import fme.CHTabela;
import fme.CMsgInfo;
import fme.fmeComum;
import fme.fmeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class JTable_Tip
extends JTable {
    public static final int EXCEL_FILE = 1;
    public static final int EXCEL_CLIP = 2;
    public static final int EXCEL_HELP = 4;
    public static final int EXCEL_CLIP2 = 8;
    public static final int EXCEL_CLIPS = 10;
    public static final int EXCEL_ALL = 15;
    private static final ImageIcon x_icon = new ImageIcon(fmeFrame.class.getResource("table_excel.png"));
    private static final ImageIcon c_icon = new ImageIcon(fmeFrame.class.getResource("copy.png"));
    private static final ImageIcon p_icon = new ImageIcon(fmeFrame.class.getResource("paste.png"));
    private static final ImageIcon p2_icon = new ImageIcon(fmeFrame.class.getResource("paste2.png"));
    private static final ImageIcon h_icon = new ImageIcon(fmeFrame.class.getResource("help.png"));
    private static final ImageIcon w_icon = new ImageIcon(fmeFrame.class.getResource("wait.gif"));

    public JTable_Tip() {
        int w = this.getTableHeader().getPreferredSize().width;
        this.getTableHeader().setPreferredSize(new Dimension(w, 25));
        this.getTableHeader().setFont(fmeComum.letra);
        this.setRowHeight(18);
        this.setBorder(fmeComum.tableBodyBorderCompound);
        this.setFont(fmeComum.letra);
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
    }

    public JTable_Tip(int altura) {
        int w = this.getTableHeader().getPreferredSize().width;
        this.getTableHeader().setPreferredSize(new Dimension(w, altura));
        this.getTableHeader().setFont(fmeComum.letra);
        this.setRowHeight(18);
        this.setBorder(fmeComum.tableBodyBorderCompound);
        this.setFont(fmeComum.letra);
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
    }

    public JTable_Tip(int altura, int largura) {
        this.getTableHeader().setPreferredSize(new Dimension(5000, altura));
        this.getTableHeader().setFont(fmeComum.letra);
        this.setRowHeight(18);
        this.setBorder(fmeComum.tableBodyBorderCompound);
        this.setFont(fmeComum.letra);
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        Color cinza = new Color(247, 247, 247);
        Color branco = new Color(255, 255, 255);
        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.setToolTipText(this.getValueAt(rowIndex, vColIndex).toString());
            if (rowIndex == this.getEditingRow() && vColIndex == this.getEditingColumn()) {
                jc.setBackground(branco);
            } else if (this.isCellSelected(rowIndex, vColIndex)) {
                jc.setBackground(fmeComum.rosa_cinza);
            } else if (this.isCellEditable(rowIndex, vColIndex)) {
                jc.setBackground(branco);
            } else {
                jc.setBackground(cinza);
            }
            jc.setForeground(Color.BLACK);
        }
        return c;
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.isEditing() && (rowIndex != this.getEditingRow() || columnIndex != this.getEditingColumn())) {
            return;
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        if (this.editCellAt(rowIndex, columnIndex)) {
            this.getEditorComponent().requestFocusInWindow();
        }
        if (this.isCellEditable(rowIndex, columnIndex)) {
            return;
        }
        this.editCellAt(rowIndex, columnIndex);
    }

    public void addExcelButton(JPanel jp, int left, int top) {
        this.addExcelButton(jp, left, top, 15);
    }

    public void addExcelButton(JPanel jp, int left, int top, int sel) {
        if ((sel & 0xB) == 0) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                if ((sel & 0xA) != 0) {
                    sm.checkSystemClipboardAccess();
                }
                if ((sel & 1) != 0) {
                    sm.checkWrite("<<ALL FILES>>");
                }
            }
            catch (Exception e) {
                return;
            }
        }
        ExcelButton jb = new ExcelButton(sel);
        jb.setBounds(left, top, 30, 22);
        jb.setDisabledIcon(w_icon);
        jb.setIcon(x_icon);
        jp.add(jb);
    }

    class ExcelButton
    extends JButton {
        JPopupMenu popup;
        JMenuItem export;
        JMenuItem copiar;
        JMenuItem colar;
        JMenuItem colar2;
        JMenuItem ajuda;

        ExcelButton() {
            this(15);
        }

        ExcelButton(int sel) {
            ExcelButton face = this;
            if (sel == 1) {
                this.setToolTipText("Exportar para Excel");
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CBTabela cbt = ExcelButton.this.getCBTabela();
                    }
                });
            } else {
                this.popup = new JPopupMenu();
                this.setToolTipText("Clique para ver a lista de op\u00e7\u00f5es");
                this.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        ExcelButton.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                });
                if ((sel & 1) != 0) {
                    this.export = new JMenuItem("Exportar para Excel");
                    this.export.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            CBTabela cbt = ExcelButton.this.getCBTabela();
                        }
                    });
                    this.export.setFont(fmeComum.letra);
                    this.popup.add(this.export);
                }
                if ((sel & 2) != 0) {
                    this.copiar = new JMenuItem("Copiar o Quadro completo para o Clipboard", c_icon);
                    this.copiar.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            CBTabela cbt = ExcelButton.this.getCBTabela();
                            if (cbt != null) {
                                cbt.on_copy_data();
                            }
                        }
                    });
                    this.copiar.setFont(fmeComum.letra);
                    this.popup.add(this.copiar);
                    this.colar = new JMenuItem("Colar o Quadro completo do Clipboard", p_icon);
                    this.colar.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            CBTabela cbt = ExcelButton.this.getCBTabela();
                            if (cbt != null) {
                                cbt.on_paste_data();
                            }
                        }
                    });
                    this.colar.setFont(fmeComum.letra);
                    this.popup.add(this.colar);
                }
                if ((sel & 8) != 0) {
                    this.colar2 = new JMenuItem("Colar parte do Quadro do Clipboard", p2_icon);
                    this.colar2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            CBTabela cbt = ExcelButton.this.getCBTabela();
                            if (cbt != null) {
                                cbt.on_paste_data2();
                            }
                        }
                    });
                    this.colar2.setFont(fmeComum.letra);
                    this.popup.add(this.colar2);
                }
                if ((sel & 4) != 0 && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    this.popup.add(new JSeparator());
                    this.ajuda = new JMenuItem("Ajuda", h_icon);
                    this.ajuda.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            CMsgInfo m = new CMsgInfo("ajuda_xls.html");
                            m.setSize(new Dimension(550, 450));
                            m.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - m.getSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - m.getSize().height / 2);
                            m.show();
                        }
                    });
                    this.ajuda.setFont(fmeComum.letra);
                    this.popup.add(this.ajuda);
                }
            }
        }

        private CBTabela getCBTabela() {
            return JTable_Tip.this.getModel() instanceof CHTabela ? ((CHTabela)JTable_Tip.this.getModel()).d : null;
        }
    }
}

