/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_ActRecursos;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;
import javax.swing.JComboBox;

class CBTabela_ActRecursosInt
extends CBTabela {
    Frame_ActRecursos PAG;
    JComboBox tecnicos;
    int tab_index = 0;
    boolean contratuais = CBData.contratuais;
    String[] anos = new String[]{"Ano 0", "Ano 1", "Ano 2", "Ano 3", "Ano 4", "Ano 5"};
    String ano_val = "ano_cand";

    public String getPagina() {
        return "ActRecursos";
    }

    CBTabela_ActRecursosInt() {
        this.PAG = (Frame_ActRecursos)fmeApp.Paginas.getPage("ActRecursos");
        if (this.PAG == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_ActRecursosInt(Frame_ActRecursos p, int idx) {
        this.tab_index = idx;
        this.PAG = p;
        this.initialize();
    }

    void initialize() {
        this.PAG.CBData_ActRecursosInt = this;
        this.tag = "ActRecursosInt";
        this.started = true;
        this.cols = new CHTabColModel[12];
        this.cols[0] = new CHTabColModel("tecnico", null, true, false, false, null);
        this.cols[1] = new CHTabColModel("tecnico_d", "Perfil", true, true, true, null);
        this.cols[2] = new CHTabColModel("coprom", "Copromotor (id)", true, true, false, null);
        this.cols[3] = new CHTabColModel("coprom_d", "Copromotor", false, false, true, null);
        this.cols[4] = new CHTabColModel("design", "Conte\u00fado Funcional da Participa\u00e7\u00e3o", true, true, true, null);
        this.cols[5] = new CHTabColModel("ano_0", "Ano 0", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[6] = new CHTabColModel("ano_1", "Ano 1", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[7] = new CHTabColModel("ano_2", "Ano 2", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[8] = new CHTabColModel("ano_3", "Ano 3", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[9] = new CHTabColModel("ano_4", "Ano 4", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[10] = new CHTabColModel("ano_5", "Ano 5", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[11] = new CHTabColModel("total", "Total", true, false, true, CFLib.VLD_VALOR_0);
        this.init_dados(9);
        this.init_handler(this.PAG.getJTable_ActRecursosInt());
        this.PAG.getJTable_ActRecursosInt().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_ActRecursosInt().getWidth() - 20;
        this.PAG.getJTable_ActRecursosInt().setName(String.valueOf(this.PAG.getJTable_ActRecursosInt().getName()) + "_" + this.tab_index);
        this.on_external_update("");
        this.tecnicos = this.handler.set_col_comboS(1, 0.2, null, CTabelas.RecursoInt, 1, 200);
        this.handler.set_col_text(3, 0.17, null);
        this.handler.set_col_text(4, 0.21000000000000002, null);
        this.handler.set_col_text(5, 0.06, "R");
        this.handler.set_col_text(6, 0.06, "R");
        this.handler.set_col_text(7, 0.06, "R");
        this.handler.set_col_text(8, 0.06, "R");
        this.handler.set_col_text(9, 0.06, "R");
        this.handler.set_col_text(10, 0.06, "R");
        this.handler.set_col_text(11, 0.06, "R");
        CBData.Params.bind_ano_ref_proj_update(this);
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("tecnico_d")) {
            String tecnico = "";
            if (v.length() > 0) {
                tecnico = CTabelas.RecursoInt.lookup(1, v, 0);
            }
            this.setColValue("tecnico", nRow, tecnico);
            String entidade = "";
            if (tecnico.length() > 0) {
                entidade = CBData.Tecnicos.getColValue("coprom", Integer.parseInt(tecnico) - 1);
            }
            this.setColValue("coprom", nRow, entidade);
            this.on_update("coprom", nRow, entidade);
        }
        if (colname.equals("coprom_d")) {
            String coprom = "";
            if (v.length() > 0) {
                coprom = CTabelas.Empresas.lookup(1, v, 0);
            }
            this.setColValue("coprom", nRow, coprom);
        }
        if (colname.equals("coprom")) {
            String coprom_d = "";
            if (v.length() > 0) {
                coprom_d = CTabelas.Empresas.lookup(0, v, 1);
            }
            this.setColValue("coprom_d", nRow, coprom_d);
        }
        if (colname.startsWith("ano_")) {
            double ano_5;
            double ano_4;
            double ano_3;
            double ano_2;
            double ano_1;
            double ano_0 = _lib.to_double(this.getColValue("ano_0", nRow));
            String total = _lib.to_string(ano_0 + (ano_1 = _lib.to_double(this.getColValue("ano_1", nRow))) + (ano_2 = _lib.to_double(this.getColValue("ano_2", nRow))) + (ano_3 = _lib.to_double(this.getColValue("ano_3", nRow))) + (ano_4 = _lib.to_double(this.getColValue("ano_4", nRow))) + (ano_5 = _lib.to_double(this.getColValue("ano_5", nRow))));
            this.setColValue("total", nRow, total.equals("0") ? "" : total);
        }
        if (!CBData.reading_xml && !CBData.is_cleaning) {
            CBData.Tecnicos2.calc_custo_pessoal();
        }
    }

    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        if (tag.startsWith("ano_")) {
            int ano = (int)CBData.Params.getByName(tag).valueAsDouble();
            if (ano > 0) {
                this.anos[5] = Integer.toString(ano + 5);
                this.anos[4] = Integer.toString(ano + 4);
                this.anos[3] = Integer.toString(ano + 3);
                this.anos[2] = Integer.toString(ano + 2);
                this.anos[1] = Integer.toString(ano + 1);
                this.anos[0] = Integer.toString(ano);
            }
            this.cols[this.getColIndex((String)"ano_0")].col_name = "N\u00ba Pessoas-M\u00eas - " + this.anos[0];
            this.cols[this.getColIndex((String)"ano_1")].col_name = "N\u00ba Pessoas-M\u00eas - " + this.anos[1];
            this.cols[this.getColIndex((String)"ano_2")].col_name = "N\u00ba Pessoas-M\u00eas - " + this.anos[2];
            this.cols[this.getColIndex((String)"ano_3")].col_name = "N\u00ba Pessoas-M\u00eas - " + this.anos[3];
            this.cols[this.getColIndex((String)"ano_4")].col_name = "N\u00ba Pessoas-M\u00eas - " + this.anos[4];
            this.cols[this.getColIndex((String)"ano_5")].col_name = "N\u00ba Pessoas-M\u00eas - " + this.anos[5];
            this.ano_val = tag;
        }
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.PAG.getJTable_ActRecursosInt());
        this.ui.add_col(0, 0, 1, 2, "Perfil");
        this.ui.add_col(1, 0, 1, 2, "Copromotor");
        this.ui.add_col(2, 0, 1, 2, "<html><center>Conte\u00fado Funcional da Participa\u00e7\u00e3o</center></html>");
        this.ui.add_col(3, 0, 7, 1, "N\u00ba Pessoas / M\u00eas");
        this.ui.add_col(3, 1, 1, 1, this.anos[0]);
        this.ui.add_col(4, 1, 1, 1, this.anos[1]);
        this.ui.add_col(5, 1, 1, 1, this.anos[2]);
        this.ui.add_col(6, 1, 1, 1, this.anos[3]);
        this.ui.add_col(7, 1, 1, 1, this.anos[4]);
        this.ui.add_col(8, 1, 1, 1, this.anos[5]);
        this.ui.add_col(9, 1, 1, 1, "Total");
        this.PAG.getJTable_ActRecursosInt().getTableHeader().setUI(this.ui);
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        return this.validar(err_list, "");
    }

    CHValid_Grp validar(CHValid_Grp err_list, String nt) {
        int ano_cand;
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Pessoal t\u00e9cnico do benefici\u00e1rio" + nt);
        }
        if (!this.started) {
            return err_list;
        }
        if (this.isEmpty() && this.PAG.CBData_ActRecursosExt.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("actrecursosint", "Lista vazia"));
        }
        int ano_fim = ano_cand = (int)CBData.Params.getByName(this.ano_val).valueAsDouble();
        String vf = CBData.DadosProjecto.getByName((String)"dt_fim").v;
        if (vf.length() == 10) {
            ano_fim = Integer.parseInt(vf.substring(0, 4));
        }
        StringBuffer mask = new StringBuffer("-R--R-------");
        int aux = -1;
        int i = 0;
        while (i < this.cols.length) {
            if (this.cols[i].col_tag.startsWith("ano_") && this.cols[i].visible && _lib.to_int(this.anos[++aux]) <= ano_fim) {
                mask.setCharAt(i, 'R');
            }
            ++i;
        }
        int j = 0;
        while (j < this.dados.size()) {
            TabError[] e = this.isIncompletAll(j, mask.toString());
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                ++ii;
            }
            ++j;
        }
        return err_list;
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("coprom")) {
            s = String.valueOf(s) + _lib.xml_encode("coprom_d", this.getColValue("coprom_d", row));
        }
        return s;
    }
}

