/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto_Promotor;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_PTrabalho;
import fme.GroupableTableHeaderUI;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_PTrabalho
extends CBTabela {
    Frame_PTrabalho P12;
    int tab_index = 0;
    int n_anos = 1;
    String ano_val = "ano_cand";

    public String getPagina() {
        return "PTrabalho";
    }

    CBTabela_PTrabalho() {
        this.P12 = (Frame_PTrabalho)fmeApp.Paginas.getPage("PTrabalho");
        if (this.P12 == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_PTrabalho(Frame_PTrabalho p, int idx) {
        this.P12 = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "PTrabalho";
        this.started = true;
        this.P12.cbd_ptrabalho = this;
        this.cols = new CHTabColModel[10];
        this.cols[0] = new CHTabColModel("area", "\u00c1rea Funcional (id)", true, true, false, null);
        this.cols[1] = new CHTabColModel("area_d", "\u00c1rea Funcional", false, true, true, null);
        this.cols[2] = new CHTabColModel("nivel", "N\u00edvel (id)", true, true, false, null);
        this.cols[3] = new CHTabColModel("nivel_d", "N\u00edvel de<br>Qualifica\u00e7\u00e3o", false, true, true, null);
        this.cols[4] = new CHTabColModel("val_m_pre", "Ano<br>Pr\u00e9-Proj. Mulheres", true, true, true, CFLib.VLD_NUM_0);
        this.cols[5] = new CHTabColModel("val_h_pre", "Ano<br>Pr\u00e9-Proj. Homens", true, true, true, CFLib.VLD_NUM_0);
        this.cols[6] = new CHTabColModel("val_tt_pre", "Ano<br>Pr\u00e9-Proj. Total", true, false, true, CFLib.VLD_NUM_0);
        this.cols[7] = new CHTabColModel("val_m_pos", "Ano<br>Fim Proj.+" + this.n_anos + " Mulheres", true, true, true, CFLib.VLD_NUM_0);
        this.cols[8] = new CHTabColModel("val_h_pos", "Ano<br>Fim Proj.+" + this.n_anos + " Homens", true, true, true, CFLib.VLD_NUM_0);
        this.cols[9] = new CHTabColModel("val_tt_pos", "Ano<br>Fim Proj.+" + this.n_anos + " Total", true, false, true, CFLib.VLD_NUM_0);
        this.init_dados(13);
        this.init_handler(this.P12.getJTable_PTrabalho());
        this.P12.getJTable_PTrabalho().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P12.getJScrollPane_PTrabalho().getWidth();
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.P12.getJTable_PTrabalho());
        this.ui.add_col(0, 0, 1, 2, "\u00c1rea Funcional");
        this.ui.add_col(1, 0, 1, 2, "<html><div align='center'>N\u00edvel de<br>Qualifica\u00e7\u00e3o</div></html>");
        this.ui.add_col(2, 0, 3, 1, "Ano Pr\u00e9-Proj.");
        this.ui.add_col(2, 1, 1, 1, "Mulheres");
        this.ui.add_col(3, 1, 1, 1, "Homens");
        this.ui.add_col(4, 1, 1, 1, "Total");
        this.ui.add_col(5, 0, 3, 1, "Ano Fim Proj.+" + this.n_anos);
        this.ui.add_col(5, 1, 1, 1, "Mulheres");
        this.ui.add_col(6, 1, 1, 1, "Homens");
        this.ui.add_col(7, 1, 1, 1, "Total");
        this.P12.getJTable_PTrabalho().getTableHeader().setUI(this.ui);
        this.handler.set_col_comboS(1, 0.33, null, CTabelas.AreasFunc, 1, 250);
        this.handler.set_col_comboS(3, 0.11, null, CTabelas.NiveisQual, 1, 80);
        this.handler.set_col_text(4, 0.09, "R");
        this.handler.set_col_text(5, 0.09, "R");
        this.handler.set_col_text(6, 0.09, "R");
        this.handler.set_col_text(7, 0.09, "R");
        this.handler.set_col_text(8, 0.09, "R");
        this.handler.set_col_text(9, 0.09, "R");
    }

    void bind_updates() {
        CBData.Params.bind_ano_cand_update(this);
        CBData.DadosProjecto.bind_dt_fim_update(this);
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("area_d")) {
            String area = "";
            if (v.length() > 0) {
                area = CTabelas.AreasFunc.lookup(1, v, 0);
            }
            this.setColValue("area", nRow, area);
        }
        if (colname.equals("area")) {
            String area_d = "";
            if (v.length() > 0) {
                area_d = CTabelas.AreasFunc.lookup(0, v, 1);
            }
            this.setColValue("area_d", nRow, area_d);
        }
        if (colname.equals("nivel_d")) {
            String nivel = "";
            if (v.length() > 0) {
                nivel = CTabelas.NiveisQual2.lookup(1, v, 0);
            }
            this.setColValue("nivel", nRow, nivel);
        }
        if (colname.equals("nivel")) {
            String nivel_d = "";
            if (v.length() > 0) {
                nivel_d = CTabelas.NiveisQual2.lookup(0, v, 1);
            }
            this.setColValue("nivel_d", nRow, nivel_d);
        }
        if (colname.startsWith("val_m_") || colname.startsWith("val_h_")) {
            int h;
            String suffix = colname.substring(colname.lastIndexOf("_") + 1);
            int m = _lib.to_int(this.getColValue("val_m_" + suffix, nRow));
            int tt = m + (h = _lib.to_int(this.getColValue("val_h_" + suffix, nRow)));
            if (tt == 0) {
                this.setColValue("val_tt_" + suffix, nRow, "");
            } else {
                this.setColValue("val_tt_" + suffix, nRow, String.valueOf(tt));
            }
        }
    }

    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.P12.getJTable_PTrabalho());
        this.ui.add_col(0, 0, 1, 2, "\u00c1rea Funcional");
        this.ui.add_col(1, 0, 1, 2, "<html><div align='center'>N\u00edvel de<br>Qualifica\u00e7\u00e3o</div></html>");
        this.ui.add_col(2, 1, 1, 1, "Mulheres");
        this.ui.add_col(3, 1, 1, 1, "Homens");
        this.ui.add_col(4, 1, 1, 1, "Total");
        this.ui.add_col(5, 1, 1, 1, "Mulheres");
        this.ui.add_col(6, 1, 1, 1, "Homens");
        this.ui.add_col(7, 1, 1, 1, "Total");
        if (!CBData.Params.getByName((String)this.ano_val).v.equals("")) {
            int ano = (int)CBData.Params.getByName(this.ano_val).valueAsDouble();
            this.ui.add_col(2, 0, 3, 1, String.valueOf(ano - 1));
            this.cols[4].col_name = String.valueOf(Integer.toString(ano - 1)) + " Mulheres";
            this.cols[5].col_name = String.valueOf(Integer.toString(ano - 1)) + " Homens";
            this.cols[6].col_name = String.valueOf(Integer.toString(ano - 1)) + " Total";
        } else {
            this.ui.add_col(2, 0, 3, 1, "Ano Pr\u00e9-Proj.");
            this.cols[4].col_name = "Ano Pr\u00e9-Proj. Mulheres";
            this.cols[5].col_name = "Ano Pr\u00e9-Proj. Homens";
            this.cols[6].col_name = "Ano Pr\u00e9-Proj. Total";
        }
        String dt_fim = CBData.DadosProjecto.getByName((String)"dt_fim").v;
        if (!dt_fim.equals("")) {
            if (dt_fim.length() == 10) {
                int ano_fim = Integer.parseInt(dt_fim.substring(0, 4));
                this.ui.add_col(5, 0, 3, 1, String.valueOf(ano_fim + this.n_anos));
                this.cols[7].col_name = String.valueOf(Integer.toString(ano_fim + this.n_anos)) + " Mulheres";
                this.cols[8].col_name = String.valueOf(Integer.toString(ano_fim + this.n_anos)) + " Homens";
                this.cols[9].col_name = String.valueOf(Integer.toString(ano_fim + this.n_anos)) + " Total";
            }
        } else {
            this.ui.add_col(5, 0, 3, 1, "Ano Fim Proj.+" + this.n_anos);
            this.cols[7].col_name = "Ano Fim Proj.+" + this.n_anos + " Mulheres";
            this.cols[8].col_name = "Ano Fim Proj.+" + this.n_anos + " Homens";
            this.cols[9].col_name = "Ano Fim Proj.+" + this.n_anos + " Total";
        }
        this.P12.getJTable_PTrabalho().getTableHeader().setUI(this.ui);
        this.handler.repaint_col_names();
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("area")) {
            s = String.valueOf(s) + _lib.xml_encode("area_d", this.getColValue("area_d", row));
        }
        if (tag.equals("nivel")) {
            s = String.valueOf(s) + _lib.xml_encode("nivel_d", this.getColValue("nivel_d", row));
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        int idx_i;
        int ano_cand;
        String titulo = "Postos de Trabalho do Benefici\u00e1rio";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (!this.started) {
            return err_list;
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("ptrabalho", "Lista vazia"));
        }
        int ano_inicial = ano_cand = (int)CBData.Params.getByName(this.ano_val).valueAsDouble();
        String v = CBData.Promotor.getByName((String)"dt_inicio_act").v;
        if (this.tab_index > 0) {
            CBRegisto_Promotor prom = (CBRegisto_Promotor)CBData.ListaCoProm.Lista_Promotor.elementAt(this.tab_index - 1);
            v = prom.getByName((String)"dt_inicio_act").v;
        }
        if (v.length() == 10) {
            ano_inicial = Integer.parseInt(v.substring(0, 4));
        }
        if ((idx_i = 4 - (ano_cand - ano_inicial - 1) * 3) < 0) {
            idx_i = 0;
        }
        int j = 0;
        while (j < this.dados.size()) {
            if (!this.isRowEmpty(j)) {
                if (this.getColValue("area_d", j).equals("")) {
                    err_list.add_msg(new CHValid_Msg("ptrabalho", "Linha " + (j + 1) + " incompleta: \u00c1rea Funcional - %o"));
                } else if (this.tab_index == 0) {
                    String area = this.getColValue("area", j);
                    if (CBData.turismo.equals("0") && area.startsWith("2")) {
                        err_list.add_msg(new CHValid_Msg("ptrabalho", "Linha " + (j + 1) + ": \u00c1rea Funcional inv\u00e1lida"));
                    }
                }
                if (this.getColValue("nivel_d", j).equals("")) {
                    err_list.add_msg(new CHValid_Msg("ptrabalho", "Linha " + (j + 1) + " incompleta: N\u00edvel de Qualifica\u00e7\u00e3o - %o"));
                }
                int i = 4;
                while (i <= 9) {
                    String ano_s = this.cols[i].col_name;
                    String tag = this.cols[i].col_tag;
                    if (i != 6 && i != 9) {
                        String s = ((String[])this.dados.elementAt(j))[i];
                        if (i < 6 && i >= idx_i && s.length() == 0 || i > 6 && s.length() == 0) {
                            String _msg = "Linha " + (j + 1) + " incompleta: " + ano_s + " - %o";
                            _msg = _msg.replaceAll("\n", " ");
                            _msg = _msg.replaceAll("<br>", " ");
                            _msg = _msg.replaceAll("<html>", "");
                            _msg = _msg.replaceAll("</html>", "");
                            _msg = _msg.replaceAll("<div align='center'>", "");
                            _msg = _msg.replaceAll("</div>", "");
                            err_list.add_msg(new CHValid_Msg("ptrabalho", _msg));
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
        return err_list;
    }
}

