/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_ListaCoProm;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_Parceiros
extends CBTabela {
    Frame_ListaCoProm PAG = (Frame_ListaCoProm)fmeApp.Paginas.getPage("ListaCoProm");

    public String getPagina() {
        return "ListaCoProm";
    }

    CBTabela_Parceiros() {
        if (this.PAG == null) {
            return;
        }
        this.initialize();
    }

    void initialize() {
        this.tag = "Parceiros";
        this.started = true;
        this.cols = new CHTabColModel[12];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, null);
        this.cols[1] = new CHTabColModel("pais", "Pa\u00eds (id)", true, true, false, null);
        this.cols[2] = new CHTabColModel("pais_d", "Pa\u00eds", false, false, true, null);
        this.cols[3] = new CHTabColModel("morada", "Morada", true, true, true, null);
        this.cols[4] = new CHTabColModel("localidade", "Localidade", true, true, true, null);
        this.cols[5] = new CHTabColModel("cod_postal", "C\u00f3digo<br>Postal", true, true, true, CFLib.VLD_COD_POSTAL);
        this.cols[6] = new CHTabColModel("cod_postal_loc", "C\u00f3digo Postal<br>Localidade", true, true, true, null);
        this.cols[7] = new CHTabColModel("concelho", "Concelho (id)", true, true, false, null);
        this.cols[8] = new CHTabColModel("concelho_d", "Concelho", false, true, true, null);
        this.cols[9] = new CHTabColModel("telefone", "Telefone", true, true, true, null);
        this.cols[10] = new CHTabColModel("email", "E-Mail", true, true, true, CFLib.VLD_EMAIL);
        this.cols[11] = new CHTabColModel("url", "URL", true, true, true, null);
        this.init_dados(0);
        this.init_handler(this.PAG.getJTable_Parceiros());
        this.PAG.getJTable_Parceiros().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_Parceiros().getWidth() - 5;
        this.handler.set_col_text(0, 0.05, "C");
        this.handler.set_col_text(2, 0.1, null);
        this.handler.set_col_text(3, 0.25, null);
        this.handler.set_col_text(4, 0.1, null);
        this.handler.set_col_text(5, 0.1, null);
        this.handler.set_col_text(6, 0.2, null);
        this.handler.set_col_comboS(8, 0.15, null, CTabelas.Concelhos, 1, 150);
        this.handler.set_col_text(9, 0.15, null);
        this.handler.set_col_text(10, 0.2, null);
        this.handler.set_col_text(11, 0.2, null);
    }

    void numerar(int nCol) {
        int n = 1;
        int i = 0;
        while (i < this.dados.size()) {
            ((String[])this.dados.elementAt((int)i))[nCol] = Integer.toString(n++);
            ++i;
        }
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("pais")) {
            String pais_d = "";
            if (v.length() > 0) {
                pais_d = CTabelas.Pais.lookup(0, v, 1);
            }
            this.setColValue("pais_d", nRow, pais_d);
        }
        if (colname.equals("pais_d")) {
            String pais = "";
            if (v.length() > 0) {
                pais = CTabelas.Pais.lookup(1, v, 0);
            }
            this.setColValue("pais", nRow, pais);
        }
        if (colname.equals("concelho")) {
            String concelho_d = "";
            if (v.length() > 0) {
                concelho_d = CTabelas.Concelhos.lookup(0, v, 1);
            }
            this.setColValue("concelho_d", nRow, concelho_d);
        }
        if (colname.equals("concelho_d")) {
            String concelho = "";
            if (v.length() > 0) {
                concelho = CTabelas.Concelhos.lookup(1, v, 0);
            }
            this.setColValue("concelho", nRow, concelho);
        }
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("pais")) {
            s = String.valueOf(s) + _lib.xml_encode("pais_d", this.getColValue("pais_d", row));
        }
        if (tag.equals("concelho")) {
            s = String.valueOf(s) + _lib.xml_encode("concelho_d", this.getColValue("concelho_d", row));
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Identifica\u00e7\u00e3o dos Parceiros (nacionais e estrangeiros)");
        }
        if (!this.started) {
            return err_list;
        }
        int j = 0;
        while (j < this.dados.size()) {
            StringBuffer mask = new StringBuffer("--RR-----RR-");
            String n_ordem = this.getColValue("n_ordem", j);
            String pais = this.getColValue("pais", j);
            if (pais.length() > 0 && pais.equals("PT")) {
                mask = new StringBuffer("--RRRRR-RRR-");
            }
            TabError[] e = this.isIncompletAll(j, mask.toString());
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                ++ii;
            }
            ++j;
        }
        return err_list;
    }
}

