/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHTabQuadro;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CParseConfig;
import fme.Frame_Financ;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_Finan
extends CBTabela {
    String p3 = "";
    String p2 = "";
    String rubrica = "";
    boolean is_inov = CParseConfig.hconfig.get("extensao").equals("i20");
    Frame_Financ P13 = null;
    int[] hide = null;

    public String getPagina() {
        return "Financ";
    }

    void get_hide() {
        if (this.P13.hide_cols.length() == 0) {
            return;
        }
        String[] hlist = this.P13.hide_cols.split(";");
        this.hide = new int[hlist.length];
        int i = 0;
        while (i < hlist.length) {
            this.hide[i] = Integer.parseInt(hlist[i]);
            ++i;
        }
    }

    int h(int n) {
        if (this.hide == null) {
            return n;
        }
        int m = n;
        int i = 0;
        while (i < this.hide.length) {
            if (this.hide[i] < n) {
                --m;
            }
            ++i;
        }
        return m;
    }

    String hs(int n) {
        if (this.hide == null) {
            return "" + this.h(n);
        }
        int i = 0;
        while (i < this.hide.length) {
            if (this.hide[i] == n) {
                return "x";
            }
            ++i;
        }
        return "" + this.h(n);
    }

    CBTabela_Finan() {
        this.P13 = (Frame_Financ)fmeApp.Paginas.getPage("Financ");
        if (this.P13 == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_Finan(Frame_Financ p) {
        this.P13 = p;
        this.initialize();
    }

    void initialize() {
        this.tag = "Financ";
        this.started = true;
        this.get_hide();
        this.cols = new CHTabColModel[13];
        this.cols[0] = new CHTabColModel("rubrica", "Rubricas", true, false, false, null);
        this.cols[1] = new CHTabColModel("rubrica_d", "Rubricas", false, false, true, null);
        this.cols[2] = new CHTabColModel("val_p1", "Ano -1", true, true, true, CFLib.VLD_VALOR_S);
        this.cols[3] = new CHTabColModel("val_0", "Ano 0", true, true, true, CFLib.VLD_VALOR_S);
        this.cols[4] = new CHTabColModel("val_1", "Ano 1", true, true, true, CFLib.VLD_VALOR_S);
        this.cols[5] = new CHTabColModel("val_2", "Ano 2", true, true, true, CFLib.VLD_VALOR_S);
        this.cols[6] = new CHTabColModel("val_3", "Ano 3", true, true, true, CFLib.VLD_VALOR_S);
        this.cols[7] = new CHTabColModel("val_4", "Ano 4", true, true, true, CFLib.VLD_VALOR_S);
        this.cols[8] = new CHTabColModel("val_5", "Ano 5", true, true, true, CFLib.VLD_VALOR_S);
        this.cols[9] = new CHTabColModel("val_6", "Ano 6", true, true, this.is_inov, CFLib.VLD_VALOR_S);
        this.cols[10] = new CHTabColModel("val_7", "Ano 7", true, true, false, CFLib.VLD_VALOR_S);
        this.cols[11] = new CHTabColModel("total", "Total", false, false, true, CFLib.VLD_VALOR_S);
        this.cols[12] = new CHTabColModel("perc", "%", true, false, false, CFLib.VLD_VALOR_S);
        this.init_dados(this.h(22));
        this.init_handler(new CHTabQuadro(), this.P13.getJTable_Financ());
        this.P13.getJTable_Financ().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P13.getJScrollPane_Financ().getWidth() - 1;
        this.cols[0].disable_row_calc = true;
        this.cols[1].disable_row_calc = true;
        this.cols[12].disable_row_calc = true;
        ((CHTabQuadro)this.handler).start_rows();
        ((CHTabQuadro)this.handler).row_editable[this.h((int)0)] = false;
        ((CHTabQuadro)this.handler).row_editable[this.h((int)6)] = false;
        ((CHTabQuadro)this.handler).row_editable[this.h((int)9)] = false;
        ((CHTabQuadro)this.handler).row_editable[this.h((int)15)] = false;
        ((CHTabQuadro)this.handler).row_editable[this.h((int)19)] = false;
        ((CHTabQuadro)this.handler).row_editable[this.h((int)20)] = false;
        ((CHTabQuadro)this.handler).row_editable[this.h((int)21)] = false;
        this.keyCol = 0;
        ((String[])this.dados.elementAt((int)this.h((int)0)))[0] = "01";
        ((String[])this.dados.elementAt((int)this.h((int)1)))[0] = "0101";
        ((String[])this.dados.elementAt((int)this.h((int)2)))[0] = "0102";
        ((String[])this.dados.elementAt((int)this.h((int)3)))[0] = "02";
        ((String[])this.dados.elementAt((int)this.h((int)4)))[0] = "03";
        ((String[])this.dados.elementAt((int)this.h((int)5)))[0] = "05";
        ((String[])this.dados.elementAt((int)this.h((int)6)))[0] = "04";
        ((String[])this.dados.elementAt((int)this.h((int)7)))[0] = "0401";
        ((String[])this.dados.elementAt((int)this.h((int)8)))[0] = "0402";
        ((String[])this.dados.elementAt((int)this.h((int)9)))[0] = "0403";
        ((String[])this.dados.elementAt((int)this.h((int)10)))[0] = "040301";
        ((String[])this.dados.elementAt((int)this.h((int)11)))[0] = "040302";
        ((String[])this.dados.elementAt((int)this.h((int)12)))[0] = "0404";
        ((String[])this.dados.elementAt((int)this.h((int)13)))[0] = "0405";
        ((String[])this.dados.elementAt((int)this.h((int)14)))[0] = "0406";
        ((String[])this.dados.elementAt((int)this.h((int)15)))[0] = "0407";
        ((String[])this.dados.elementAt((int)this.h((int)16)))[0] = "040701";
        ((String[])this.dados.elementAt((int)this.h((int)17)))[0] = "040702";
        ((String[])this.dados.elementAt((int)this.h((int)18)))[0] = "0499";
        ((String[])this.dados.elementAt((int)this.h((int)19)))[0] = "90";
        ((String[])this.dados.elementAt((int)this.h((int)20)))[0] = "91";
        ((String[])this.dados.elementAt((int)this.h((int)21)))[0] = "92";
        ((String[])this.dados.elementAt((int)this.h((int)0)))[1] = "Capitais Pr\u00f3prios (1)";
        ((String[])this.dados.elementAt((int)this.h((int)1)))[1] = "    Capital";
        ((String[])this.dados.elementAt((int)this.h((int)2)))[1] = "    Presta\u00e7\u00f5es Suplementares Capital";
        ((String[])this.dados.elementAt((int)this.h((int)3)))[1] = "Autofinanciamento (2)";
        ((String[])this.dados.elementAt((int)this.h((int)4)))[1] = "Outros (3)";
        ((String[])this.dados.elementAt((int)this.h((int)5)))[1] = "Fundos Pr\u00f3prios de Natureza P\u00fablica";
        ((String[])this.dados.elementAt((int)this.h((int)6)))[1] = "Financiamentos";
        ((String[])this.dados.elementAt((int)this.h((int)7)))[1] = "    Financiamento de Institui\u00e7\u00f5es de Cr\u00e9dito";
        ((String[])this.dados.elementAt((int)this.h((int)8)))[1] = "    Empr\u00e9stimos por Obriga\u00e7\u00f5es";
        ((String[])this.dados.elementAt((int)this.h((int)9)))[1] = "    Financiamento de S\u00f3cios/Acionistas";
        ((String[])this.dados.elementAt((int)this.h((int)10)))[1] = "        Suprimentos Consolidados (3)";
        ((String[])this.dados.elementAt((int)this.h((int)11)))[1] = "        Outras d\u00edvidas a S\u00f3cios/Acionistas";
        ((String[])this.dados.elementAt((int)this.h((int)12)))[1] = "    Fornecedores de Investimentos";
        ((String[])this.dados.elementAt((int)this.h((int)13)))[1] = "    Loca\u00e7\u00e3o Financeira";
        ((String[])this.dados.elementAt((int)this.h((int)14)))[1] = "    Financiamento das empresas";
        ((String[])this.dados.elementAt((int)this.h((int)15)))[1] = "    Incentivo";
        ((String[])this.dados.elementAt((int)this.h((int)16)))[1] = "        N\u00e3o Reembols\u00e1vel (INR)";
        ((String[])this.dados.elementAt((int)this.h((int)17)))[1] = "        Reembols\u00e1vel (IR)";
        ((String[])this.dados.elementAt((int)this.h((int)18)))[1] = "    Outros";
        ((String[])this.dados.elementAt((int)this.h((int)19)))[1] = "FINANCIAMENTO TOTAL";
        ((String[])this.dados.elementAt((int)this.h((int)20)))[1] = "INVESTIMENTO TOTAL";
        ((String[])this.dados.elementAt((int)this.h((int)21)))[1] = "INVESTIMENTO ELEG\u00cdVEL TOTAL";
        this.handler.set_col_text(1, 0.35, null);
        this.handler.set_col_text(2, 0.15, "R");
        this.handler.set_col_text(3, 0.15, "R");
        this.handler.set_col_text(4, 0.15, "R");
        this.handler.set_col_text(5, 0.15, "R");
        this.handler.set_col_text(6, 0.15, "R");
        this.handler.set_col_text(7, 0.15, "R");
        this.handler.set_col_text(8, 0.15, "R");
        if (this.is_inov) {
            this.handler.set_col_text(9, 0.15, "R");
        }
        this.handler.set_col_text(11, 0.15, "R");
        ((CHTabQuadro)this.handler).row_autocalc[this.h((int)0)] = "$soma(+" + this.hs(1) + ",+" + this.hs(2) + ")";
        ((CHTabQuadro)this.handler).row_autocalc[this.h((int)6)] = "$soma(+" + this.hs(7) + ",+" + this.hs(8) + ",+" + this.hs(10) + ",+" + this.hs(11) + ",+" + this.hs(12) + ",+" + this.hs(13) + ",+" + this.hs(14) + ",+" + this.hs(16) + ",+" + this.hs(17) + ",+" + this.hs(18) + ")";
        ((CHTabQuadro)this.handler).row_autocalc[this.h((int)9)] = "$soma(+" + this.hs(10) + ",+" + this.hs(11) + ")";
        ((CHTabQuadro)this.handler).row_autocalc[this.h((int)15)] = "$soma(+" + this.hs(16) + ",+" + this.hs(17) + ")";
        ((CHTabQuadro)this.handler).row_autocalc[this.h((int)19)] = "$soma(+" + this.hs(1) + ",+" + this.hs(2) + ",+" + this.hs(3) + ",+" + this.hs(4) + ",+" + this.hs(5) + ",+" + this.hs(7) + ",+" + this.hs(8) + ",+" + this.hs(10) + ",+" + this.hs(11) + ",+" + this.hs(12) + ",+" + this.hs(13) + ",+" + this.hs(14) + ",+" + this.hs(16) + ",+" + this.hs(17) + ",+" + this.hs(18) + ")";
        CBData.Params.bind_ano_cand_update(this);
    }

    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        if (tag.equals("ano_cand")) {
            int ano = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
            this.cols[2].col_name = Integer.toString(ano - 1);
            this.cols[3].col_name = Integer.toString(ano);
            this.cols[4].col_name = Integer.toString(ano + 1);
            this.cols[5].col_name = Integer.toString(ano + 2);
            this.cols[6].col_name = Integer.toString(ano + 3);
            this.cols[7].col_name = Integer.toString(ano + 4);
            this.cols[8].col_name = Integer.toString(ano + 5);
            this.cols[9].col_name = Integer.toString(ano + 6);
            this.handler.repaint_col_names();
        }
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.startsWith("val_")) {
            double total = 0.0;
            double v_1 = _lib.to_double(((String[])this.dados.elementAt(nRow))[2]);
            double v0 = _lib.to_double(((String[])this.dados.elementAt(nRow))[3]);
            double v1 = _lib.to_double(((String[])this.dados.elementAt(nRow))[4]);
            double v2 = _lib.to_double(((String[])this.dados.elementAt(nRow))[5]);
            double v3 = _lib.to_double(((String[])this.dados.elementAt(nRow))[6]);
            double v4 = _lib.to_double(((String[])this.dados.elementAt(nRow))[7]);
            double v5 = _lib.to_double(((String[])this.dados.elementAt(nRow))[8]);
            double v6 = _lib.to_double(((String[])this.dados.elementAt(nRow))[9]);
            double v7 = _lib.to_double(((String[])this.dados.elementAt(nRow))[10]);
            total = _lib.round(v_1 + v0 + v1 + v2 + v3 + v4 + v5 + v6 + v7);
            ((String[])this.dados.elementAt((int)nRow))[this.getColIndex((String)"total")] = Double.toString(total);
            this.autocalc();
            this.handler.j.repaint();
            double financiamento = _lib.to_double(((String[])this.dados.elementAt(this.h(19)))[2]) + _lib.to_double(((String[])this.dados.elementAt(this.h(19)))[3]) + _lib.to_double(((String[])this.dados.elementAt(this.h(19)))[4]) + _lib.to_double(((String[])this.dados.elementAt(this.h(19)))[5]) + _lib.to_double(((String[])this.dados.elementAt(this.h(19)))[6]) + _lib.to_double(((String[])this.dados.elementAt(this.h(19)))[7]) + _lib.to_double(((String[])this.dados.elementAt(this.h(19)))[8]) + _lib.to_double(((String[])this.dados.elementAt(this.h(19)))[9]) + _lib.to_double(((String[])this.dados.elementAt(this.h(19)))[10]);
            ((String[])this.dados.elementAt((int)this.h((int)19)))[this.getColIndex((String)"total")] = Double.toString(financiamento);
            int i = 0;
            while (i < this.dados.size() - 2) {
                double perc = 0.0;
                total = 0.0;
                v_1 = _lib.to_double(((String[])this.dados.elementAt(i))[2]);
                v0 = _lib.to_double(((String[])this.dados.elementAt(i))[3]);
                v1 = _lib.to_double(((String[])this.dados.elementAt(i))[4]);
                v2 = _lib.to_double(((String[])this.dados.elementAt(i))[5]);
                v3 = _lib.to_double(((String[])this.dados.elementAt(i))[6]);
                v4 = _lib.to_double(((String[])this.dados.elementAt(i))[7]);
                v5 = _lib.to_double(((String[])this.dados.elementAt(i))[8]);
                v6 = _lib.to_double(((String[])this.dados.elementAt(i))[9]);
                v7 = _lib.to_double(((String[])this.dados.elementAt(i))[10]);
                total = _lib.round(v_1 + v0 + v1 + v2 + v3 + v4 + v5 + v6 + v7);
                if (_lib.round(financiamento) > 0.0) {
                    perc = _lib.round(total / financiamento * 100.0);
                    ((String[])this.dados.elementAt((int)i))[this.getColIndex((String)"perc")] = Double.toString(perc);
                } else {
                    ((String[])this.dados.elementAt((int)i))[this.getColIndex((String)"perc")] = "";
                }
                ++i;
            }
        }
        this.autocalc();
        this.handler.j.repaint();
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("rubrica")) {
            s = String.valueOf(s) + _lib.xml_encode("rubrica_d", ((String[])this.dados.elementAt(row))[1]);
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Estrutura de Financiamento (Recursos Financeiros)");
        }
        double fin_total = _lib.round(_lib.to_double(this.getColValue("total", this.h(19))));
        double inv_total = _lib.round(_lib.to_double(this.getColValue("total", this.h(20))));
        if (fin_total == 0.0) {
            err_list.add_msg(new CHValid_Msg("finan", "%o"));
        }
        if (inv_total > fin_total) {
            err_list.add_msg(new CHValid_Msg("finan", 'W', "O Financiamento Total \u00e9 inferior ao Investimento Total"));
        }
        int j = 2;
        while (j <= 10) {
            double fin;
            double inv = _lib.round(_lib.to_double(((String[])this.dados.elementAt(this.h(20)))[j]));
            if (inv > (fin = _lib.round(_lib.to_double(((String[])this.dados.elementAt(this.h(19)))[j])))) {
                err_list.add_msg(new CHValid_Msg("finan", 'W', "Financiamento inferior ao Investimento Total (" + this.cols[j].col_name + ")"));
            }
            ++j;
        }
        if (!CBData.Promotor.getByName("dt_inicio_act").isEmpty()) {
            int ano_c = _lib.to_int(CBData.Params.getByName((String)"ano_cand").v);
            int ano_i = _lib.to_int(CBData.Promotor.getByName((String)"dt_inicio_act").v.substring(0, 4));
            if (ano_i <= ano_c - 1) {
                double meios_lib = CBData.DR_SNC.calc_meios_lib("val_p1");
                int c = 2;
                while (c <= 10) {
                    double autofin = _lib.round(_lib.to_double(((String[])this.dados.elementAt(this.h(3)))[c]));
                    if (autofin > 0.0 && autofin > meios_lib) {
                        err_list.add_msg(new CHValid_Msg("finan", 'W', "Autofinanciamento " + this.cols[c].col_name + " (" + _lib.to_format(autofin) + ") superior aos Meios Libertos (" + _lib.to_format(meios_lib) + ")"));
                    }
                    ++c;
                }
            }
        }
        return err_list;
    }
}

