/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_ActivEconomica;
import fme.fmeApp;

class CBRegisto_ActivEcon
extends CBRegisto {
    Frame_ActivEconomica P;
    int tab_index = 0;
    String ano_val = "ano_cand";

    public String getPagina() {
        return "ActivEconomica";
    }

    CBRegisto_ActivEcon() {
        this.P = (Frame_ActivEconomica)fmeApp.Paginas.getPage("ActivEconomica");
        if (this.P == null) {
            return;
        }
        this.initialize();
    }

    CBRegisto_ActivEcon(Frame_ActivEconomica p, int idx) {
        this.P = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "ActivEconomica";
        this.started = true;
        this.Campos.add(new CHCampo_Text("vendas_pse_2", this.P.getJTextField_VendasPSE_2(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("vendas_pse_3", this.P.getJTextField_VendasPSE_3(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("vendas_pse_4", this.P.getJTextField_VendasPSE_4(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("vendas_pse_5", this.P.getJTextField_VendasPSE_5(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("export_p1", this.P.getJTextField_Export_p1(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("export_0", this.P.getJTextField_Export_0(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("export_1", this.P.getJTextField_Export_1(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("export_2", this.P.getJTextField_Export_2(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("export_3", this.P.getJTextField_Export_3(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("export_4", this.P.getJTextField_Export_4(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("export_5", this.P.getJTextField_Export_5(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("export_proj_2", this.P.getJTextField_ExportProj_2(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("export_proj_3", this.P.getJTextField_ExportProj_3(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("export_proj_4", this.P.getJTextField_ExportProj_4(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("export_proj_5", this.P.getJTextField_ExportProj_5(), CFLib.VLD_VALOR_0, this));
        CBData.Params.bind_ano_cand_update(this);
    }

    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        if (tag.startsWith("ano_")) {
            int ano = (int)CBData.Params.getByName(tag).valueAsDouble();
            String s = "";
            if (ano == 0) {
                s = "Ano ";
            }
            this.P.jLabel_p1.setText(String.valueOf(s) + (ano - 1));
            this.P.jLabel_0.setText(String.valueOf(s) + ano);
            this.P.jLabel_1.setText(String.valueOf(s) + (ano + 1));
            this.P.jLabel_2.setText(String.valueOf(s) + (ano + 2));
            this.P.jLabel_3.setText(String.valueOf(s) + (ano + 3));
            this.P.jLabel_4.setText(String.valueOf(s) + (ano + 4));
            this.P.jLabel_5.setText(String.valueOf(s) + (ano + 5));
            this.ano_val = tag;
        }
    }

    void on_update(String tag) {
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        String titulo = "Impacto do projeto no volume de neg\u00f3cios da empresa";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        this.extract();
        CBData.Promotor.extract();
        String ano = CBData.Params.getByName((String)this.ano_val).v;
        if (!ano.equals("")) {
            int ano_cand;
            int ano_inicial = ano_cand = Integer.parseInt(ano);
            String v = CBData.Promotor.getByName((String)"dt_inicio_act").v;
            if (v.length() == 10) {
                ano_inicial = Integer.parseInt(v.substring(0, 4));
            }
            int idx = 5 - (ano_cand - ano_inicial - 1);
            if (this.getByName("export_p1").isEmpty() && ano_inicial <= ano_cand - 1) {
                err_list.add_msg(new CHValid_Msg("export_p1", "Volume de Neg\u00f3cios Internacional (" + (ano_cand - 1) + ") - %o"));
            }
            if (this.getByName("export_0").isEmpty() && ano_inicial <= ano_cand) {
                err_list.add_msg(new CHValid_Msg("export_0", "Volume de Neg\u00f3cios Internacional (" + ano_cand + ") - %o"));
            }
            if (this.getByName("export_1").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("export_1", "Volume de Neg\u00f3cios Internacional (" + (ano_cand + 1) + ") - %o"));
            }
            if (this.getByName("vendas_pse_2").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("vendas_pse_2", "Vendas + PSE resultantes do proj. (" + (ano_cand + 2) + ") - %o"));
            }
            if (this.getByName("export_2").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("export_2", "Volume de Neg\u00f3cios Internacional (" + (ano_cand + 2) + ") - %o"));
            }
            if (this.getByName("export_proj_2").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("export_proj_2", "Exporta\u00e7\u00f5es resultantes do proj. (" + (ano_cand + 2) + ") - %o"));
            }
            if (this.getByName("vendas_pse_3").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("vendas_pse_3", "Vendas + PSE resultantes do proj. (" + (ano_cand + 3) + ") - %o"));
            }
            if (this.getByName("export_3").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("export_3", "Volume de Neg\u00f3cios Internacional (" + (ano_cand + 3) + ") - %o"));
            }
            if (this.getByName("export_proj_3").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("export_proj_3", "Exporta\u00e7\u00f5es resultantes do proj. (" + (ano_cand + 3) + ") - %o"));
            }
            if (this.getByName("vendas_pse_4").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("vendas_pse_4", "Vendas + PSE resultantes do proj. (" + (ano_cand + 4) + ") - %o"));
            }
            if (this.getByName("export_4").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("export_4", "Volume de Neg\u00f3cios Internacional (" + (ano_cand + 4) + ") - %o"));
            }
            if (this.getByName("export_proj_4").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("export_proj_4", "Exporta\u00e7\u00f5es resultantes do proj. (" + (ano_cand + 4) + ") - %o"));
            }
            if (this.getByName("vendas_pse_5").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("vendas_pse_5", "Vendas + PSE resultantes do proj. (" + (ano_cand + 5) + ") - %o"));
            }
            if (this.getByName("export_5").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("export_5", "Volume de Neg\u00f3cios Internacional (" + (ano_cand + 5) + ") - %o"));
            }
            if (this.getByName("export_proj_5").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("export_proj_5", "Exporta\u00e7\u00f5es resultantes do proj. (" + (ano_cand + 5) + ") - %o"));
            }
        }
        return err_list;
    }
}

