/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBData_Comum;
import fme.CBRegisto;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHCampo;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHCampo_TextArea;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CParseConfig;
import fme.Frame_Proj_1;
import fme._lib;
import fme.fmeApp;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTextArea;

class CBRegisto_DadosProjecto
extends CBRegisto {
    public Frame_Proj_1 P07;
    int limite = 1000;
    Vector dt_fim_updates = new Vector();

    public String getPagina() {
        return "Proj_1";
    }

    CBRegisto_DadosProjecto() {
        this.tag = "DadosProjecto";
        this.P07 = (Frame_Proj_1)fmeApp.Paginas.getPage("Proj_1");
        if (this.P07 == null) {
            return;
        }
        this.started = true;
        this.Campos.add(new CHCampo_Text("acronimo", this.P07.getJTextField_Acronimo(), null, this));
        this.Campos.add(new CHCampo_Text("titulo", this.P07.getJTextField_Designacao(), null, this));
        this.Campos.add(new CHCampo_TextArea("outras_areas", this.P07.getJTextArea_OutrasAreas(), this));
        this.Campos.add(new CHCampo_TextArea("sintese_pt", this.P07.getJTextArea_Sintese_PT(), this));
        this.Campos.add(new CHCampo_TextArea("sintese_en", this.P07.getJTextArea_Sintese_EN(), this));
        CHCampo_Opt irp = new CHCampo_Opt("redes", this);
        irp.setOptions("S", "N");
        irp.addComponent(this.P07.getJCheckBox_RPIID_Sim());
        irp.addComponent(this.P07.getJCheckBox_RPIID_Nao());
        irp.dummy = this.P07.jCheckBox_RPIID_Clear;
        this.Campos.add(irp);
        this.Campos.add(new CHCampo_Text("dt_inicio", this.P07.getJTextField_Inicio(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("n_meses", this.P07.getJTextField_Meses(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_Text("dt_fim", this.P07.getJTextField_Fim(), CFLib.VLD_DATA, this));
        String[] s = new String[]{"S"};
        CHCampo_Opt opt_o_1 = new CHCampo_Opt("pedido", s, this);
        opt_o_1.addComponent(this.P07.jCheckBox_Pedido);
        opt_o_1.dummy = this.P07.jCheckBox_Pedido_Clear;
        this.Campos.add(opt_o_1);
        this.Campos.add(new CHCampo_Text("investimento", this.P07.getJTextField_InvTotal(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_Text("elegivel", this.P07.getJTextField_Eleg(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_TextArea("texto_pedido", this.P07.getJTextArea_Fundamenta(), this));
    }

    void bind_dt_fim_update(CBData_Comum d) {
        this.dt_fim_updates.add(d);
    }

    void on_update(String tag) {
        CHCampo chc;
        if (tag.equals("dt_fim")) {
            int i = 0;
            while (i < this.dt_fim_updates.size()) {
                ((CBData_Comum)this.dt_fim_updates.elementAt(i)).on_external_update(tag);
                ++i;
            }
        }
        if (tag.equals("dt_inicio") || tag.equals("dt_fim")) {
            String dt_inicio = this.getByName((String)"dt_inicio").v;
            String dt_fim = this.getByName((String)"dt_fim").v;
            if (dt_inicio.length() == 0 || dt_fim.length() == 0 || dt_fim.compareTo(dt_inicio) < 0) {
                this.getByName("n_meses").setStringValue("");
                return;
            }
            int ano_i = Integer.parseInt(dt_inicio.substring(0, 4));
            int ano_f = Integer.parseInt(dt_fim.substring(0, 4));
            int mes_i = Integer.parseInt(dt_inicio.substring(5, 7));
            int mes_f = Integer.parseInt(dt_fim.substring(5, 7));
            int dia_i = Integer.parseInt(dt_inicio.substring(8, 10));
            int dia_f = Integer.parseInt(dt_fim.substring(8, 10));
            double n_meses = (ano_f - ano_i) * 12 + (mes_f - mes_i - 1);
            double mes = mes_i;
            double d = 0.0;
            if (mes == 1.0 || mes == 3.0 || mes == 5.0 || mes == 7.0 || mes == 8.0 || mes == 10.0 || mes == 12.0) {
                d = 31.0;
            }
            if (mes == 4.0 || mes == 6.0 || mes == 9.0 || mes == 11.0) {
                d = 30.0;
            }
            if (mes == 2.0 && ano_i % 4 == 0) {
                d = 29.0;
            }
            if (mes == 2.0 && ano_i % 4 != 0) {
                d = 28.0;
            }
            n_meses += (d - (double)dia_i + 1.0) / d;
            mes = mes_f;
            if (mes == 1.0 || mes == 3.0 || mes == 5.0 || mes == 7.0 || mes == 8.0 || mes == 10.0 || mes == 12.0) {
                d = 31.0;
            }
            if (mes == 4.0 || mes == 6.0 || mes == 9.0 || mes == 11.0) {
                d = 30.0;
            }
            if (mes == 2.0 && ano_f % 4 == 0) {
                d = 29.0;
            }
            if (mes == 2.0 && ano_f % 4 != 0) {
                d = 28.0;
            }
            this.getByName("n_meses").setStringValue(Double.toString(n_meses += (double)dia_f / d));
        }
        if (tag.equals("texto_pedido") && (chc = this.getByName(tag)) instanceof CHCampo_TextArea) {
            JTextArea jta = ((CHCampo_TextArea)chc).jcomp;
            int n = jta.getText().length();
            this.P07.jLabel_Count.setText(String.valueOf(this.limite - n) + "/" + this.limite);
        }
    }

    void Clear() {
        int i = 0;
        while (i < this.Campos.size()) {
            if (!(((CHCampo)this.Campos.elementAt((int)i)).tag.equals("inv_geral") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("inv_pessoal") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("investimento") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("elegivel"))) {
                ((CHCampo)this.Campos.elementAt(i)).clear();
            }
            ++i;
        }
    }

    CHValid_Grp validar_1(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Designa\u00e7\u00e3o do Projeto e Tipologia(s) de Investimento");
        }
        this.extract();
        if (this.getByName("acronimo").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("acronimo", "Acr\u00f3nimo - %o"));
        }
        if (this.getByName("titulo").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("titulo", "T\u00edtulo - %o"));
        }
        if (!this.getByName("titulo").isEmpty() && this.getByName((String)"titulo").v.length() > 250) {
            err_list.add_msg(new CHValid_Msg("titulo", "T\u00edtulo - Texto demasiado extenso. Por favor, abrevie at\u00e9 250 caracteres."));
        }
        this.P07.CBData_AreasTecno.validar(err_list);
        boolean outras = false;
        int i = 0;
        while (i < this.P07.CBData_AreasTecno.dados.size()) {
            if (this.P07.CBData_AreasTecno.getColValue("area_tecno", i).equals("99")) {
                outras = true;
                break;
            }
            ++i;
        }
        if (this.getByName("outras_areas").isEmpty() && outras) {
            err_list.add_msg(new CHValid_Msg("outras_areas", "Outras \u00c1reas Tecnol. - Quais? - %o"));
        }
        if (!this.getByName("outras_areas").isEmpty() && this.getByName((String)"outras_areas").v.length() > 250) {
            err_list.add_msg(new CHValid_Msg("outras_areas", "Outras \u00c1reas Tecnol. - Quais? - Texto demasiado extenso. Por favor, abrevie at\u00e9 250 caracteres."));
        }
        if (this.getByName("sintese_pt").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("sintese_pt", "S\u00edntese (Portugu\u00eas) - %o"));
        }
        if (!this.getByName("sintese_pt").isEmpty() && this.getByName((String)"sintese_pt").v.length() > 2000) {
            err_list.add_msg(new CHValid_Msg("sintese_pt", "S\u00edntese (Portugu\u00eas) - Texto demasiado extenso. Por favor, abrevie at\u00e9 2000 caracteres."));
        }
        if (this.getByName("sintese_en").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("sintese_en", "S\u00edntese (Ingl\u00eas) - %o"));
        }
        if (!this.getByName("sintese_en").isEmpty() && this.getByName((String)"sintese_en").v.length() > 2000) {
            err_list.add_msg(new CHValid_Msg("sintese_en", "S\u00edntese (Ingl\u00eas) - Texto demasiado extenso. Por favor, abrevie at\u00e9 2000 caracteres."));
        }
        return err_list;
    }

    CHValid_Grp validar_2(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Inser\u00e7\u00e3o em Redes e Programas Internacionais de IDI");
        }
        this.extract();
        if (this.getByName("redes").isEmpty()) {
            String txt = this.P07.jLabel_RPIID.getText();
            txt = txt.replaceAll("<html>", "");
            txt = txt.replaceAll("</html>", "");
            err_list.add_msg(new CHValid_Msg("redes", String.valueOf(txt) + " - %o"));
        }
        return err_list;
    }

    CHValid_Grp validar_3(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Calendariza\u00e7\u00e3o e Investimento");
        }
        this.extract();
        int ano_c = _lib.to_int(CBData.Params.getByName((String)"ano_ref_proj").v);
        if (this.getByName("dt_inicio").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de In\u00edcio do Projeto - %o"));
        } else {
            int ano_i = _lib.to_int(this.getByName((String)"dt_inicio").v.substring(0, 4));
            if (ano_i < ano_c || ano_i > ano_c + 2) {
                err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de In\u00edcio do Projeto - fora do intervalo de refer\u00eancia aceit\u00e1vel"));
            }
        }
        if (this.getByName("dt_fim").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_fim", "Data de Fim do Projeto - %o"));
        } else if (!this.getByName("dt_inicio").isEmpty()) {
            Date today = new Date();
            Date dt_inicio = CFType_Data.parse_date(this.getByName((String)"dt_inicio").v);
            Date dt_fim = CFType_Data.parse_date(this.getByName((String)"dt_fim").v);
            if (dt_inicio != null && dt_fim != null && dt_fim.before(dt_inicio)) {
                err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de In\u00edcio n\u00e3o pode ser posterior \u00e0 Data de Fim do Projeto"));
            } else {
                int limite;
                int ano_i = _lib.to_int(this.getByName((String)"dt_inicio").v.substring(0, 4));
                int ano_f = _lib.to_int(this.getByName((String)"dt_fim").v.substring(0, 4));
                if (ano_f > ano_i + (limite = 4)) {
                    err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de Fim do Projeto - fora do intervalo de refer\u00eancia aceit\u00e1vel"));
                }
            }
        }
        double duracao_max = _lib.to_double(CParseConfig.hconfig.get("duracao_max").toString());
        if (this.getByName((String)"n_meses").v.length() > 0 && Double.parseDouble(this.getByName((String)"n_meses").v) > duracao_max && !this.getByName((String)"pedido").v.equals("S")) {
            err_list.add_msg(new CHValid_Msg("dt_inicio", "O seu projeto tem mais de " + _lib.to_format(duracao_max) + " meses"));
        }
        return err_list;
    }

    CHValid_Grp validar_4(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Fundamenta\u00e7\u00e3o do pedido de exce\u00e7\u00e3o");
        }
        this.extract();
        String erro = "Texto demasiado extenso. Por favor, abrevie at\u00e9 " + this.limite + " caracteres.";
        if (this.getByName((String)"pedido").v.equals("S") && this.getByName("texto_pedido").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("texto_pedido", "%o"));
        }
        if (!this.getByName("texto_pedido").isEmpty() && this.getByName((String)"texto_pedido").v.length() > this.limite) {
            err_list.add_msg(new CHValid_Msg("texto_pedido", erro));
        }
        return err_list;
    }
}

