/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHCampo;
import fme.CHCampo_Combo;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_ContPublica;
import fme.Frame_IdProm_1;
import fme._lib;
import fme.fmeApp;
import java.util.Date;

class CBRegisto_Promotor
extends CBRegisto {
    Frame_IdProm_1 P01;
    int tab_index = 0;
    String ano_val = "ano_cand";

    public String getPagina() {
        return "IdProm_01";
    }

    CBRegisto_Promotor() {
        this.P01 = (Frame_IdProm_1)fmeApp.Paginas.getPage("IdProm_1");
        if (this.P01 == null) {
            return;
        }
        this.initialize();
    }

    CBRegisto_Promotor(Frame_IdProm_1 p, int idx) {
        this.tab_index = idx;
        this.P01 = p;
        this.initialize();
    }

    void initialize() {
        this.tag = "Promotor";
        this.started = true;
        this.P01.cbd_promotor = this;
        this.Campos.add(new CHCampo_Text("nif", this.P01.getJTextField_NIF(), CFLib.VLD_NIF));
        this.Campos.add(new CHCampo_Text("nome", this.P01.getJTextField_Nome(), null, this));
        this.Campos.add(new CHCampo_Text("morada", this.P01.getJTextField_Morada(), null));
        this.Campos.add(new CHCampo_Text("localidade", this.P01.getJTextField_Localidade(), null));
        this.Campos.add(new CHCampo_Text("cod_postal", this.P01.getJTextField_CodPostal(), CFLib.VLD_COD_POSTAL));
        this.Campos.add(new CHCampo_Text("cod_postal_loc", this.P01.getJTextField_CodPostalLocal(), null));
        this.Campos.add(new CHCampo_Combo("distrito", "Distritos", this.P01.getJComboBox_Distrito(), (CBRegisto)this));
        this.Campos.add(new CHCampo_Combo("concelho", "ConcelhosF1", this.P01.getJComboBox_Concelho(), (CBRegisto)this));
        this.Campos.add(new CHCampo_Text("telefone", this.P01.getJTextField_Telefone(), null));
        this.Campos.add(new CHCampo_Text("telefax", this.P01.getJTextField_Telefax(), null));
        this.Campos.add(new CHCampo_Text("email", this.P01.getJTextField_Email(), CFLib.VLD_EMAIL));
        this.Campos.add(new CHCampo_Text("url", this.P01.getJTextField_Url(), null));
        this.Campos.add(new CHCampo_Combo("nat_jur", "NatJuridica", this.P01.getJComboBox_NatJuridica(), (CBRegisto)this));
        CHCampo_Opt opt_fins = new CHCampo_Opt("fins_lucro");
        opt_fins.setOptions("S", "N");
        opt_fins.addComponent(this.P01.getJCheckBox_FinsLucro_Sim());
        opt_fins.addComponent(this.P01.getJCheckBox_FinsLucro_Nao());
        opt_fins.dummy = this.P01.jCheckBox_FinsLucro_Clear;
        this.Campos.add(opt_fins);
        CHCampo_Opt opt_publica = new CHCampo_Opt("publica", this);
        opt_publica.setOptions("S", "N");
        opt_publica.addComponent(this.P01.getJCheckBox_Publica_Sim());
        opt_publica.addComponent(this.P01.getJCheckBox_Publica_Nao());
        opt_publica.dummy = this.P01.jCheckBox_Publica_Clear;
        this.Campos.add(opt_publica);
        this.Campos.add(new CHCampo_Text("dt_const", this.P01.getJTextField_DtConst(), CFLib.VLD_DATA));
        this.Campos.add(new CHCampo_Text("dt_inicio_act", this.P01.getJTextField_DtInicioAct(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("cap_social", this.P01.getJTextField_CapSocial(), CFLib.VLD_VALOR));
        this.Campos.add(new CHCampo_Text("rgc_num", this.P01.getJTextField_Matricula(), null));
        this.Campos.add(new CHCampo_Text("rgc_cons", this.P01.getJTextField_Conservatoria(), null));
        this.Campos.add(new CHCampo_Text("cod_ies1", this.P01.getJTextField_IES_p1(), null, this));
        this.Campos.add(new CHCampo_Text("cod_ies2", this.P01.getJTextField_IES_p2(), null, this));
        this.Campos.add(new CHCampo_Text("cod_ies3", this.P01.getJTextField_IES_p3(), null, this));
        CBData.Params.bind_ano_cand_update(this);
    }

    void on_update(String tag) {
        String concelho;
        Frame_ContPublica cp;
        if (tag.equals("publica") && (cp = (Frame_ContPublica)fmeApp.Paginas.getPage("ContPublica")) != null) {
            cp.set_NA(!this.getByName((String)"publica").v.equals("S"));
        }
        if (tag.equals("concelho") && (concelho = this.getByName("concelho").getStringValue()).length() > 0) {
            this.getByName("distrito").setStringValue(concelho.substring(0, 2));
        }
        if (tag.equals("distrito")) {
            String distrito = this.getByName("distrito").getStringValue();
            String concelho2 = this.getByName("concelho").getStringValue();
            if (concelho2.length() > 0 && !concelho2.substring(0, 2).equals(distrito)) {
                this.getByName("concelho").setStringValue("");
            }
        }
    }

    public void on_external_update(String tag) {
        if (!tag.startsWith("ano_")) {
            return;
        }
        String anoCand = CBData.Params.getByName((String)tag).v;
        if (anoCand.length() > 0) {
            int ano = Integer.parseInt(anoCand);
            this.P01.jLabel_IES_p1.setText(String.valueOf(ano - 1));
            this.P01.jLabel_IES_p2.setText(String.valueOf(ano - 2));
            this.P01.jLabel_IES_p3.setText(String.valueOf(ano - 3));
        } else {
            this.P01.jLabel_IES_p1.setText("Ano -1");
            this.P01.jLabel_IES_p2.setText("Ano -2");
            this.P01.jLabel_IES_p3.setText("Ano -3");
        }
        this.ano_val = tag;
    }

    String on_xml(String tag) {
        String c;
        String s = "";
        if (tag.equals("concelho")) {
            c = this.getByName(tag).getStringValue();
            s = c.length() == 0 ? String.valueOf(s) + "<concelho_d/>\n" : String.valueOf(s) + _lib.xml_encode("concelho_d", CTabelas.Concelhos.getDesign(c));
        }
        if (tag.equals("distrito")) {
            String d = this.getByName(tag).getStringValue();
            s = d.length() == 0 ? String.valueOf(s) + "<distrito_d/>\n" : String.valueOf(s) + _lib.xml_encode("distrito_d", CTabelas.Distritos.getDesign(d));
        }
        if (tag.equals("nat_jur")) {
            c = this.getByName(tag).getStringValue();
            s = c.length() == 0 ? String.valueOf(s) + "<nat_jur_d/>\n" : String.valueOf(s) + _lib.xml_encode("nat_jur_d", CTabelas.NatJuridica.getDesign(c));
        }
        return s;
    }

    void Clear2() {
        int i = 0;
        while (i < this.Campos.size()) {
            if (!(((CHCampo)this.Campos.elementAt((int)i)).tag.equals("fins_lucro") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("cod_ies1") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("cod_ies2") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("cod_ies3"))) {
                ((CHCampo)this.Campos.elementAt(i)).clear();
            }
            ++i;
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp, boolean publica) {
        String titulo = "Identifica\u00e7\u00e3o do Benefici\u00e1rio";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        this.extract();
        if (this.getByName("nif").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nif", "N\u00ba de Identifica\u00e7\u00e3o Fiscal - %o"));
        }
        if (this.getByName("nome").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nome", "Nome ou Designa\u00e7\u00e3o Social - %o"));
        }
        if (this.getByName("morada").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("morada", "Morada (Sede Social) - %o"));
        }
        if (this.getByName("localidade").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("localidade", "Localidade - %o"));
        }
        if (this.getByName("cod_postal").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("cod_postal", "C\u00f3digo Postal - %o"));
        }
        if (this.getByName("cod_postal_loc").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("cod_postal_loc", "C\u00f3digo Postal (localidade) - %o"));
        }
        if (this.getByName("distrito").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("distrito", "Distrito - %o"));
        } else if (this.getByName((String)"distrito").v.equals("99")) {
            err_list.add_msg(new CHValid_Msg("distrito", "Distrito inv\u00e1lido"));
        }
        if (this.getByName("concelho").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("concelho", "Concelho - %o"));
        }
        if (this.getByName("telefone").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("telefone", "Telefone - %o"));
        }
        if (this.getByName("email").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("email", "E-mail - %o"));
        }
        if (this.getByName("nat_jur").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nat_jur", "Natureza Jur\u00eddica - %o"));
        } else if (!this.getByName((String)"nat_jur").v.matches("4|17|19|20|21|24|31|32|10|9|22|23|25|27|28|29")) {
            if (this.getByName("dt_const").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("dt_const", "Data de Constitui\u00e7\u00e3o - %o"));
            }
            if (this.getByName("rgc_num").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("rgc_num", "Matriculada sob o n.\u00ba - %o"));
            }
            if (this.getByName("rgc_cons").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("rgc_cons", "Conservat\u00f3ria do Registo Comercial - %o"));
            }
            if (this.getByName("cap_social").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("cap_social", String.valueOf(this.P01.jLabel_CapSocial.getText()) + " - %o"));
            }
        }
        if (this.getByName("fins_lucro").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("fins_lucro", "Fins Lucrativos - %o"));
        }
        if (this.getByName("publica").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("publica", "Empresa P\u00fablica ou Entidade P\u00fablica Empresarial ... - %o"));
        }
        if (this.getByName("dt_inicio_act").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_inicio_act", "Data de In\u00edcio de Atividade - %o"));
        } else {
            int ano_c = _lib.to_int(CBData.Params.getByName((String)this.ano_val).v);
            int ano_i = _lib.to_int(this.getByName((String)"dt_inicio_act").v.substring(0, 4));
            if (ano_i > ano_c + 1) {
                err_list.add_msg(new CHValid_Msg("dt_inicio_act", "Data de In\u00edcio de Atividade - fora do intervalo de refer\u00eancia aceit\u00e1vel"));
            }
        }
        Date today = new Date();
        Date dt_const = CFType_Data.parse_date(this.getByName((String)"dt_const").v);
        Date dt_act = CFType_Data.parse_date(this.getByName((String)"dt_inicio_act").v);
        if (dt_const != null && dt_const.after(today)) {
            err_list.add_msg(new CHValid_Msg("dt_const", 'W', "Data de Constitui\u00e7\u00e3o ?"));
        }
        if (dt_const != null && dt_act != null && dt_act.before(dt_const)) {
            err_list.add_msg(new CHValid_Msg("dt_const", "Data de In\u00edcio de Atividade anterior \u00e0 Data de Constitui\u00e7\u00e3o"));
        }
        if (!this.getByName("dt_inicio_act").isEmpty() && !publica) {
            int ano_cand;
            int ano = ano_cand = (int)CBData.Params.getByName(this.ano_val).valueAsDouble();
            String v = this.getByName((String)"dt_inicio_act").v;
            if (v.length() == 10) {
                ano = Integer.parseInt(v.substring(0, 4));
            }
            if (ano <= ano_cand - 1 && this.getByName("cod_ies1").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("", 'W', "IES (" + this.P01.jLabel_IES_p1.getText() + ") - P.f. preencha este campo"));
            }
            if (ano <= ano_cand - 2 && this.getByName("cod_ies2").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("", 'W', "IES (" + this.P01.jLabel_IES_p2.getText() + ") - P.f. preencha este campo"));
            }
            if (ano <= ano_cand - 3 && this.getByName("cod_ies3").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("", 'W', "IES (" + this.P01.jLabel_IES_p3.getText() + ") - P.f. preencha este campo"));
            }
        }
        return err_list;
    }
}

