/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Amortizacoes;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;
import java.util.Date;

class CBTabela_Amortizacoes
extends CBTabela {
    Frame_Amortizacoes P = (Frame_Amortizacoes)fmeApp.Paginas.getPage("Amortizacoes");

    public String getPagina() {
        return "Amortizacoes";
    }

    CBTabela_Amortizacoes() {
        if (this.P == null) {
            return;
        }
        this.initialize();
    }

    void initialize() {
        this.tag = "Amort";
        this.started = true;
        this.force_xml = true;
        this.cols = new CHTabColModel[8];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, null);
        this.cols[1] = new CHTabColModel("design", "Designa\u00e7\u00e3o", true, false, true, null);
        this.cols[2] = new CHTabColModel("classe", "Classifica\u00e7\u00e3o das Despesas (id)", true, true, false, null);
        this.cols[3] = new CHTabColModel("classe_d", "Classifica\u00e7\u00e3o das Despesas", false, false, true, null);
        this.cols[4] = new CHTabColModel("elegivel", "Eleg\u00edvel", true, false, true, CFLib.VLD_VALOR);
        this.cols[5] = new CHTabColModel("tx_anual", "Taxa Anual de Amort.", true, true, true, CFLib.VLD_PERC_0);
        this.cols[6] = new CHTabColModel("dt_inicio", "Per\u00edodo de Afeta\u00e7\u00e3o / In\u00edcio", true, true, true, CFLib.VLD_DATA);
        this.cols[7] = new CHTabColModel("dt_fim", "Per\u00edodo de Afeta\u00e7\u00e3o / Fim", true, true, true, CFLib.VLD_DATA);
        this.init_dados(14);
        this.init_handler(this.P.getJTable_Amortizacoes());
        this.P.getJTable_Amortizacoes().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P.getJScrollPane_Amortizacoes().getWidth() - 2;
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.P.getJTable_Amortizacoes());
        this.ui.add_col(0, 0, 1, 2, "<html><div style='text-align:center'>N\u00ba</div></html>");
        this.ui.add_col(1, 0, 1, 2, "<html><div style='text-align:center'>Designa\u00e7\u00e3o</div></html>");
        this.ui.add_col(2, 0, 1, 2, "<html><div style='text-align:center'>Classifica\u00e7\u00e3o<br>das Despesas</div></html>");
        this.ui.add_col(3, 0, 1, 2, "<html><div style='text-align:center'>Eleg\u00edvel</div></html>");
        this.ui.add_col(4, 0, 1, 2, "<html><div style='text-align:center'>Taxa<br>Anual de<br>Amort.</div></html>");
        this.ui.add_col(5, 0, 2, 1, "<html><div style='text-align:center'>Per\u00edodo de Afeta\u00e7\u00e3o</div></html>");
        this.ui.add_col(5, 1, 1, 1, "<html><div style='text-align:center'>In\u00edcio</div></html>");
        this.ui.add_col(6, 1, 1, 1, "<html><div style='text-align:center'>Fim</div></html>");
        this.P.getJTable_Amortizacoes().getTableHeader().setUI(this.ui);
        this.handler.set_col(0, 0.07, "C");
        this.handler.set_col(1, 0.275, null);
        this.handler.set_col(3, 0.18, null);
        this.handler.set_col(4, 0.13, "R");
        this.handler.set_col(5, 0.1, "C");
        this.handler.set_col(6, 0.11, "C");
        this.handler.set_col(7, 0.11, "C");
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("classe")) {
            String classe_d = "";
            if (v.length() > 0) {
                classe_d = CTabelas.TipoDesp.lookup(0, v, 1);
            }
            this.setColValue("classe_d", nRow, classe_d);
        }
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("classe")) {
            s = String.valueOf(s) + _lib.xml_encode("classe_d", this.getColValue("classe_d", row));
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Investimentos sujeitos a Amortiza\u00e7\u00f5es");
        }
        CBData.QInv.preenche_amortizacoes();
        Date dt_ini = CFType_Data.parse_date(CBData.DadosProjecto.getByName((String)"dt_inicio").v);
        Date dt_fim = CFType_Data.parse_date(CBData.DadosProjecto.getByName((String)"dt_fim").v);
        int i = 0;
        while (i < this.dados.size()) {
            int linha_n_doc;
            String mask = "-----RRR";
            double tx_anual = _lib.to_double(this.getColValue("tx_anual", i));
            if (tx_anual == 0.0) {
                mask = "-----R--";
            }
            TabError[] e = this.isIncompletAll(i, mask.toString());
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                ++ii;
            }
            if (!this.getColValue("dt_inicio", i).equals("") && (linha_n_doc = CBData.QInv.lookup("n_ordem", this.getColValue("n_ordem", i))) >= 0) {
                String calend_qinv = CBData.QInv.getColValue("calendario", linha_n_doc);
                String calend_amort = this.getColValue("dt_inicio", i).substring(0, 7);
                if (calend_amort.compareTo(calend_qinv) < 0) {
                    err_list.add_msg(new CHValid_Msg("incomplet", "Linha " + (i + 1) + ": Data de In\u00edcio anterior \u00e0 Calendariza\u00e7\u00e3o no Quadro de Investimentos"));
                }
            }
            if (!this.getColValue("dt_fim", i).equals("")) {
                Date dt_fim_a = CFType_Data.parse_date(this.getColValue("dt_fim", i));
                if (!CBData.DadosProjecto.getByName((String)"dt_fim").v.equals("") && dt_fim_a.after(dt_fim)) {
                    err_list.add_msg(new CHValid_Msg("incomplet", "Linha " + (i + 1) + ": Data de Fim posterior \u00e0 Data de Fim do Projeto"));
                }
            }
            if (!this.getColValue("dt_fim", i).equals("") && !this.getColValue("dt_inicio", i).equals("")) {
                Date dt_ini_a = CFType_Data.parse_date(this.getColValue("dt_inicio", i));
                Date dt_fim_a = CFType_Data.parse_date(this.getColValue("dt_fim", i));
                if (dt_ini_a.after(dt_fim_a)) {
                    err_list.add_msg(new CHValid_Msg("incomplet", "Linha " + (i + 1) + ": Data de In\u00edcio posterior \u00e0 Data de Fim"));
                }
            }
            ++i;
        }
        return err_list;
    }

    void clearRow(int i) {
        int j = 0;
        while (j < this.cols.length) {
            ((String[])this.dados.elementAt((int)i))[j] = "";
            this.on_update(this.cols[j].col_tag, i, "");
            ++j;
        }
    }
}

