/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_CurricIDT;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_InovaIDT
extends CBTabela {
    Frame_CurricIDT PAG;
    int tab_index = 0;
    String ano_val = "ano_cand";

    public String getPagina() {
        return "CurricIDT";
    }

    CBTabela_InovaIDT() {
        this.PAG = (Frame_CurricIDT)fmeApp.Paginas.getPage("CurricIDT");
        if (this.PAG == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_InovaIDT(Frame_CurricIDT p, int idx) {
        this.tab_index = idx;
        this.PAG = p;
        this.initialize();
    }

    void initialize() {
        this.tag = "InovaIDT";
        this.started = true;
        this.cols = new CHTabColModel[7];
        this.cols[0] = new CHTabColModel("design", "Designa\u00e7\u00e3o do Produto/Processo", true, true, true, null);
        this.cols[1] = new CHTabColModel("origem", "Origem do Desenvolvimento (id)", true, false, false, null);
        this.cols[2] = new CHTabColModel("origem_d", "Origem do Desenvolvimento", false, true, true, null);
        this.cols[3] = new CHTabColModel("ano_lanc", "Ano<br>Lan\u00e7amento", true, true, true, CFLib.VLD_INT);
        this.cols[4] = new CHTabColModel("pvend_2", "Ano -2", true, true, true, CFLib.VLD_PERC_0);
        this.cols[5] = new CHTabColModel("pvend_1", "Ano -1", true, true, true, CFLib.VLD_PERC_0);
        this.cols[6] = new CHTabColModel("pvend_0", "Ano 0", true, true, true, CFLib.VLD_PERC_0);
        this.init_dados(4);
        this.init_handler(this.PAG.getJTable_InovaIDT());
        this.PAG.getJTable_InovaIDT().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_InovaIDT().getWidth() - 20;
        this.on_external_update("");
        this.handler.set_col_text(0, 0.25, null);
        this.handler.set_col_comboS(2, 0.25, null, CTabelas.OrigemDesenv, 1, 260);
        this.handler.set_col_text(3, 0.065, null);
        this.handler.set_col_text(4, 0.145, "R");
        this.handler.set_col_text(5, 0.145, "R");
        this.handler.set_col_text(6, 0.145, "R");
        CBData.Params.bind_ano_ref_proj_update(this);
    }

    void on_update(String tag, int nRow, String v) {
        if (tag.equals("origem")) {
            String origem_d = "";
            if (v.length() > 0) {
                origem_d = CTabelas.OrigemDesenv.lookup(0, v, 1);
            }
            this.setColValue("origem_d", nRow, origem_d);
        }
        if (tag.equals("origem_d")) {
            String origem = "";
            if (v.length() > 0) {
                origem = CTabelas.OrigemDesenv.lookup(1, v, 0);
            }
            this.setColValue("origem", nRow, origem);
        }
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("origem")) {
            s = String.valueOf(s) + _lib.xml_encode("origem_d", this.getColValue("origem_d", row));
        }
        return s;
    }

    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        String[] anos = new String[]{"Ano 0", "Ano -1", "Ano -2"};
        if (tag.startsWith("ano_")) {
            int ano = (int)CBData.Params.getByName(tag).valueAsDouble();
            if (ano > 0) {
                anos[2] = Integer.toString(ano - 2);
                anos[1] = Integer.toString(ano - 1);
                anos[0] = Integer.toString(ano);
            }
            this.cols[this.getColIndex((String)"pvend_2")].col_name = anos[2];
            this.cols[this.getColIndex((String)"pvend_1")].col_name = anos[1];
            this.cols[this.getColIndex((String)"pvend_0")].col_name = anos[0];
            this.ano_val = tag;
        }
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(3, this.PAG.getJTable_InovaIDT());
        this.ui.add_col(0, 0, 1, 3, "Designa\u00e7\u00e3o do Produto/Processo");
        this.ui.add_col(1, 0, 1, 3, "Origem do Desenvolvimento");
        this.ui.add_col(2, 0, 1, 3, "<html><center>Ano de<br>Lan\u00e7a-<br>mento</center></html>");
        this.ui.add_col(3, 0, 3, 2, "<html><center>% das Vendas no Volume de Vendas da Empresa<br>(aplic\u00e1vel apenas no caso de lan\u00e7amento de novos produtos)</center></html>");
        this.ui.add_col(3, 2, 1, 1, anos[2]);
        this.ui.add_col(4, 2, 1, 1, anos[1]);
        this.ui.add_col(5, 2, 1, 1, anos[0]);
        this.PAG.getJTable_InovaIDT().getTableHeader().setUI(this.ui);
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Lan\u00e7ou inova\u00e7\u00f5es nos \u00faltimos tr\u00eas anos?");
        }
        if (!this.started) {
            return err_list;
        }
        if (this.isEmpty() && CBData.CurricIDT.getByName((String)"inova_idt").v.equals("S")) {
            err_list.add_msg(new CHValid_Msg("prodidt", "Lista vazia"));
        }
        if (!this.isEmpty() && CBData.CurricIDT.getByName((String)"inova_idt").v.equals("N")) {
            err_list.add_msg(new CHValid_Msg("prodidt", "Lista - Neste Caso N\u00e3o Preenche"));
        } else {
            int j = 0;
            while (j < this.dados.size()) {
                String mask = "R-RRRRR";
                TabError[] e = this.isIncompletAll(j, mask.toString());
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                    ++ii;
                }
                ++j;
            }
        }
        return err_list;
    }
}

