/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_PessoalSC;
import fme.GroupableTableHeaderUI;
import fme.SteppedComboBox;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_PessoalSC
extends CBTabela {
    public SteppedComboBox cboEntidades = null;
    public SteppedComboBox cboEstabs = null;
    Frame_PessoalSC PAG;
    String ano_val = "ano_cand";

    public String getPagina() {
        return "PessoalSC";
    }

    CBTabela_PessoalSC() {
        this.tag = "PessoalSC";
        this.PAG = (Frame_PessoalSC)fmeApp.Paginas.getPage("PessoalSC");
        if (this.PAG == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_PessoalSC(Frame_PessoalSC p) {
        this.tag = "PessoalSC";
        this.PAG = p;
        this.initialize();
    }

    void initialize() {
        this.force_xml = true;
        this.started = true;
        this.cols = new CHTabColModel[19];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, null);
        this.cols[1] = new CHTabColModel("perfil", "Perfil", true, true, true, null);
        this.cols[2] = new CHTabColModel("entidade", null, true, false, false, null);
        this.cols[3] = new CHTabColModel("entidade_d", "Entidade<br>Externa", false, true, true, null);
        this.cols[4] = new CHTabColModel("categ", "Categoria (id)", true, false, false, null);
        this.cols[5] = new CHTabColModel("categ_d", "Categoria", false, true, true, null);
        this.cols[6] = new CHTabColModel("classe", null, true, false, false, null);
        this.cols[7] = new CHTabColModel("classe_d", "Classifica\u00e7\u00e3o<br>da Despesa", false, true, false, null);
        this.cols[8] = new CHTabColModel("estab", "Estab.", true, true, true, null);
        this.cols[9] = new CHTabColModel("custo", "Custo<br>Pessoa/M\u00eas", true, true, true, CFLib.VLD_VALOR);
        this.cols[10] = new CHTabColModel("n_meses_0", "N\u00ba Pessoas-M\u00eas<br>ano 0", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[11] = new CHTabColModel("n_meses_1", "N\u00ba Pessoas-M\u00eas<br>ano 1", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[12] = new CHTabColModel("n_meses_2", "N\u00ba Pessoas-M\u00eas<br>ano 2", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[13] = new CHTabColModel("n_meses_3", "N\u00ba Pessoas-M\u00eas<br>ano 3", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[14] = new CHTabColModel("custo_0", "Custo total<br>ano 0", true, false, true, CFLib.VLD_VALOR);
        this.cols[15] = new CHTabColModel("custo_1", "Custo total<br>ano 1", true, false, true, CFLib.VLD_VALOR);
        this.cols[16] = new CHTabColModel("custo_2", "Custo total<br>ano 2", true, false, true, CFLib.VLD_VALOR);
        this.cols[17] = new CHTabColModel("custo_3", "Custo total<br>ano 3", true, false, true, CFLib.VLD_VALOR);
        this.cols[18] = new CHTabColModel("custo_total", "Custo total", true, false, true, CFLib.VLD_VALOR);
        this.init_dados(6);
        this.init_handler(this.PAG.getJTable_PessoalSC());
        this.PAG.getJTable_PessoalSC().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_PessoalSC().getWidth() - 20;
        this.on_external_update("");
        this.handler.set_col_text(0, 0.04, "C");
        this.handler.set_col_text(1, 0.43, null);
        this.handler.set_col_comboS(3, 0.133, null, CTabelas.Entidades, 1, 175);
        this.handler.set_col_comboS(5, 0.12, null, CTabelas.Categorias, 1, 485);
        this.cboEstabs = this.handler.set_col_comboFD(8, 0.06, "C", CTabelas.EstabsF1, 1, 200);
        this.handler.set_col_text(9, 0.12, "R");
        this.handler.set_col_text(10, 0.08, "R");
        this.handler.set_col_text(11, 0.08, "R");
        this.handler.set_col_text(12, 0.08, "R");
        this.handler.set_col_text(13, 0.08, "R");
        this.handler.set_col_text(14, 0.12, "R");
        this.handler.set_col_text(15, 0.12, "R");
        this.handler.set_col_text(16, 0.12, "R");
        this.handler.set_col_text(17, 0.12, "R");
        this.handler.set_col_text(18, 0.12, "R");
        CBData.Params.bind_ano_ref_proj_update(this);
    }

    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        String[] anos = new String[]{"Ano 0", "Ano 1", "Ano 2", "Ano 3"};
        if (tag.startsWith("ano_")) {
            int ano = (int)CBData.Params.getByName(tag).valueAsDouble();
            if (ano > 0) {
                anos[3] = Integer.toString(ano + 3);
                anos[2] = Integer.toString(ano + 2);
                anos[1] = Integer.toString(ano + 1);
                anos[0] = Integer.toString(ano);
            }
            this.cols[this.getColIndex((String)"n_meses_0")].col_name = "N\u00ba Pessoas-M\u00eas - " + anos[0];
            this.cols[this.getColIndex((String)"n_meses_1")].col_name = "N\u00ba Pessoas-M\u00eas - " + anos[1];
            this.cols[this.getColIndex((String)"n_meses_2")].col_name = "N\u00ba Pessoas-M\u00eas - " + anos[2];
            this.cols[this.getColIndex((String)"n_meses_3")].col_name = "N\u00ba Pessoas-M\u00eas - " + anos[3];
            this.cols[this.getColIndex((String)"custo_0")].col_name = "Custo Total - " + anos[0];
            this.cols[this.getColIndex((String)"custo_1")].col_name = "Custo Total - " + anos[1];
            this.cols[this.getColIndex((String)"custo_2")].col_name = "Custo Total - " + anos[2];
            this.cols[this.getColIndex((String)"custo_3")].col_name = "Custo Total - " + anos[3];
            this.ano_val = tag;
        }
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.PAG.getJTable_PessoalSC());
        int i = 0;
        this.ui.add_col(i++, 0, 1, 2, "N\u00ba");
        this.ui.add_col(i++, 0, 1, 2, "Perfil");
        this.ui.add_col(i++, 0, 1, 2, "<html><center>Entidade<br>Externa</center></html>");
        this.ui.add_col(i++, 0, 1, 2, "<html><center>Categoria</center></html>");
        this.ui.add_col(i++, 0, 1, 2, "Estab.");
        this.ui.add_col(i++, 0, 1, 2, "<html><center>Custo<br>Pessoa/M\u00eas</center></html>");
        this.ui.add_col(i, 0, 4, 1, "N\u00ba Pessoas-M\u00eas");
        this.ui.add_col(i++, 1, 1, 1, anos[0]);
        this.ui.add_col(i++, 1, 1, 1, anos[1]);
        this.ui.add_col(i++, 1, 1, 1, anos[2]);
        this.ui.add_col(i++, 1, 1, 1, anos[3]);
        this.ui.add_col(i, 0, 5, 1, "Custo Total");
        this.ui.add_col(i++, 1, 1, 1, anos[0]);
        this.ui.add_col(i++, 1, 1, 1, anos[1]);
        this.ui.add_col(i++, 1, 1, 1, anos[2]);
        this.ui.add_col(i++, 1, 1, 1, anos[3]);
        this.ui.add_col(i++, 1, 1, 1, "Total");
        this.PAG.getJTable_PessoalSC().getTableHeader().setUI(this.ui);
    }

    void calc_custo_pessoal() {
        int i = 0;
        while (i < this.dados.size()) {
            this.calc_custo_tecnico(i);
            ++i;
        }
        CBData.QInv.calc_dados_projecto();
    }

    void on_update(String colname, int nRow, String v) {
        this.numerar(0);
        if (colname.equals("classe")) {
            String classe_d = "";
            if (v.length() > 0) {
                classe_d = CTabelas.Honorarios.lookup(0, v, 1);
            }
            this.setColValue("classe_d", nRow, classe_d);
        }
        if (colname.equals("classe_d")) {
            String classe = "";
            if (v.length() > 0) {
                classe = CTabelas.Honorarios.lookup(1, v, 0);
            }
            this.setColValue("classe", nRow, classe);
        }
        if (colname.equals("entidade")) {
            String entidade_d = "";
            if (v.length() > 0) {
                entidade_d = CTabelas.Entidades.lookup(0, v, 1);
            }
            this.setColValue("entidade_d", nRow, entidade_d);
        }
        if (colname.equals("entidade_d")) {
            String entidade = "";
            if (v.length() > 0) {
                entidade = CTabelas.Entidades.lookup(1, v, 0);
            }
            this.setColValue("entidade", nRow, entidade);
        }
        if (colname.equals("categ")) {
            String categoria_d = "";
            if (v.length() > 0) {
                categoria_d = CTabelas.Categorias.lookup(0, v, 1);
            }
            this.setColValue("categ_d", nRow, categoria_d);
        }
        if (colname.equals("categ_d")) {
            String categoria = "";
            if (v.length() > 0) {
                categoria = CTabelas.Categorias.lookup(1, v, 0);
            }
            this.setColValue("categ", nRow, categoria);
        }
        if (colname.equals("n_ordem") || colname.equals("perfil")) {
            return;
        }
        if (!CBData.reading_xml && !CBData.is_cleaning) {
            this.calc_custo_tecnico(nRow);
            CBData.QInv.calc_dados_projecto();
        }
    }

    void calc_custo_tecnico(int nRow) {
        double custo = 0.0;
        if (!this.getColValue("custo", nRow).equals("")) {
            custo = Double.parseDouble(this.getColValue("custo", nRow));
        }
        String n_ordem = this.getColValue("n_ordem", nRow);
        double ano_0 = _lib.to_double(this.getColValue("n_meses_0", nRow));
        double ano_1 = _lib.to_double(this.getColValue("n_meses_1", nRow));
        double ano_2 = _lib.to_double(this.getColValue("n_meses_2", nRow));
        double ano_3 = _lib.to_double(this.getColValue("n_meses_3", nRow));
        double custo_0 = _lib.round(ano_0 * custo);
        double custo_1 = _lib.round(ano_1 * custo);
        double custo_2 = _lib.round(ano_2 * custo);
        double custo_3 = _lib.round(ano_3 * custo);
        double custo_total = _lib.round(custo_0 + custo_1 + custo_2 + custo_3);
        this.setColValue("custo_0", nRow, _lib.to_string(custo_0));
        this.setColValue("custo_1", nRow, _lib.to_string(custo_1));
        this.setColValue("custo_2", nRow, _lib.to_string(custo_2));
        this.setColValue("custo_3", nRow, _lib.to_string(custo_3));
        this.setColValue("custo_total", nRow, _lib.to_string(custo_total));
        ((Frame_PessoalSC)fmeApp.Paginas.getPage("PessoalSC")).getJTextField_Total().setText(_lib.to_format(this.getSum("custo_total")));
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("entidade")) {
            s = String.valueOf(s) + _lib.xml_encode("entidade_d", this.getColValue("entidade_d", row));
        }
        if (tag.equals("classe")) {
            s = String.valueOf(s) + _lib.xml_encode("classe_d", this.getColValue("classe_d", row));
        }
        if (tag.equals("categ")) {
            s = String.valueOf(s) + _lib.xml_encode("categ_d", this.getColValue("categ_d", row));
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        return this.validar(err_list, "");
    }

    CHValid_Grp validar(CHValid_Grp err_list, String nt) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Pessoal T\u00e9cnico das Entidades Externas" + nt);
        }
        if (!this.started) {
            return err_list;
        }
        int j = 0;
        while (j < this.dados.size()) {
            if (!this.isRowEmpty(j)) {
                String mask = "-R-R-R--RRRRRR-----";
                TabError[] e = this.isIncompletAll(j, mask.toString());
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                    ++ii;
                }
            }
            ++j;
        }
        return err_list;
    }
}

