/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_QuadrosTecn_2;
import fme.SteppedComboBox;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_QuadrosTecn
extends CBTabela {
    public SteppedComboBox cboEstabs = null;
    public SteppedComboBox cboEmpresas = null;
    Frame_QuadrosTecn_2 P_2;
    boolean col_coop = false;

    public String getPagina() {
        return "QuadrosTecn";
    }

    CBTabela_QuadrosTecn() {
        this.tag = "QuadrosTecn";
        this.P_2 = (Frame_QuadrosTecn_2)fmeApp.Paginas.getPage("QuadrosTecn_2");
        if (this.P_2 == null) {
            return;
        }
        this.started = true;
        this.col_coop = this.P_2.coluna_coop.equals("S");
        this.cols = new CHTabColModel[13];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, CFLib.VLD_INT);
        this.cols[1] = new CHTabColModel("area", "\u00c1rea Funcional (id)", true, true, false, null);
        this.cols[2] = new CHTabColModel("area_d", "\u00c1rea<br>Funcional", false, true, true, null);
        this.cols[3] = new CHTabColModel("area_form", "\u00c1rea de Forma\u00e7\u00e3o", true, true, true, null);
        this.cols[4] = new CHTabColModel("habilit", "N\u00edvel (id)", true, true, false, null);
        this.cols[5] = new CHTabColModel("habilit_d", "N\u00edvel de<br>Qualif.", false, true, true, null);
        this.cols[6] = new CHTabColModel("data", "Data prev.<br>contrata\u00e7\u00e3o", true, true, true, CFLib.VLD_DATA);
        this.cols[7] = new CHTabColModel("n_meses", "Dura\u00e7\u00e3o<br>(meses)", true, true, true, CFLib.VLD_VALOR);
        this.cols[8] = new CHTabColModel("empresa", "Empresa<br>(proj. coopera\u00e7\u00e3o)", true, true, this.col_coop, null);
        this.cols[9] = new CHTabColModel("estab", "Estab.", true, true, true, null);
        this.cols[10] = new CHTabColModel("remuneracao", "Remunera\u00e7\u00e3o<br>(mensal)", true, true, true, CFLib.VLD_VALOR);
        this.cols[11] = new CHTabColModel("taxa_segs", "Taxa de<br>Seguran\u00e7a<br>Social", true, true, true, CFLib.VLD_PERC_0);
        this.cols[12] = new CHTabColModel("custo", "Custo<br>Total", true, false, true, CFLib.VLD_VALOR_0);
        this.init_dados(6);
        this.init_handler(this.P_2.getJTable_QuadrosTecn_1());
        this.P_2.getJTable_QuadrosTecn_1().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P_2.getJScrollPane_QuadrosTecn_1().getWidth();
        this.handler.set_col_text(0, 0.05, "C");
        this.handler.set_col_comboS(2, 0.15, null, CTabelas.AreasFunc, 1, 220);
        this.handler.set_col_text(3, 0.19, null);
        this.handler.set_col_comboS(5, 0.078, null, CTabelas.NiveisQual, 1, 0);
        this.handler.set_col_text(6, 0.1, null);
        this.handler.set_col_text(7, 0.06, "R");
        this.cboEstabs = this.handler.set_col_comboFD(9, 0.05, "C", CTabelas.EstabsF1, 1, 200);
        this.handler.set_col_text(10, 0.11, "R");
        this.handler.set_col_text(11, 0.08, "R");
        this.handler.set_col_text(12, 0.11, "R");
        this.started = true;
    }

    void calc_total() {
        this.P_2.getJTextField_Total().setText(_lib.to_format(this.getSum("custo")));
    }

    void on_update(String colname, int nRow, String v) {
        this.numerar(0);
        if (colname.equals("n_meses") || colname.equals("remuneracao") || colname.equals("taxa_segs")) {
            double n_meses = _lib.to_double(this.getColValue("n_meses", nRow));
            double venc_mes = _lib.to_double(this.getColValue("remuneracao", nRow));
            double taxa_segs = _lib.to_double(this.getColValue("taxa_segs", nRow));
            double custo = 0.0;
            if (n_meses != 0.0 && venc_mes != 0.0 && !this.getColValue("taxa_segs", nRow).equals("")) {
                custo = _lib.round(venc_mes * (1.0 + taxa_segs / 100.0) * 14.0 / 12.0 * n_meses);
            }
            if (custo == 0.0) {
                this.setColValue("custo", nRow, "");
            } else {
                this.setColValue("custo", nRow, _lib.to_string(custo));
            }
            this.calc_total();
        }
        if (colname.equals("habilit_d")) {
            String habilit = "";
            if (v.length() > 0) {
                habilit = CTabelas.NiveisQual.lookup(1, v, 0);
            }
            this.setColValue("habilit", nRow, habilit);
        }
        if (colname.equals("habilit")) {
            String habilit_d = "";
            if (v.length() > 0) {
                if (v.equals("10b")) {
                    v = "Q6";
                } else if (v.equals("11")) {
                    v = "";
                }
                this.setColValue("habilit", nRow, v);
                if (v.length() > 0) {
                    habilit_d = CTabelas.NiveisQual.lookup(0, v, 1);
                }
            }
            this.setColValue("habilit_d", nRow, habilit_d);
        }
        if (colname.equals("area_d")) {
            String area = "";
            if (v.length() > 0) {
                area = CTabelas.AreasFunc.lookup(1, v, 0);
            }
            this.setColValue("area", nRow, area);
        }
        if (colname.equals("area")) {
            String area_d = "";
            if (v.length() > 0) {
                area_d = CTabelas.AreasFunc.lookup(0, v, 1);
            }
            this.setColValue("area_d", nRow, area_d);
        }
        if (colname.equals("estab")) {
            String empresa;
            boolean existe = false;
            if (CBData.reading_xml && v.length() > 0) {
                empresa = "0";
                int emp = Integer.parseInt(empresa);
                existe = CBData.PromLocal.existe_estab(v);
                if (!existe) {
                    this.on_update("estab", nRow, "");
                    this.setColValue("estab", nRow, "");
                    return;
                }
            }
            if (v.length() > 0) {
                empresa = "1";
                CTabelas.EstabsF1.set_filter(3, empresa);
            }
        }
        if (colname.equals("empresa")) {
            String estab = this.getColValue("estab", nRow);
            if (this.cboEmpresas != null) {
                this.setColValue("estab", nRow, "");
                this.on_update("estab", nRow, "");
            }
        }
        this.handler.j.repaint();
        if (!CBData.reading_xml && !CBData.is_cleaning) {
            CBData.QInv.calc_dados_projecto();
        }
    }

    boolean existem_estabs() {
        int i = 0;
        while (i < this.dados.size()) {
            if (this.getColValue("estab", i).length() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void limpar_estabs() {
        int i = 0;
        while (i < this.dados.size()) {
            this.setColValue("estab", i, "");
            this.on_update("estab", i, "");
            ++i;
        }
    }

    void _filter_populate_estabs(SteppedComboBox cboEstabs, int row) {
        int n;
        String empresa = "1";
        if (this.cboEmpresas != null && (empresa = this.getColValue("empresa", row)).length() > 0) {
            empresa = empresa.substring(0, empresa.indexOf("-") - 1);
        }
        String estabs = this.getColValue("estab", row);
        CTabelas.EstabsF1.set_filter(3, empresa);
        CTabelas.EstabsF1._populateComboBox(cboEstabs, 0);
        if (estabs.length() > 0 && (n = CTabelas.EstabsF1.getIndexFromCode(estabs)) >= 0) {
            cboEstabs.setSelectedIndex(n + 1);
        }
    }

    double getSumAno(String colName, String ano) {
        double v = 0.0;
        int n = this.getColIndex(colName);
        int ano_col = this.getColIndex("data");
        int nRows = this.dados.size();
        int i = 0;
        while (i < nRows) {
            String s;
            String data = ((String[])this.dados.elementAt(i))[ano_col];
            if (data.length() > 0 && (s = ((String[])this.dados.elementAt(i))[n]).length() != 0 && (data = data.substring(0, 4)).equals(ano)) {
                v = _lib.round(v + Double.parseDouble(s));
            }
            ++i;
        }
        return v;
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("habilit")) {
            s = String.valueOf(s) + _lib.xml_encode("habilit_d", this.getColValue("habilit_d", row));
        }
        if (tag.equals("area")) {
            s = String.valueOf(s) + _lib.xml_encode("area_d", this.getColValue("area_d", row));
        }
        if (tag.equals("empresa")) {
            String emp = "";
            if (v.length() > 0) {
                emp = v.substring(0, v.indexOf("-") - 1);
            }
            s = String.valueOf(s) + _lib.xml_encode("emp", emp);
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Contrata\u00e7\u00e3o de quadros t\u00e9cnicos");
        }
        boolean qinv = false;
        int i = 0;
        while (i < CBData.QInv.dados.size()) {
            if (CBData.QInv.getColValue("classe", i).equals("315") || CBData.QInv.getColValue("classe", i).equals("401")) {
                qinv = true;
                break;
            }
            ++i;
        }
        if (this.isEmpty() && qinv) {
            err_list.add_msg(new CHValid_Msg("quadros", "Lista vazia"));
        }
        i = 0;
        while (i < this.dados.size()) {
            StringBuffer mask = new StringBuffer("R-RR-RRR-RRR-");
            if (this.col_coop) {
                mask.setCharAt(this.getColIndex("empresa"), 'R');
            }
            TabError[] e = this.isIncompletAll(i, mask.toString());
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                ++ii;
            }
            if (!this.getColValue("area_d", i).equals("")) {
                String area = this.getColValue("area", i);
                if (CBData.turismo.equals("0") && area.startsWith("2")) {
                    err_list.add_msg(new CHValid_Msg("qtecnicos", "Linha " + (i + 1) + ": \u00c1rea Funcional inv\u00e1lida"));
                }
            }
            ++i;
        }
        return err_list;
    }
}

