/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_IdProm_3;
import fme.Http;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;
import fme.fmeComum;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

class CBTabela_Socios
extends CBTabela {
    boolean upd = false;
    Frame_IdProm_3 P01;
    int tab_index = 0;

    public String getPagina() {
        return "IdProm_3";
    }

    CBTabela_Socios() {
        this.P01 = (Frame_IdProm_3)fmeApp.Paginas.getPage("IdProm_3");
        if (this.P01 == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_Socios(Frame_IdProm_3 p, int idx) {
        this.P01 = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.P01.cbd_socios = this;
        this.tag = "Socios";
        this.started = true;
        this.cols = new CHTabColModel[7];
        this.cols[0] = new CHTabColModel("tipo_soc", "Tipo(id)", true, true, false, null);
        this.cols[1] = new CHTabColModel("tipo_soc_d", "\nTipo", false, true, true, null);
        this.cols[2] = new CHTabColModel("pais", "Pa\u00eds (id)", true, true, false, null);
        this.cols[3] = new CHTabColModel("pais_d", "Pa\u00eds", false, true, true, null);
        this.cols[4] = new CHTabColModel("nif", "NIF/NIPC", true, true, true, CFLib.VLD_NIF);
        this.cols[5] = new CHTabColModel("design", "Designa\u00e7\u00e3o", true, true, true, null);
        this.cols[6] = new CHTabColModel("perc", "Particip.<br>%", true, true, true, CFLib.VLD_PERC);
        this.init_dados(4);
        this.init_handler(this.P01.getJTable_Socios());
        this.P01.getJTable_Socios().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P01.getJScrollPane_Socios().getWidth() - 20;
        this.handler.set_col_comboS(1, 0.27, null, CTabelas.TipoPart, 1, 340);
        this.handler.set_col_comboS(3, 0.2, null, CTabelas.Pais, 1, 170);
        this.handler.set_col_text(4, 0.128, null);
        this.handler.set_col_text(5, 0.3, null);
        this.handler.set_col_text(6, 0.1, "R");
    }

    void get_dados_adc(String nif, int nRow) {
        if (!CBData.T.equals("") || !fmeComum.ON) {
            return;
        }
        String url = String.valueOf(fmeComum.atend_pas) + "acesso/formulario/atend-import-adc.php?NIF=" + nif + "&QDR=" + this.tag;
        System.out.println("socios " + nif);
        Http http = new Http(url);
        Document doc = http.doPostRequestDoc("");
        try {
            XPath xp = XPathFactory.newInstance().newXPath();
            String design = xp.evaluate("//fme/" + this.tag + "/nome", doc);
            this.setColValue("design", nRow, design);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("nif") && v.length() == 9 && this.getColValue("design", nRow).equals("") && !CBData.reading_xml) {
            this.get_dados_adc(v, nRow);
        }
        if (colname.equals("tipo_soc_d")) {
            String tipo_soc = "";
            if (v.length() > 0) {
                tipo_soc = CTabelas.TipoPart.lookup(1, v, 0);
            }
            this.setColValue("tipo_soc", nRow, tipo_soc);
        }
        if (colname.equals("tipo_soc")) {
            String tipo_soc_d = "";
            if (v.length() > 0) {
                tipo_soc_d = CTabelas.TipoPart.lookup(0, v, 1);
            }
            this.setColValue("tipo_soc_d", nRow, tipo_soc_d);
        }
        if (colname.equals("pais_d")) {
            String pais = "";
            if (v.length() > 0) {
                pais = CTabelas.Pais.lookup(1, v, 0);
            }
            this.setColValue("pais", nRow, pais);
        }
        if (colname.equals("pais")) {
            String pais_d = "";
            if (v.length() > 0) {
                pais_d = CTabelas.Pais.lookup(0, v, 1);
            }
            this.setColValue("pais_d", nRow, pais_d);
        }
        if (!CBData.reading_xml) {
            this.upd = true;
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        String titulo = "Participantes no Capital do Benefici\u00e1rio";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("socios", "Lista vazia"));
        } else {
            int i = 0;
            while (i < this.dados.size()) {
                TabError[] e = this.isIncompletAll(i, this.getMask(i));
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o", "Linha %L: %T - Neste Caso N\u00e3o Preenche")));
                    ++ii;
                }
                ++i;
            }
            double p = this.getSum("perc");
            if (_lib.round(p) != 100.0 && !this.isEmpty()) {
                err_list.add_msg(new CHValid_Msg("100%", "Deve indicar as Participa\u00e7\u00f5es correspondentes a 100% do Capital"));
            }
            if (!this.isUnique("nif")) {
                err_list.add_msg(new CHValid_Msg("unique", "N\u00e3o podem existir NIF's repetidos"));
            }
        }
        return err_list;
    }

    String getMask(int nRow) {
        String pais;
        StringBuffer mask = new StringBuffer("-R-R-RR");
        String codigo = this.getColValue("tipo_soc", nRow);
        if (codigo != null && codigo.equals("08")) {
            mask.replace(0, 10, "-R----R");
        }
        if ((pais = this.getColValue("pais", nRow)).length() > 0 && pais.equals("PT")) {
            mask.setCharAt(this.getColIndex("nif"), 'R');
        }
        if (codigo != null && codigo.equals("08")) {
            mask.setCharAt(this.getColIndex("nif"), '-');
        }
        return mask.toString();
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("tipo_soc")) {
            s = String.valueOf(s) + _lib.xml_encode("tipo_soc_d", this.getColValue("tipo_soc_d", row));
        }
        if (tag.equals("pais")) {
            s = String.valueOf(s) + _lib.xml_encode("pais_d", this.getColValue("pais_d", row));
        }
        return s;
    }
}

